/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.VisibleForTesting;
import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.MutableLoadStateCollection;
import androidx.paging.PageEvent;
import androidx.paging.TransformablePage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J\u0016\u0010\u0015\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0002J\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u001eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/paging/FlattenedPageEventStorage;", "T", "", "<init>", "()V", "placeholdersBefore", "", "placeholdersAfter", "pages", "Lkotlin/collections/ArrayDeque;", "Landroidx/paging/TransformablePage;", "sourceStates", "Landroidx/paging/MutableLoadStateCollection;", "mediatorStates", "Landroidx/paging/LoadStates;", "receivedFirstEvent", "", "add", "", "event", "Landroidx/paging/PageEvent;", "handlePageDrop", "Landroidx/paging/PageEvent$Drop;", "handleInsert", "Landroidx/paging/PageEvent$Insert;", "handleLoadStateUpdate", "Landroidx/paging/PageEvent$LoadStateUpdate;", "handleStaticList", "Landroidx/paging/PageEvent$StaticList;", "getAsEvents", "", "paging-common"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nCachedPageEventFlow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachedPageEventFlow.kt\nandroidx/paging/FlattenedPageEventStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n1#2:269\n1863#3,2:270\n*S KotlinDebug\n*F\n+ 1 CachedPageEventFlow.kt\nandroidx/paging/FlattenedPageEventStorage\n*L\n216#1:270,2\n*E\n"})
public final class FlattenedPageEventStorage<T> {
    private int placeholdersBefore;
    private int placeholdersAfter;
    @NotNull
    private final ArrayDeque<TransformablePage<T>> pages = new ArrayDeque();
    @NotNull
    private final MutableLoadStateCollection sourceStates = new MutableLoadStateCollection();
    @Nullable
    private LoadStates mediatorStates;
    private boolean receivedFirstEvent;

    public final void add(@NotNull PageEvent<T> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.receivedFirstEvent = true;
        PageEvent<T> pageEvent = event;
        if (pageEvent instanceof PageEvent.Insert) {
            this.handleInsert((PageEvent.Insert)event);
        } else if (pageEvent instanceof PageEvent.Drop) {
            this.handlePageDrop((PageEvent.Drop)event);
        } else if (pageEvent instanceof PageEvent.LoadStateUpdate) {
            this.handleLoadStateUpdate((PageEvent.LoadStateUpdate)event);
        } else if (pageEvent instanceof PageEvent.StaticList) {
            this.handleStaticList((PageEvent.StaticList)event);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void handlePageDrop(PageEvent.Drop<T> event) {
        this.sourceStates.set(event.getLoadType(), LoadState.NotLoading.Companion.getIncomplete$paging_common());
        switch (WhenMappings.$EnumSwitchMapping$0[event.getLoadType().ordinal()]) {
            case 1: {
                this.placeholdersBefore = event.getPlaceholdersRemaining();
                int n = event.getPageCount();
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    this.pages.removeFirst();
                }
                break;
            }
            case 2: {
                this.placeholdersAfter = event.getPlaceholdersRemaining();
                int n = event.getPageCount();
                int n3 = 0;
                while (n3 < n) {
                    int it = n3++;
                    boolean bl = false;
                    this.pages.removeLast();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Page drop type must be prepend or append");
            }
        }
    }

    private final void handleInsert(PageEvent.Insert<T> event) {
        this.sourceStates.set(event.getSourceLoadStates());
        this.mediatorStates = event.getMediatorLoadStates();
        switch (WhenMappings.$EnumSwitchMapping$0[event.getLoadType().ordinal()]) {
            case 3: {
                this.pages.clear();
                this.placeholdersAfter = event.getPlaceholdersAfter();
                this.placeholdersBefore = event.getPlaceholdersBefore();
                this.pages.addAll((Collection)event.getPages());
                break;
            }
            case 1: {
                this.placeholdersBefore = event.getPlaceholdersBefore();
                Iterable $this$forEach$iv = RangesKt.downTo(event.getPages().size() - 1, 0);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl = false;
                    this.pages.addFirst(event.getPages().get(it));
                }
                break;
            }
            case 2: {
                this.placeholdersAfter = event.getPlaceholdersAfter();
                this.pages.addAll((Collection)event.getPages());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void handleLoadStateUpdate(PageEvent.LoadStateUpdate<T> event) {
        this.sourceStates.set(event.getSource());
        this.mediatorStates = event.getMediator();
    }

    private final void handleStaticList(PageEvent.StaticList<T> event) {
        if (event.getSourceLoadStates() != null) {
            this.sourceStates.set(event.getSourceLoadStates());
        }
        if (event.getMediatorLoadStates() != null) {
            this.mediatorStates = event.getMediatorLoadStates();
        }
        this.pages.clear();
        this.placeholdersAfter = 0;
        this.placeholdersBefore = 0;
        this.pages.add(new TransformablePage<T>(0, event.getData()));
    }

    @NotNull
    public final List<PageEvent<T>> getAsEvents() {
        if (!this.receivedFirstEvent) {
            return CollectionsKt.emptyList();
        }
        List events = new ArrayList();
        LoadStates source2 = this.sourceStates.snapshot();
        boolean bl = !((Collection)this.pages).isEmpty() ? events.add(PageEvent.Insert.Companion.Refresh(CollectionsKt.toList((Iterable)this.pages), this.placeholdersBefore, this.placeholdersAfter, source2, this.mediatorStates)) : events.add(new PageEvent.LoadStateUpdate(source2, this.mediatorStates));
        return events;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.PREPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.APPEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadType.REFRESH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

