/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.room.ColumnInfo;
import androidx.room.util.ForeignKeyWithSequence;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.TableInfo;
import androidx.room.util.ViewInfo;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0001\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010 \u001a\u00020\u0003H\u0000\u001a\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0003H\u0000\"\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u0006$"}, d2={"findAffinity", "", "type", "", "readTableInfo", "Landroidx/room/util/TableInfo;", "connection", "Landroidx/sqlite/SQLiteConnection;", "tableName", "readForeignKeys", "", "Landroidx/room/util/TableInfo$ForeignKey;", "readForeignKeyFieldMappings", "", "Landroidx/room/util/ForeignKeyWithSequence;", "stmt", "Landroidx/sqlite/SQLiteStatement;", "readColumns", "", "Landroidx/room/util/TableInfo$Column;", "readIndices", "Landroidx/room/util/TableInfo$Index;", "readIndex", "name", "unique", "", "readFtsColumns", "readFtsOptions", "FTS_OPTIONS", "", "[Ljava/lang/String;", "parseFtsOptions", "createStatement", "readViewInfo", "Landroidx/room/util/ViewInfo;", "viewName", "room-runtime"})
@SourceDebugExtension(value={"SMAP\nSchemaInfoUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaInfoUtil.kt\nandroidx/room/util/SchemaInfoUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,378:1\n774#2:379\n865#2,2:380\n1869#2,2:382\n1056#2:384\n1563#2:385\n1634#2,3:386\n1056#2:389\n1563#2:390\n1634#2,3:391\n774#2:420\n865#2:421\n866#2:424\n1188#3,2:394\n1190#3:419\n108#4:396\n80#4,22:397\n12637#5,2:422\n*S KotlinDebug\n*F\n+ 1 SchemaInfoUtil.kt\nandroidx/room/util/SchemaInfoUtilKt\n*L\n94#1:379\n94#1:380,2\n95#1:382,2\n256#1:384\n256#1:385\n256#1:386,3\n257#1:389\n257#1:390\n257#1:391,3\n360#1:420\n360#1:421\n360#1:424\n328#1:394,2\n328#1:419\n348#1:396\n348#1:397,22\n360#1:422,2\n*E\n"})
public final class SchemaInfoUtilKt {
    @NotNull
    private static final String[] FTS_OPTIONS;

    @ColumnInfo.SQLiteTypeAffinity
    public static final int findAffinity(@Nullable String type2) {
        if (type2 == null) {
            return 5;
        }
        String string2 = type2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        String uppercaseType = string2;
        if (StringsKt.contains$default((CharSequence)uppercaseType, "INT", false, 2, null)) {
            return 3;
        }
        if (StringsKt.contains$default((CharSequence)uppercaseType, "CHAR", false, 2, null) || StringsKt.contains$default((CharSequence)uppercaseType, "CLOB", false, 2, null) || StringsKt.contains$default((CharSequence)uppercaseType, "TEXT", false, 2, null)) {
            return 2;
        }
        if (StringsKt.contains$default((CharSequence)uppercaseType, "BLOB", false, 2, null)) {
            return 5;
        }
        if (StringsKt.contains$default((CharSequence)uppercaseType, "REAL", false, 2, null) || StringsKt.contains$default((CharSequence)uppercaseType, "FLOA", false, 2, null) || StringsKt.contains$default((CharSequence)uppercaseType, "DOUB", false, 2, null)) {
            return 4;
        }
        return 1;
    }

    @NotNull
    public static final TableInfo readTableInfo(@NotNull SQLiteConnection connection, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Map<String, TableInfo.Column> columns = SchemaInfoUtilKt.readColumns(connection, tableName);
        Set<TableInfo.ForeignKey> foreignKeys = SchemaInfoUtilKt.readForeignKeys(connection, tableName);
        Set<TableInfo.Index> indices = SchemaInfoUtilKt.readIndices(connection, tableName);
        return new TableInfo(tableName, columns, foreignKeys, indices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Set<TableInfo.ForeignKey> readForeignKeys(SQLiteConnection connection, String tableName) {
        AutoCloseable autoCloseable = connection.prepare("PRAGMA foreign_key_list(`" + tableName + "`)");
        Throwable throwable = null;
        try {
            Set<TableInfo.ForeignKey> set2;
            SQLiteStatement stmt = (SQLiteStatement)autoCloseable;
            boolean bl = false;
            int idColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "id");
            int seqColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "seq");
            int tableColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "table");
            int onDeleteColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "on_delete");
            int onUpdateColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "on_update");
            List<ForeignKeyWithSequence> ordered = SchemaInfoUtilKt.readForeignKeyFieldMappings(stmt);
            stmt.reset();
            Set<TableInfo.ForeignKey> $this$readForeignKeys_u24lambda_u243_u24lambda_u242 = set2 = SetsKt.createSetBuilder();
            boolean bl2 = false;
            while (stmt.step()) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                long seq = stmt.getLong(seqColumnIndex);
                if (seq != 0L) continue;
                int id = (int)stmt.getLong(idColumnIndex);
                List myColumns = new ArrayList();
                List refColumns = new ArrayList();
                Iterable iterable = ordered;
                boolean $i$f$filter = false;
                Iterator iterator2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ForeignKeyWithSequence it = (ForeignKeyWithSequence)element$iv$iv;
                    boolean bl3 = false;
                    if (!(it.getId() == id)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ForeignKeyWithSequence key = (ForeignKeyWithSequence)element$iv;
                    boolean bl4 = false;
                    myColumns.add(key.getFrom());
                    refColumns.add(key.getTo());
                }
                $this$readForeignKeys_u24lambda_u243_u24lambda_u242.add(new TableInfo.ForeignKey(stmt.getText(tableColumnIndex), stmt.getText(onDeleteColumnIndex), stmt.getText(onUpdateColumnIndex), myColumns, refColumns));
            }
            Set<TableInfo.ForeignKey> set3 = SetsKt.build(set2);
            return set3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private static final List<ForeignKeyWithSequence> readForeignKeyFieldMappings(SQLiteStatement stmt) {
        List<ForeignKeyWithSequence> list2;
        int idColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "id");
        int seqColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "seq");
        int fromColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "from");
        int toColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "to");
        List<ForeignKeyWithSequence> $this$readForeignKeyFieldMappings_u24lambda_u244 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (stmt.step()) {
            $this$readForeignKeyFieldMappings_u24lambda_u244.add(new ForeignKeyWithSequence((int)stmt.getLong(idColumnIndex), (int)stmt.getLong(seqColumnIndex), stmt.getText(fromColumnIndex), stmt.getText(toColumnIndex)));
        }
        return CollectionsKt.sorted(CollectionsKt.build(list2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, TableInfo.Column> readColumns(SQLiteConnection connection, String tableName) {
        AutoCloseable autoCloseable = connection.prepare("PRAGMA table_info(`" + tableName + "`)");
        Throwable throwable = null;
        try {
            Map<String, TableInfo.Column> map2;
            SQLiteStatement stmt = (SQLiteStatement)autoCloseable;
            boolean bl = false;
            if (!stmt.step()) {
                Map<String, TableInfo.Column> map3 = MapsKt.emptyMap();
                return map3;
            }
            int nameIndex = SQLiteStatementUtil.columnIndexOf(stmt, "name");
            int typeIndex = SQLiteStatementUtil.columnIndexOf(stmt, "type");
            int notNullIndex = SQLiteStatementUtil.columnIndexOf(stmt, "notnull");
            int pkIndex = SQLiteStatementUtil.columnIndexOf(stmt, "pk");
            int defaultValueIndex = SQLiteStatementUtil.columnIndexOf(stmt, "dflt_value");
            Map<String, TableInfo.Column> $this$readColumns_u24lambda_u246_u24lambda_u245 = map2 = MapsKt.createMapBuilder();
            boolean bl2 = false;
            do {
                String name = stmt.getText(nameIndex);
                String type2 = stmt.getText(typeIndex);
                boolean notNull = stmt.getLong(notNullIndex) != 0L;
                int primaryKeyPosition = (int)stmt.getLong(pkIndex);
                String defaultValue = stmt.isNull(defaultValueIndex) ? null : stmt.getText(defaultValueIndex);
                $this$readColumns_u24lambda_u246_u24lambda_u245.put(name, new TableInfo.Column(name, type2, notNull, primaryKeyPosition, defaultValue, 2));
            } while (stmt.step());
            Map<String, TableInfo.Column> map4 = MapsKt.build(map2);
            return map4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set<TableInfo.Index> readIndices(SQLiteConnection connection, String tableName) {
        AutoCloseable autoCloseable = connection.prepare("PRAGMA index_list(`" + tableName + "`)");
        Throwable throwable = null;
        try {
            Set<TableInfo.Index> set2;
            SQLiteStatement stmt = (SQLiteStatement)autoCloseable;
            boolean bl = false;
            int nameColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "name");
            int originColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "origin");
            int uniqueIndex = SQLiteStatementUtil.columnIndexOf(stmt, "unique");
            if (nameColumnIndex == -1 || originColumnIndex == -1 || uniqueIndex == -1) {
                Set<TableInfo.Index> set3 = null;
                return set3;
            }
            Set<TableInfo.Index> $this$readIndices_u24lambda_u248_u24lambda_u247 = set2 = SetsKt.createSetBuilder();
            boolean bl2 = false;
            while (stmt.step()) {
                TableInfo.Index index2;
                boolean unique;
                String origin2 = stmt.getText(originColumnIndex);
                if (!Intrinsics.areEqual("c", origin2)) continue;
                String name = stmt.getText(nameColumnIndex);
                boolean bl3 = unique = stmt.getLong(uniqueIndex) == 1L;
                if (SchemaInfoUtilKt.readIndex(connection, name, unique) == null) {
                    Set<TableInfo.Index> set4 = null;
                    return set4;
                }
                TableInfo.Index index3 = index2;
                $this$readIndices_u24lambda_u248_u24lambda_u247.add(index3);
            }
            Set<TableInfo.Index> set5 = SetsKt.build(set2);
            return set5;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final TableInfo.Index readIndex(SQLiteConnection connection, String name, boolean unique) {
        TableInfo.Index index2;
        AutoCloseable autoCloseable = connection.prepare("PRAGMA index_xinfo(`" + name + "`)");
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            String order;
            SQLiteStatement stmt = (SQLiteStatement)autoCloseable;
            boolean bl = false;
            int seqnoColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "seqno");
            int cidColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "cid");
            int nameColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "name");
            int descColumnIndex = SQLiteStatementUtil.columnIndexOf(stmt, "desc");
            if (seqnoColumnIndex == -1 || cidColumnIndex == -1 || nameColumnIndex == -1 || descColumnIndex == -1) {
                TableInfo.Index index3 = null;
                return index3;
            }
            Map columnsMap = new LinkedHashMap();
            Map ordersMap = new LinkedHashMap();
            while (stmt.step()) {
                int cid = (int)stmt.getLong(cidColumnIndex);
                if (cid < 0) continue;
                int seq = (int)stmt.getLong(seqnoColumnIndex);
                String columnName = stmt.getText(nameColumnIndex);
                order = stmt.getLong(descColumnIndex) > 0L ? "DESC" : "ASC";
                columnsMap.put(seq, columnName);
                ordersMap.put(seq, order);
            }
            Iterable $this$sortedBy$iv = columnsMap.entrySet();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    Map.Entry it = (Map.Entry)a2;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getKey();
                    it = (Map.Entry)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getKey()));
                }
            });
            boolean $i$f$map = false;
            order = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add((String)it.getValue());
            }
            List<String> columns = CollectionsKt.toList((List)destination$iv$iv);
            Iterable $this$sortedBy$iv2 = ordersMap.entrySet();
            boolean $i$f$sortedBy2 = false;
            $this$sortedBy$iv2 = CollectionsKt.sortedWith($this$sortedBy$iv2, new Comparator(){

                public final int compare(T a2, T b2) {
                    Map.Entry it = (Map.Entry)a2;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getKey();
                    it = (Map.Entry)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getKey()));
                }
            });
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry bl2 = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add((String)it.getValue());
            }
            List<String> orders = CollectionsKt.toList((List)destination$iv$iv2);
            index2 = new TableInfo.Index(name, unique, columns, orders);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return index2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Set<String> readFtsColumns(@NotNull SQLiteConnection connection, @NotNull String tableName) {
        Set<String> set2;
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Set<String> $this$readFtsColumns_u24lambda_u2415 = set2 = SetsKt.createSetBuilder();
        boolean bl = false;
        AutoCloseable autoCloseable = connection.prepare("PRAGMA table_info(`" + tableName + "`)");
        Throwable throwable = null;
        try {
            SQLiteStatement stmt = (SQLiteStatement)autoCloseable;
            boolean bl2 = false;
            if (stmt.step()) {
                int nameIndex = SQLiteStatementUtil.columnIndexOf(stmt, "name");
                do {
                    $this$readFtsColumns_u24lambda_u2415.add(stmt.getText(nameIndex));
                } while (stmt.step());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return SetsKt.build(set2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Set<String> readFtsOptions(@NotNull SQLiteConnection connection, @NotNull String tableName) {
        String string2;
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        AutoCloseable autoCloseable = connection.prepare("SELECT * FROM sqlite_master WHERE `name` = '" + tableName + '\'');
        Throwable throwable = null;
        try {
            SQLiteStatement stmt = (SQLiteStatement)autoCloseable;
            boolean bl = false;
            string2 = stmt.step() ? stmt.getText(SQLiteStatementUtil.columnIndexOf(stmt, "sql")) : "";
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        String sql = string2;
        return SchemaInfoUtilKt.parseFtsOptions(sql);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> parseFtsOptions(@NotNull String createStatement) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(createStatement, "createStatement");
        if (((CharSequence)createStatement).length() == 0) {
            return SetsKt.emptySet();
        }
        String string2 = createStatement.substring(StringsKt.indexOf$default((CharSequence)createStatement, '(', 0, false, 6, null) + 1, StringsKt.lastIndexOf$default((CharSequence)createStatement, ')', 0, false, 6, null));
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String argsString = string2;
        List args = new ArrayList();
        ArrayDeque<Character> quoteStack = new ArrayDeque<Character>();
        int lastDelimiterIndex = 0;
        lastDelimiterIndex = -1;
        CharSequence $this$forEachIndexed$iv = argsString;
        boolean $i$f$forEachIndexed22 = false;
        int index$iv = 0;
        for (int j = 0; j < $this$forEachIndexed$iv.length(); ++j) {
            void value;
            char item$iv = $this$forEachIndexed$iv.charAt(j);
            int n = index$iv++;
            char c = item$iv;
            int i2 = n;
            boolean bl = false;
            switch (value) {
                case 34: 
                case 39: 
                case 96: {
                    if (quoteStack.isEmpty()) {
                        quoteStack.addFirst(Character.valueOf((char)value));
                        break;
                    }
                    Character c2 = (Character)quoteStack.firstOrNull();
                    void var13_18 = value;
                    if (c2 == null || c2.charValue() != var13_18) break;
                    CollectionsKt.removeLast((List)quoteStack);
                    break;
                }
                case 91: {
                    if (!quoteStack.isEmpty()) break;
                    quoteStack.addFirst(Character.valueOf((char)value));
                    break;
                }
                case 93: {
                    if (quoteStack.isEmpty()) break;
                    Character c3 = (Character)quoteStack.firstOrNull();
                    char c4 = '[';
                    if (c3 == null || c3.charValue() != c4) break;
                    CollectionsKt.removeLast((List)quoteStack);
                    break;
                }
                case 44: {
                    void $this$trim$iv;
                    if (!quoteStack.isEmpty()) break;
                    Intrinsics.checkNotNullExpressionValue(argsString.substring(lastDelimiterIndex + 1, i2), "substring(...)");
                    List list2 = args;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl2 = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    list2.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                    lastDelimiterIndex = i2;
                }
            }
        }
        String string3 = argsString.substring(lastDelimiterIndex + 1);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        args.add(((Object)StringsKt.trim((CharSequence)string3)).toString());
        Iterable $i$f$forEachIndexed22 = args;
        boolean $i$f$filter = false;
        void var8_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block14: {
                String arg = (String)element$iv$iv;
                boolean bl4 = false;
                String[] $this$any$iv = FTS_OPTIONS;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    String element$iv;
                    String validOption = element$iv = $this$any$iv[j];
                    boolean bl5 = false;
                    if (!StringsKt.startsWith$default(arg, validOption, false, 2, null)) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set<String> options2 = CollectionsKt.toSet((List)destination$iv$iv);
        return options2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ViewInfo readViewInfo(@NotNull SQLiteConnection connection, @NotNull String viewName) {
        ViewInfo viewInfo;
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(viewName, "viewName");
        AutoCloseable autoCloseable = connection.prepare("SELECT name, sql FROM sqlite_master WHERE type = 'view' AND name = '" + viewName + '\'');
        Throwable throwable = null;
        try {
            SQLiteStatement stmt = (SQLiteStatement)autoCloseable;
            boolean bl = false;
            viewInfo = stmt.step() ? new ViewInfo(stmt.getText(0), stmt.getText(1)) : new ViewInfo(viewName, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return viewInfo;
    }

    static {
        String[] stringArray = new String[]{"tokenize=", "compress=", "content=", "languageid=", "matchinfo=", "notindexed=", "order=", "prefix=", "uncompress="};
        FTS_OPTIONS = stringArray;
    }
}

