/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.networknt.schema.format.AbstractRFC3986Format;
import com.networknt.schema.format.IPv6Format;
import java.net.URI;

public class IriFormat
extends AbstractRFC3986Format {
    @Override
    protected boolean validate(URI uri) {
        boolean result2 = uri.isAbsolute();
        if (result2) {
            String authority = uri.getAuthority();
            if (authority != null && IPv6Format.PATTERN.matcher(authority).matches()) {
                return false;
            }
            String query = uri.getRawQuery();
            if (query != null && (query.indexOf(91) != -1 || query.indexOf(93) != -1)) {
                return false;
            }
        }
        return result2;
    }

    @Override
    public String getName() {
        return "iri";
    }

    @Override
    public String getMessageKey() {
        return "format.iri";
    }
}

