/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.jackson.deserializer.cbor.COSEKeyEnvelope;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttestedCredentialDataConverter {
    private static final String ATTESTED_CREDENTIAL_DATA_MUST_NOT_BE_NULL = "attestedCredentialData must not be null";
    private static final int AAGUID_LENGTH = 16;
    private static final int L_LENGTH = 2;
    private static final int AAGUID_INDEX = 0;
    private static final int L_INDEX = 16;
    private static final int CREDENTIAL_ID_INDEX = 18;
    private final CborConverter cborConverter;

    public AttestedCredentialDataConverter(@NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.cborConverter = objectConverter.getCborConverter();
    }

    private static AttestedCredentialData createAttestedCredentialData(@NotNull AAGUID aaguid, @NotNull byte[] credentialId, @NotNull COSEKey coseKey) {
        return new AttestedCredentialData(aaguid, credentialId, coseKey);
    }

    private static void assertCoseKey(@Nullable COSEKey coseKey) {
        AssertUtil.notNull(coseKey, "coseKey must not be null");
    }

    @NotNull
    public byte[] convert(@NotNull AttestedCredentialData attestationData) {
        try {
            AssertUtil.notNull(attestationData, "attestationData must not be null");
            AssertUtil.notNull(attestationData.getAaguid(), "aaguid must not be null");
            AssertUtil.notNull(attestationData.getCredentialId(), "credentialId must not be null");
            AttestedCredentialDataConverter.assertCoseKey(attestationData.getCOSEKey());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(attestationData.getAaguid().getBytes());
            byteArrayOutputStream.write(UnsignedNumberUtil.toBytes(attestationData.getCredentialId().length));
            byteArrayOutputStream.write(attestationData.getCredentialId());
            byteArrayOutputStream.write(this.convert(attestationData.getCOSEKey()));
            return byteArrayOutputStream.toByteArray();
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public AttestedCredentialData convert(@NotNull ByteBuffer attestedCredentialData) {
        try {
            AssertUtil.notNull(attestedCredentialData, ATTESTED_CREDENTIAL_DATA_MUST_NOT_BE_NULL);
            byte[] aaguidBytes = new byte[16];
            attestedCredentialData.get(aaguidBytes, 0, 16);
            AAGUID aaguid = new AAGUID(aaguidBytes);
            int length = UnsignedNumberUtil.getUnsignedShort(attestedCredentialData);
            byte[] credentialId = new byte[length];
            attestedCredentialData.get(credentialId, 0, length);
            byte[] remaining = new byte[attestedCredentialData.remaining()];
            attestedCredentialData.get(remaining);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(remaining);
            COSEKeyEnvelope coseKeyEnvelope = this.convertToCredentialPublicKey(byteArrayInputStream);
            COSEKey coseKey = coseKeyEnvelope.getCOSEKey();
            AttestedCredentialDataConverter.assertCoseKey(coseKey);
            AttestedCredentialData result2 = AttestedCredentialDataConverter.createAttestedCredentialData(aaguid, credentialId, coseKey);
            int extensionsBufferLength = remaining.length - coseKeyEnvelope.getLength();
            ((Buffer)attestedCredentialData).position(attestedCredentialData.position() - extensionsBufferLength);
            return result2;
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public AttestedCredentialData convert(@NotNull byte[] attestedCredentialData) {
        try {
            AssertUtil.notNull(attestedCredentialData, ATTESTED_CREDENTIAL_DATA_MUST_NOT_BE_NULL);
            return this.convert(ByteBuffer.wrap(attestedCredentialData));
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public byte[] extractCredentialId(@NotNull byte[] attestedCredentialData) {
        AssertUtil.notNull(attestedCredentialData, ATTESTED_CREDENTIAL_DATA_MUST_NOT_BE_NULL);
        byte[] lengthBytes = Arrays.copyOfRange(attestedCredentialData, 16, 18);
        int credentialIdLength = UnsignedNumberUtil.getUnsignedShort(lengthBytes);
        return Arrays.copyOfRange(attestedCredentialData, 18, 18 + credentialIdLength);
    }

    @NotNull
    COSEKeyEnvelope convertToCredentialPublicKey(@NotNull InputStream inputStream2) {
        AssertUtil.notNull(inputStream2, "inputStream must not be null");
        return this.cborConverter.readValue(inputStream2, COSEKeyEnvelope.class);
    }

    @NotNull
    byte[] convert(@NotNull COSEKey coseKey) {
        AttestedCredentialDataConverter.assertCoseKey(coseKey);
        return this.cborConverter.writeValueAsBytes(coseKey);
    }
}

