/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.PublicKeyCredentialEntity;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PublicKeyCredentialUserEntity
extends PublicKeyCredentialEntity {
    private final byte[] id;
    private final String displayName;

    @JsonCreator
    public PublicKeyCredentialUserEntity(@JsonProperty(value="id") @NotNull byte[] id, @JsonProperty(value="name") @NotNull String name, @JsonProperty(value="displayName") @NotNull String displayName) {
        super(name);
        AssertUtil.notNull(name, "name must not be null");
        AssertUtil.notNull(displayName, "displayName must not be null");
        this.id = id;
        this.displayName = displayName;
    }

    @NotNull
    public byte[] getId() {
        return ArrayUtil.clone(this.id);
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PublicKeyCredentialUserEntity that = (PublicKeyCredentialUserEntity)o;
        return Arrays.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName);
    }

    @Override
    public int hashCode() {
        int result2 = Objects.hash(super.hashCode(), this.displayName);
        result2 = 31 * result2 + Arrays.hashCode(this.id);
        return result2;
    }

    @Override
    public String toString() {
        return "PublicKeyCredentialUserEntity(id=" + ArrayUtil.toHexString(this.id) + ", displayName=" + this.displayName + ")";
    }
}

