/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMUPublicId;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ECCUnique
implements TPMUPublicId {
    private final byte[] x;
    private final byte[] y;

    public ECCUnique(@NotNull byte[] x2, @NotNull byte[] y2) {
        AssertUtil.notNull(x2, "x must not be null");
        AssertUtil.notNull(y2, "y must not be null");
        this.x = x2;
        this.y = y2;
    }

    @NotNull
    public byte[] getX() {
        return ArrayUtil.clone(this.x);
    }

    @NotNull
    public byte[] getY() {
        return ArrayUtil.clone(this.y);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECCUnique eccUnique = (ECCUnique)o;
        return Arrays.equals(this.x, eccUnique.x) && Arrays.equals(this.y, eccUnique.y);
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.x);
        result2 = 31 * result2 + Arrays.hashCode(this.y);
        return result2;
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(2 + this.x.length + 2 + this.y.length);
        buffer.put(UnsignedNumberUtil.toBytes(this.x.length));
        buffer.put(this.x);
        buffer.put(UnsignedNumberUtil.toBytes(this.y.length));
        buffer.put(this.y);
        return buffer.array();
    }
}

