/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMTHA;
import com.webauthn4j.data.attestation.statement.TPMUAttest;
import com.webauthn4j.data.attestation.statement.TPMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TPMSCertifyInfo
implements TPMUAttest {
    private final TPMTHA name;
    private final TPMTHA qualifiedName;

    public TPMSCertifyInfo(@NotNull TPMTHA name, @NotNull TPMTHA qualifiedName) {
        this.name = name;
        this.qualifiedName = qualifiedName;
    }

    @NotNull
    public TPMTHA getName() {
        return this.name;
    }

    @NotNull
    public TPMTHA getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        try {
            ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
            TPMUtil.writeSizedArray(outputStream2, this.name.getBytes());
            TPMUtil.writeSizedArray(outputStream2, this.qualifiedName.getBytes());
            return outputStream2.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMSCertifyInfo that = (TPMSCertifyInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.qualifiedName, that.qualifiedName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.qualifiedName);
    }
}

