/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.TokenBinding;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.util.AssertUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectedClientData {
    private final ClientDataType type;
    private final Challenge challenge;
    private final Origin origin;
    private final Boolean crossOrigin;
    private final TokenBinding tokenBinding;

    @JsonCreator
    public CollectedClientData(@JsonProperty(value="type") @NotNull ClientDataType type2, @JsonProperty(value="challenge") @NotNull Challenge challenge2, @JsonProperty(value="origin") @NotNull Origin origin2, @JsonProperty(value="crossOrigin") @Nullable Boolean crossOrigin, @JsonProperty(value="tokenBinding") @Nullable TokenBinding tokenBinding) {
        AssertUtil.notNull(type2, "type must not be null");
        AssertUtil.notNull(challenge2, "challenge must not be null");
        AssertUtil.notNull(origin2, "origin must not be null");
        this.type = type2;
        this.challenge = challenge2;
        this.origin = origin2;
        this.crossOrigin = crossOrigin;
        this.tokenBinding = tokenBinding;
    }

    public CollectedClientData(@JsonProperty(value="type") @NotNull ClientDataType type2, @JsonProperty(value="challenge") @NotNull Challenge challenge2, @JsonProperty(value="origin") @NotNull Origin origin2, @JsonProperty(value="tokenBinding") @Nullable TokenBinding tokenBinding) {
        this(type2, challenge2, origin2, null, tokenBinding);
    }

    @NotNull
    public ClientDataType getType() {
        return this.type;
    }

    @NotNull
    public Challenge getChallenge() {
        return this.challenge;
    }

    @NotNull
    public Origin getOrigin() {
        return this.origin;
    }

    @NotNull
    public Boolean getCrossOrigin() {
        return this.crossOrigin;
    }

    @Nullable
    public TokenBinding getTokenBinding() {
        return this.tokenBinding;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectedClientData that = (CollectedClientData)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.challenge, that.challenge) && Objects.equals(this.origin, that.origin) && Objects.equals(this.crossOrigin, that.crossOrigin) && Objects.equals(this.tokenBinding, that.tokenBinding);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.challenge, this.origin, this.crossOrigin, this.tokenBinding);
    }

    public String toString() {
        return "CollectedClientData(type=" + this.type + ", challenge=" + this.challenge + ", origin=" + this.origin + ", crossOrigin=" + this.crossOrigin + ", tokenBinding=" + this.tokenBinding + ")";
    }
}

