/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.data.CoreAuthenticationParameters;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.AssertionSignatureVerifier;
import com.webauthn4j.verifier.AuthenticatorExtensionVerifier;
import com.webauthn4j.verifier.BeanAssertUtil;
import com.webauthn4j.verifier.CoreAuthenticationObject;
import com.webauthn4j.verifier.CoreMaliciousCounterValueHandler;
import com.webauthn4j.verifier.CustomCoreAuthenticationVerifier;
import com.webauthn4j.verifier.DefaultCoreMaliciousCounterValueHandler;
import com.webauthn4j.verifier.RpIdHashVerifier;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import com.webauthn4j.verifier.exception.NotAllowedCredentialIdException;
import com.webauthn4j.verifier.exception.UserNotPresentException;
import com.webauthn4j.verifier.exception.UserNotVerifiedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreAuthenticationDataVerifier {
    private final RpIdHashVerifier rpIdHashVerifier = new RpIdHashVerifier();
    private final AuthenticatorExtensionVerifier authenticatorExtensionVerifier = new AuthenticatorExtensionVerifier();
    private final List<CustomCoreAuthenticationVerifier> customAuthenticationVerifiers;
    private AssertionSignatureVerifier assertionSignatureVerifier = new AssertionSignatureVerifier();
    private CoreMaliciousCounterValueHandler coreMaliciousCounterValueHandler = new DefaultCoreMaliciousCounterValueHandler();

    public CoreAuthenticationDataVerifier(@NotNull List<CustomCoreAuthenticationVerifier> customAuthenticationVerifiers) {
        this.customAuthenticationVerifiers = customAuthenticationVerifiers;
    }

    public CoreAuthenticationDataVerifier() {
        this(new ArrayList<CustomCoreAuthenticationVerifier>());
    }

    protected CoreAuthenticationDataVerifier(@NotNull List<CustomCoreAuthenticationVerifier> customAuthenticationVerifiers, @NotNull AssertionSignatureVerifier assertionSignatureVerifier) {
        AssertUtil.notNull(customAuthenticationVerifiers, "customAuthenticationVerifiers must not be null");
        AssertUtil.notNull(assertionSignatureVerifier, "assertionSignatureVerifier must not be null");
        this.customAuthenticationVerifiers = customAuthenticationVerifiers;
        this.assertionSignatureVerifier = assertionSignatureVerifier;
    }

    public void verify(@NotNull CoreAuthenticationData authenticationData, @NotNull CoreAuthenticationParameters authenticationParameters) {
        BeanAssertUtil.validate(authenticationData);
        AssertUtil.notNull(authenticationParameters, "authenticationParameters must not be null");
        byte[] credentialId = authenticationData.getCredentialId();
        List<byte[]> allowCredentials = authenticationParameters.getAllowCredentials();
        this.verifyCredentialId(credentialId, allowCredentials);
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        CoreServerProperty serverProperty = authenticationParameters.getServerProperty();
        BeanAssertUtil.validate(authenticatorData);
        this.verifyAuthenticatorData(authenticatorData);
        CoreAuthenticator authenticator = authenticationParameters.getAuthenticator();
        CoreAuthenticationObject authenticationObject = this.createCoreAuthenticationObject(authenticationData, authenticationParameters);
        this.rpIdHashVerifier.verify(authenticatorData.getRpIdHash(), serverProperty);
        if (authenticationParameters.isUserPresenceRequired() && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Verifier is configured to check user present, but UP flag in authenticatorData is not set.");
        }
        if (authenticationParameters.isUserVerificationRequired() && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Verifier is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        this.authenticatorExtensionVerifier.verify(authenticationExtensionsAuthenticatorOutputs);
        this.assertionSignatureVerifier.verify(authenticationData, authenticator.getAttestedCredentialData().getCOSEKey());
        long presentedSignCount = authenticatorData.getSignCount();
        long storedSignCount = authenticator.getCounter();
        if (presentedSignCount > 0L || storedSignCount > 0L) {
            if (presentedSignCount > storedSignCount) {
                authenticator.setCounter(presentedSignCount);
            } else {
                this.coreMaliciousCounterValueHandler.maliciousCounterValueDetected(authenticationObject);
            }
        }
        for (CustomCoreAuthenticationVerifier customAuthenticationVerifier : this.customAuthenticationVerifiers) {
            customAuthenticationVerifier.verify(authenticationObject);
        }
    }

    @NotNull
    protected CoreAuthenticationObject createCoreAuthenticationObject(@NotNull CoreAuthenticationData authenticationData, @NotNull CoreAuthenticationParameters authenticationParameters) {
        byte[] credentialId = authenticationData.getCredentialId();
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        byte[] authenticatorDataBytes = authenticationData.getAuthenticatorDataBytes();
        byte[] clientDataHash = authenticationData.getClientDataHash();
        CoreServerProperty serverProperty = authenticationParameters.getServerProperty();
        CoreAuthenticator authenticator = authenticationParameters.getAuthenticator();
        AssertUtil.notNull(authenticatorData, "authenticatorData must not be null");
        return new CoreAuthenticationObject(credentialId, authenticatorData, authenticatorDataBytes, clientDataHash, serverProperty, authenticator);
    }

    void verifyCredentialId(byte[] credentialId, @Nullable List<byte[]> allowCredentials) {
        if (allowCredentials != null && allowCredentials.stream().noneMatch(item2 -> Arrays.equals(item2, credentialId))) {
            throw new NotAllowedCredentialIdException("credentialId not listed in allowCredentials is used.");
        }
    }

    void verifyAuthenticatorData(@NotNull AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() != null) {
            throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
        }
    }

    @NotNull
    public CoreMaliciousCounterValueHandler getMaliciousCounterValueHandler() {
        return this.coreMaliciousCounterValueHandler;
    }

    public void setMaliciousCounterValueHandler(@NotNull CoreMaliciousCounterValueHandler coreMaliciousCounterValueHandler) {
        AssertUtil.notNull(coreMaliciousCounterValueHandler, "maliciousCounterValueHandler must not be null");
        this.coreMaliciousCounterValueHandler = coreMaliciousCounterValueHandler;
    }

    @NotNull
    public List<CustomCoreAuthenticationVerifier> getCustomAuthenticationVerifiers() {
        return this.customAuthenticationVerifiers;
    }
}

