/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class CharValue
extends IntegerValueConstant<Character> {
    public CharValue(char value) {
        super(Character.valueOf(value));
    }

    @Override
    @NotNull
    public SimpleType getType(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        SimpleType simpleType = module2.getBuiltIns().getCharType();
        Intrinsics.checkNotNullExpressionValue(simpleType, "getCharType(...)");
        return simpleType;
    }

    @Override
    @NotNull
    public String toString() {
        String string2 = "\\u%04X ('%s')";
        Object[] objectArray = new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        return string3;
    }

    private final String getPrintablePart(char c) {
        String string2;
        switch (c) {
            case '\b': {
                string2 = "\\b";
                break;
            }
            case '\t': {
                string2 = "\\t";
                break;
            }
            case '\n': {
                string2 = "\\n";
                break;
            }
            case '\f': {
                string2 = "\\f";
                break;
            }
            case '\r': {
                string2 = "\\r";
                break;
            }
            default: {
                string2 = this.isPrintableUnicode(c) ? String.valueOf(c) : "?";
            }
        }
        return string2;
    }

    private final boolean isPrintableUnicode(char c) {
        byte t = (byte)Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }
}

