/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TerminalWidth {
    private static final int UNKNOWN_WIDTH = -1;

    public static void main(String[] args) {
        System.out.println("terminalWidth: " + new TerminalWidth().getTerminalWidth());
    }

    public int getTerminalWidth() {
        String width2 = System.getenv("COLUMNS");
        if (width2 != null) {
            try {
                return Integer.parseInt(width2);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        try {
            return this.getTerminalWidth2();
        }
        catch (IOException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTerminalWidth2() throws IOException {
        boolean isLinux;
        String osName = System.getProperty("os.name");
        boolean isOSX = osName.startsWith("Mac OS X");
        boolean bl = isLinux = osName.startsWith("Linux") || osName.startsWith("LINUX");
        if (!isLinux && !isOSX) {
            return -1;
        }
        ProcessBuilder builder = new ProcessBuilder(this.whichSh().toString(), "-c", "stty -a < /dev/tty");
        builder.redirectErrorStream(true);
        Process process2 = builder.start();
        ByteArrayOutputStream resultBytes = new ByteArrayOutputStream();
        try (InputStream in = process2.getInputStream();){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) >= 0) {
                resultBytes.write(buf, 0, len);
            }
        }
        String result2 = new String(resultBytes.toByteArray());
        try {
            if (process2.waitFor() != 0) {
                return -1;
            }
        }
        catch (InterruptedException e) {
            return -1;
        }
        String pattern = isOSX ? "(\\d+) columns" : "columns (\\d+)";
        Matcher m = Pattern.compile(pattern).matcher(result2);
        if (!m.find()) {
            return -1;
        }
        result2 = m.group(1);
        try {
            return Integer.parseInt(result2);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private File whichSh() throws IOException {
        String path = System.getenv("PATH");
        if (path != null) {
            for (String dir : path.split(Pattern.quote(File.pathSeparator))) {
                File command2 = new File(dir.trim(), "sh");
                if (!command2.canExecute()) continue;
                return command2.getAbsoluteFile();
            }
        }
        throw new IOException("No command 'sh' on path " + path);
    }
}

