/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import com.jetbrains.JBR;
import com.jetbrains.SharedTextures;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.swing.SwingPainter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/skiko/swing/AcceleratedSwingPainter;", "Lorg/jetbrains/skiko/swing/SwingPainter;", "()V", "gc", "Ljava/awt/GraphicsConfiguration;", "imageWrapper", "Ljava/awt/Image;", "sharedTextures", "Lcom/jetbrains/SharedTextures;", "kotlin.jvm.PlatformType", "texturePtr", "", "dispose", "", "paint", "g", "Ljava/awt/Graphics2D;", "surface", "Lorg/jetbrains/skia/Surface;", "texture", "skiko"})
public final class AcceleratedSwingPainter
implements SwingPainter {
    private final SharedTextures sharedTextures;
    @Nullable
    private Image imageWrapper;
    private long texturePtr;
    @NotNull
    private GraphicsConfiguration gc;

    public AcceleratedSwingPainter() {
        if (!JBR.isSharedTexturesSupported() || JBR.getSharedTextures().getTextureType() != 1) {
            throw new RenderException("Shared textures are not supported", null, 2, null);
        }
        this.sharedTextures = JBR.getSharedTextures();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Intrinsics.checkNotNullExpressionValue(graphicsConfiguration, "getDefaultConfiguration(...)");
        this.gc = graphicsConfiguration;
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull Surface surface, long texture) {
        Intrinsics.checkNotNullParameter(g, "g");
        Intrinsics.checkNotNullParameter(surface, "surface");
        if (!Intrinsics.areEqual(g.getDeviceConfiguration(), this.gc) || this.texturePtr != texture || this.imageWrapper == null) {
            GraphicsConfiguration graphicsConfiguration = g.getDeviceConfiguration();
            Intrinsics.checkNotNullExpressionValue(graphicsConfiguration, "getDeviceConfiguration(...)");
            this.gc = graphicsConfiguration;
            this.texturePtr = texture;
            this.imageWrapper = this.sharedTextures.wrapTexture(this.gc, this.texturePtr);
        }
        g.drawImage(this.imageWrapper, 0, 0, null);
    }

    @Override
    public void dispose() {
    }
}

