/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;
import org.jetbrains.skiko.swing.SwingPainter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0080\u0001\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002Jv\u0010(\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010\u001d2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002Jd\u0010*\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010+\u001a\u00020\r2\b\b\u0002\u0010,\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\r2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0002J \u0010-\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00172\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000bH\u0016J\u0018\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/skiko/swing/SoftwareSwingPainter;", "Lorg/jetbrains/skiko/swing/SwingPainter;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;)V", "bitmap", "Lorg/jetbrains/skia/Bitmap;", "bufferedImage", "Ljava/awt/image/BufferedImage;", "createImageFromBytes", "pBytes", "", "width", "", "height", "dispose", "", "doDraw", "op", "Ljava/awt/image/BufferedImageOp;", "image", "Ljava/awt/Image;", "invG", "Ljava/awt/Graphics2D;", "hasDestinationSize", "", "dw", "dh", "sourceBounds", "Ljava/awt/Rectangle;", "userWidth", "userHeight", "g", "Ljava/awt/Graphics;", "dx", "dy", "observer", "Ljava/awt/image/ImageObserver;", "scale", "", "doDrawHiDpi", "srcBounds", "drawImage", "x", "y", "paint", "surface", "Lorg/jetbrains/skia/Surface;", "texture", "scaleSize", "size", "skiko"})
@SourceDebugExtension(value={"SMAP\nSoftwareSwingPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoftwareSwingPainter.kt\norg/jetbrains/skiko/swing/SoftwareSwingPainter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1#2:230\n*E\n"})
public final class SoftwareSwingPainter
implements SwingPainter {
    @NotNull
    private final SwingLayerProperties swingLayerProperties;
    @NotNull
    private BufferedImage bufferedImage;
    @NotNull
    private Bitmap bitmap;

    public SoftwareSwingPainter(@NotNull SwingLayerProperties swingLayerProperties2) {
        Intrinsics.checkNotNullParameter(swingLayerProperties2, "swingLayerProperties");
        this.swingLayerProperties = swingLayerProperties2;
        this.bufferedImage = new BufferedImage(1, 1, 3);
        this.bitmap = new Bitmap();
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull Surface surface, long texture) {
        Intrinsics.checkNotNullParameter(g, "g");
        Intrinsics.checkNotNullParameter(surface, "surface");
        int width2 = surface.getWidth();
        int height2 = surface.getHeight();
        if (this.bitmap.getWidth() != width2 || this.bitmap.getHeight() != height2) {
            this.bitmap.allocPixelsFlags(ImageInfo.Companion.makeS32(width2, height2, ColorAlphaType.PREMUL), false);
        }
        surface.readPixels(this.bitmap, 0, 0);
        Pixmap pixmap = this.bitmap.peekPixels();
        if (pixmap == null) {
            throw new RenderException("Can't get pixels address", null, 2, null);
        }
        long bufferPtr = pixmap.getAddr();
        this.bufferedImage = this.createImageFromBytes(bufferPtr, width2, height2);
        SoftwareSwingPainter.drawImage$default(this, g, this.bufferedImage, 0, 0, 0, 0, null, null, null, 508, null);
    }

    @Override
    public void dispose() {
        this.bitmap.close();
    }

    private final BufferedImage createImageFromBytes(long pBytes, int width2, int height2) {
        if (this.bufferedImage.getWidth() != width2 || this.bufferedImage.getHeight() != height2) {
            this.bufferedImage = new BufferedImage(width2, height2, 3);
        }
        BufferedImage image = this.bufferedImage;
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        Intrinsics.checkNotNull(dataBuffer, "null cannot be cast to non-null type java.awt.image.DataBufferInt");
        int[] dstData = ((DataBufferInt)dataBuffer).getData();
        ByteBuffer src = BufferUtil.INSTANCE.getByteBufferFromPointer(pBytes, width2 * height2 * 4);
        IntBuffer intBuffer = src.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        Intrinsics.checkNotNullExpressionValue(intBuffer, "asIntBuffer(...)");
        IntBuffer srcData = intBuffer;
        srcData.position(0).get(dstData, 0, Math.min(image.getHeight() * image.getWidth(), srcData.capacity()));
        return image;
    }

    private final void drawImage(Graphics g, Image image, int x2, int y2, int dw, int dh, Rectangle sourceBounds, BufferedImageOp op, ImageObserver observer2) {
        boolean hasDestinationSize = dw >= 0 && dh >= 0;
        this.doDrawHiDpi(this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight(), g, SwingLayerPropertiesKt.getScale(this.swingLayerProperties), x2, y2, dw, dh, hasDestinationSize, op, image, sourceBounds, observer2);
    }

    static /* synthetic */ void drawImage$default(SoftwareSwingPainter softwareSwingPainter, Graphics graphics, Image image, int n, int n2, int n3, int n4, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n = 0;
        }
        if ((n5 & 8) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n3 = -1;
        }
        if ((n5 & 0x20) != 0) {
            n4 = -1;
        }
        if ((n5 & 0x40) != 0) {
            rectangle = null;
        }
        if ((n5 & 0x80) != 0) {
            bufferedImageOp = null;
        }
        if ((n5 & 0x100) != 0) {
            imageObserver = null;
        }
        softwareSwingPainter.drawImage(graphics, image, n, n2, n3, n4, rectangle, bufferedImageOp, imageObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doDrawHiDpi(int userWidth, int userHeight, Graphics g, double scale, int dx, int dy, int dw, int dh, boolean hasDestinationSize, BufferedImageOp op, Image image, Rectangle srcBounds, ImageObserver observer2) {
        Graphics g1 = g;
        double scale1 = scale;
        int dx1 = dx;
        int dy1 = dy;
        double delta = 0.0;
        int maxSize = Math.max(userWidth, userHeight);
        if (maxSize < 0x3FFFFFFF) {
            int dotAccuracy = 1;
            double pow = 0.0;
            while (true) {
                void it;
                double d;
                double d2 = d = Math.pow(10.0, dotAccuracy);
                double d3 = maxSize;
                boolean bl = false;
                pow = it;
                Unit unit = Unit.INSTANCE;
                if (!(d3 > d)) break;
                ++dotAccuracy;
            }
            delta = 1.0 / pow;
        }
        Graphics graphics = g1;
        Intrinsics.checkNotNull(graphics, "null cannot be cast to non-null type java.awt.Graphics2D");
        AffineTransform tx = ((Graphics2D)graphics).getTransform();
        Graphics invG = null;
        if ((tx.getType() & 0x18) == 0 && Math.abs(scale1 - tx.getScaleX()) <= delta) {
            scale1 = tx.getScaleX();
            double gScaleX = tx.getScaleX();
            double gScaleY = tx.getScaleY();
            tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
            tx.translate((double)dx1 * gScaleX, (double)dy1 * gScaleY);
            dy1 = 0;
            dx1 = 0;
            Graphics graphics2 = g1.create();
            Intrinsics.checkNotNull(graphics2, "null cannot be cast to non-null type java.awt.Graphics2D");
            g1 = invG = (Graphics2D)graphics2;
            ((Graphics2D)invG).setTransform(tx);
        }
        try {
            int dw2 = dw;
            int dh2 = dh;
            if (invG != null && hasDestinationSize) {
                dw2 = this.scaleSize(dw2, scale1);
                dh2 = this.scaleSize(dh2, scale1);
            }
            this.doDraw(op, image, (Graphics2D)invG, hasDestinationSize, dw2, dh2, srcBounds, userWidth, userHeight, g1, dx1, dy1, observer2, scale1);
        }
        finally {
            Graphics graphics3 = invG;
            if (graphics3 != null) {
                graphics3.dispose();
            }
        }
    }

    private final int scaleSize(int size2, double scale) {
        return MathKt.roundToInt((double)size2 * scale);
    }

    private final void doDraw(BufferedImageOp op, Image image, Graphics2D invG, boolean hasDestinationSize, int dw, int dh, Rectangle sourceBounds, int userWidth, int userHeight, Graphics g, int dx, int dy, ImageObserver observer2, double scale) {
        Image image2 = image;
        if (op != null && image2 instanceof BufferedImage) {
            BufferedImage bufferedImage = op.filter((BufferedImage)image2, null);
            Intrinsics.checkNotNullExpressionValue(bufferedImage, "filter(...)");
            image2 = bufferedImage;
        }
        if (sourceBounds != null) {
            int sx = SoftwareSwingPainter.doDraw$size(this, scale, sourceBounds.x);
            int sy = SoftwareSwingPainter.doDraw$size(this, scale, sourceBounds.y);
            int sw = sourceBounds.width >= 0 ? SoftwareSwingPainter.doDraw$size(this, scale, sourceBounds.width) : SoftwareSwingPainter.doDraw$size(this, scale, userWidth) - sx;
            int sh = sourceBounds.height >= 0 ? SoftwareSwingPainter.doDraw$size(this, scale, sourceBounds.height) : SoftwareSwingPainter.doDraw$size(this, scale, userHeight) - sy;
            int dw2 = dw;
            int dh2 = dh;
            if (!hasDestinationSize) {
                dw2 = SoftwareSwingPainter.doDraw$size(this, scale, userWidth);
                dh2 = SoftwareSwingPainter.doDraw$size(this, scale, userHeight);
            }
            g.drawImage(image2, dx, dy, dx + dw2, dy + dh2, sx, sy, sx + sw, sy + sh, observer2);
        } else if (hasDestinationSize) {
            g.drawImage(image2, dx, dy, dw, dh, observer2);
        } else if (invG == null) {
            g.drawImage(image2, dx, dy, userWidth, userHeight, observer2);
        } else {
            g.drawImage(image2, dx, dy, observer2);
        }
    }

    private static final int doDraw$size(SoftwareSwingPainter this$0, double $scale, int size2) {
        return this$0.scaleSize(size2, $scale);
    }
}

