/*
 * Decompiled with CFR 0.152.
 */
package world.respect.server.logging;

import io.github.aakira.napier.Antilog;
import io.github.aakira.napier.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\f\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0014J)\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0015\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0005`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\u00020\u0005*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lworld/respect/server/logging/LogbackAntiLog;", "Lio/github/aakira/napier/Antilog;", "<init>", "()V", "defaultTag", "", "anonymousClass", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "tagMap", "Ljava/util/HashMap;", "Lio/github/aakira/napier/LogLevel;", "Lkotlin/collections/HashMap;", "isEnable", "", "priority", "tag", "logger", "Lorg/slf4j/Logger;", "performLog", "", "throwable", "", "message", "buildLog", "buildLog$respect_server", "performTag", "createStackElementTag", "className", "createStackElementTag$respect_server", "stackTraceString", "getStackTraceString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "Companion", "respect-server"})
public final class LogbackAntiLog
extends Antilog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String defaultTag;
    private final Pattern anonymousClass = Pattern.compile("(\\$\\d+)+$");
    @NotNull
    private final HashMap<LogLevel, String> tagMap;
    @NotNull
    private final Logger logger;
    private static final int CALL_STACK_INDEX = 8;

    public LogbackAntiLog() {
        this.defaultTag = "app";
        Pair[] pairArray = new Pair[]{TuplesKt.to(LogLevel.VERBOSE, "[VERBOSE]"), TuplesKt.to(LogLevel.DEBUG, "[DEBUG]"), TuplesKt.to(LogLevel.INFO, "[INFO]"), TuplesKt.to(LogLevel.WARNING, "[WARN]"), TuplesKt.to(LogLevel.ERROR, "[ERROR]"), TuplesKt.to(LogLevel.ASSERT, "[ASSERT]")};
        this.tagMap = MapsKt.hashMapOf(pairArray);
        Logger logger = LoggerFactory.getLogger(LogbackAntiLog.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
    }

    @Override
    public boolean isEnable(@NotNull LogLevel priority, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)priority, "priority");
        return true;
    }

    @Override
    protected void performLog(@NotNull LogLevel priority, @Nullable String tag, @Nullable Throwable throwable, @Nullable String message) {
        Object object;
        String debugTag;
        Intrinsics.checkNotNullParameter((Object)priority, "priority");
        String string2 = tag;
        if (string2 == null) {
            string2 = debugTag = this.performTag(this.defaultTag);
        }
        if (message != null) {
            object = throwable != null ? message + "\n" + this.getStackTraceString(throwable) : message;
        } else {
            object = throwable;
            if (object == null || (object = this.getStackTraceString((Throwable)object)) == null) {
                return;
            }
        }
        Object fullMessage = object;
        switch (WhenMappings.$EnumSwitchMapping$0[priority.ordinal()]) {
            case 1: {
                this.logger.trace(this.buildLog$respect_server(priority, debugTag, (String)fullMessage));
                break;
            }
            case 2: {
                this.logger.debug(this.buildLog$respect_server(priority, debugTag, (String)fullMessage));
                break;
            }
            case 3: {
                this.logger.info(this.buildLog$respect_server(priority, debugTag, (String)fullMessage));
                break;
            }
            case 4: {
                this.logger.warn(this.buildLog$respect_server(priority, debugTag, (String)fullMessage));
                break;
            }
            case 5: {
                this.logger.error(this.buildLog$respect_server(priority, debugTag, (String)fullMessage));
                break;
            }
            case 6: {
                this.logger.error(this.buildLog$respect_server(priority, debugTag, (String)fullMessage));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final String buildLog$respect_server(@NotNull LogLevel priority, @Nullable String tag, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)priority, "priority");
        String string2 = this.tagMap.get((Object)priority);
        String string3 = tag;
        if (string3 == null) {
            string3 = this.performTag(this.defaultTag);
        }
        return string2 + " " + string3 + " - " + message;
    }

    private final String performTag(String defaultTag) {
        Object object;
        StackTraceElement[] thread2 = Thread.currentThread().getStackTrace();
        if (thread2.length >= 8) {
            StackTraceElement $this$performTag_u24lambda_u240 = thread2[8];
            boolean bl = false;
            String string2 = $this$performTag_u24lambda_u240.getClassName();
            Intrinsics.checkNotNullExpressionValue(string2, "getClassName(...)");
            object = this.createStackElementTag$respect_server(string2) + "$" + $this$performTag_u24lambda_u240.getMethodName();
        } else {
            object = defaultTag;
        }
        return object;
    }

    @NotNull
    public final String createStackElementTag$respect_server(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        String tag = className;
        Matcher m = this.anonymousClass.matcher(tag);
        if (m.find()) {
            String string2 = m.replaceAll("");
            Intrinsics.checkNotNullExpressionValue(string2, "replaceAll(...)");
            tag = string2;
        }
        String string3 = tag.substring(StringsKt.lastIndexOf$default((CharSequence)tag, '.', 0, false, 6, null) + 1);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        return string3;
    }

    private final String getStackTraceString(Throwable $this$stackTraceString) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        $this$stackTraceString.printStackTrace(pw);
        pw.flush();
        String string2 = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lworld/respect/server/logging/LogbackAntiLog$Companion;", "", "<init>", "()V", "CALL_STACK_INDEX", "", "respect-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.VERBOSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ASSERT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

