/*
 * Decompiled with CFR 0.152.
 */
package com.eygraber.uri;

import com.eygraber.uri.UriCodec;
import com.eygraber.uri.parts.Part;
import com.eygraber.uri.parts.PathPart;
import com.eygraber.uri.uris.HierarchicalUri;
import com.eygraber.uri.uris.OpaqueUri;
import com.eygraber.uri.uris.StringUri;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 =2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002<=J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\t01H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\t0+2\u0006\u00103\u001a\u00020\tH\u0016J\u0012\u00104\u001a\u0004\u0018\u00010\t2\u0006\u00103\u001a\u00020\tH\u0016J\u0018\u00105\u001a\u00020\u00032\u0006\u00103\u001a\u00020\t2\u0006\u00106\u001a\u00020\u0003H\u0016J\b\u00107\u001a\u00020\u0000H\u0016J\u0011\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u0000H\u0096\u0002J\b\u0010:\u001a\u00020;H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0004R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0004R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0014\u0010\u0018\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000bR\u0014\u0010 \u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000bR\u0014\u0010\"\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000bR\u0014\u0010$\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000bR\u0014\u0010&\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000bR\u0014\u0010(\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000bR\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0+X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u000b\u00a8\u0006>\u00c0\u0006\u0003"}, d2={"Lcom/eygraber/uri/Uri;", "", "isHierarchical", "", "()Z", "isOpaque", "isRelative", "isAbsolute", "scheme", "", "getScheme", "()Ljava/lang/String;", "schemeSpecificPart", "getSchemeSpecificPart", "encodedSchemeSpecificPart", "getEncodedSchemeSpecificPart", "authority", "getAuthority", "encodedAuthority", "getEncodedAuthority", "userInfo", "getUserInfo", "encodedUserInfo", "getEncodedUserInfo", "host", "getHost", "port", "", "getPort", "()I", "path", "getPath", "encodedPath", "getEncodedPath", "query", "getQuery", "encodedQuery", "getEncodedQuery", "fragment", "getFragment", "encodedFragment", "getEncodedFragment", "pathSegments", "", "getPathSegments", "()Ljava/util/List;", "lastPathSegment", "getLastPathSegment", "getQueryParameterNames", "", "getQueryParameters", "key", "getQueryParameter", "getBooleanQueryParameter", "defaultValue", "normalizeScheme", "compareTo", "other", "buildUpon", "Lcom/eygraber/uri/Builder;", "Builder", "Companion", "uri"})
public interface Uri
extends Comparable<Uri> {
    @NotNull
    public static final Companion Companion = com.eygraber.uri.Uri$Companion.$$INSTANCE;

    public boolean isHierarchical();

    default public boolean isOpaque() {
        return !this.isHierarchical();
    }

    public boolean isRelative();

    default public boolean isAbsolute() {
        return !this.isRelative();
    }

    @Nullable
    public String getScheme();

    @Nullable
    public String getSchemeSpecificPart();

    @Nullable
    public String getEncodedSchemeSpecificPart();

    @Nullable
    public String getAuthority();

    @Nullable
    public String getEncodedAuthority();

    @Nullable
    public String getUserInfo();

    @Nullable
    public String getEncodedUserInfo();

    @Nullable
    public String getHost();

    public int getPort();

    @Nullable
    public String getPath();

    @Nullable
    public String getEncodedPath();

    @Nullable
    public String getQuery();

    @Nullable
    public String getEncodedQuery();

    @Nullable
    public String getFragment();

    @Nullable
    public String getEncodedFragment();

    @NotNull
    public List<String> getPathSegments();

    @Nullable
    public String getLastPathSegment();

    @NotNull
    default public Set<String> getQueryParameterNames() {
        int end;
        if (this.isOpaque()) {
            throw new UnsupportedOperationException("This isn't a hierarchical URI.");
        }
        String string = this.getEncodedQuery();
        if (string == null) {
            return SetsKt.emptySet();
        }
        String query = string;
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        int start = 0;
        do {
            String name;
            int next;
            end = (next = StringsKt.indexOf$default((CharSequence)query, (char)'&', (int)start, (boolean)false, (int)4, null)) == -1 ? query.length() : next;
            int separator = StringsKt.indexOf$default((CharSequence)query, (char)'=', (int)start, (boolean)false, (int)4, null);
            if (separator > end || separator == -1) {
                separator = end;
            }
            Intrinsics.checkNotNullExpressionValue((Object)query.substring(start, separator), (String)"substring(...)");
            names.add(UriCodec.decode$default(UriCodec.INSTANCE, name, false, false, 6, null));
        } while ((start = end + 1) < query.length());
        return names;
    }

    @NotNull
    default public List<String> getQueryParameters(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.isOpaque()) {
            throw new UnsupportedOperationException("This isn't a hierarchical URI.");
        }
        String string2 = this.getEncodedQuery();
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String query = string2;
        try {
            string = UriCodec.INSTANCE.encode(key);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        String encodedKey = string;
        ArrayList<String> values = new ArrayList<String>();
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = StringsKt.indexOf$default((CharSequence)query, (char)'&', (int)start, (boolean)false, (int)4, null)) != -1 ? nextAmpersand : query.length();
            int separator = StringsKt.indexOf$default((CharSequence)query, (char)'=', (int)start, (boolean)false, (int)4, null);
            if (separator > end || separator == -1) {
                separator = end;
            }
            if (separator - start == encodedKey.length() && StringsKt.regionMatches$default((String)query, (int)start, (String)encodedKey, (int)0, (int)encodedKey.length(), (boolean)false, (int)16, null)) {
                boolean bl;
                if (separator == end) {
                    bl = values.add("");
                } else {
                    String string3 = query.substring(separator + 1, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    bl = values.add(UriCodec.decode$default(UriCodec.INSTANCE, string3, false, false, 6, null));
                }
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
        return values;
    }

    @Nullable
    default public String getQueryParameter(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.getEncodedQuery();
        if (string == null) {
            return null;
        }
        String query = string;
        if (this.isOpaque()) {
            throw new UnsupportedOperationException("This isn't a hierarchical URI.");
        }
        String encodedKey = UriCodec.INSTANCE.encode(key, null);
        int length = query.length();
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = StringsKt.indexOf$default((CharSequence)query, (char)'&', (int)start, (boolean)false, (int)4, null)) != -1 ? nextAmpersand : length;
            int separator = StringsKt.indexOf$default((CharSequence)query, (char)'=', (int)start, (boolean)false, (int)4, null);
            if (separator > end || separator == -1) {
                separator = end;
            }
            if (separator - start == encodedKey.length() && StringsKt.regionMatches$default((String)query, (int)start, (String)encodedKey, (int)0, (int)encodedKey.length(), (boolean)false, (int)16, null)) {
                String string2;
                if (separator == end) {
                    string2 = "";
                } else {
                    String string3 = query.substring(separator + 1, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    String encodedValue = string3;
                    string2 = UriCodec.INSTANCE.decode(encodedValue, true, false);
                }
                return string2;
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
        return null;
    }

    default public boolean getBooleanQueryParameter(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.getQueryParameter(key);
        if (string == null) {
            return defaultValue;
        }
        String flag = string;
        String string2 = flag.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        flag = string2;
        return !Intrinsics.areEqual((Object)"false", (Object)flag) && !Intrinsics.areEqual((Object)"0", (Object)flag);
    }

    @NotNull
    default public Uri normalizeScheme() {
        String string = this.getScheme();
        if (string == null) {
            return this;
        }
        String scheme = string;
        String string2 = scheme.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String lowerScheme = string2;
        return Intrinsics.areEqual((Object)scheme, (Object)lowerScheme) ? this : this.buildUpon().scheme(lowerScheme).build();
    }

    @Override
    default public int compareTo(@NotNull Uri other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toString().compareTo(other.toString());
    }

    @NotNull
    public com.eygraber.uri.Builder buildUpon();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0011J\u0012\u0010\u0004\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0017\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u0012J\u0012\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u0013\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u0017\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u0014J\u0012\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u0015\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0017\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u0016J\u0012\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u0017\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0017\u0010\u000b\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u001bJ\u0012\u0010\u000b\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u001c\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0017\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u001dJ\u0012\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u001e\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016J\u001a\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\"\u001a\u00020\u0000H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u000eH\u0002J\b\u0010&\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/eygraber/uri/Uri$Builder;", "Lcom/eygraber/uri/Builder;", "<init>", "()V", "scheme", "", "opaquePart", "Lcom/eygraber/uri/parts/Part;", "authority", "path", "Lcom/eygraber/uri/parts/PathPart;", "query", "fragment", "isSchemeSet", "", "isSchemeSet$uri", "isAuthoritySet", "isAuthoritySet$uri", "opaquePart$uri", "encodedOpaquePart", "authority$uri", "encodedAuthority", "path$uri", "encodedPath", "appendPath", "newSegment", "appendEncodedPath", "query$uri", "encodedQuery", "fragment$uri", "encodedFragment", "appendQueryParameter", "key", "value", "clearQuery", "build", "Lcom/eygraber/uri/Uri;", "hasSchemeOrAuthority", "toString", "uri"})
    public static final class Builder
    implements com.eygraber.uri.Builder {
        @Nullable
        private String scheme;
        @Nullable
        private Part opaquePart;
        @Nullable
        private Part authority;
        @Nullable
        private PathPart path;
        @Nullable
        private Part query;
        @Nullable
        private Part fragment;

        public final boolean isSchemeSet$uri() {
            return this.scheme != null;
        }

        public final boolean isAuthoritySet$uri() {
            return this.authority != null;
        }

        @Override
        @NotNull
        public Builder scheme(@Nullable String scheme) {
            Builder builder;
            Builder $this$scheme_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$scheme_u24lambda_u240.scheme = scheme;
            return builder;
        }

        @NotNull
        public final Builder opaquePart$uri(@Nullable Part opaquePart) {
            Builder builder;
            Builder $this$opaquePart_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$opaquePart_u24lambda_u241.opaquePart = opaquePart;
            return builder;
        }

        @Override
        @NotNull
        public Builder opaquePart(@Nullable String opaquePart) {
            return this.opaquePart$uri(Part.Companion.fromDecoded(opaquePart));
        }

        @Override
        @NotNull
        public Builder encodedOpaquePart(@Nullable String opaquePart) {
            return this.opaquePart$uri(Part.Companion.fromEncoded(opaquePart));
        }

        @NotNull
        public final Builder authority$uri(@Nullable Part authority) {
            Builder builder;
            Builder $this$authority_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$authority_u24lambda_u242.opaquePart = null;
            $this$authority_u24lambda_u242.authority = authority;
            return builder;
        }

        @Override
        @NotNull
        public Builder authority(@Nullable String authority) {
            return this.authority$uri(Part.Companion.fromDecoded(authority));
        }

        @Override
        @NotNull
        public Builder encodedAuthority(@Nullable String authority) {
            return this.authority$uri(Part.Companion.fromEncoded(authority));
        }

        @NotNull
        public final Builder path$uri(@Nullable PathPart path) {
            Builder builder;
            Builder $this$path_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$path_u24lambda_u243.opaquePart = null;
            $this$path_u24lambda_u243.path = path;
            return builder;
        }

        @Override
        @NotNull
        public Builder path(@Nullable String path) {
            return this.path$uri(PathPart.Companion.fromDecoded(path));
        }

        @Override
        @NotNull
        public Builder encodedPath(@Nullable String path) {
            return this.path$uri(PathPart.Companion.fromEncoded(path));
        }

        @Override
        @NotNull
        public Builder appendPath(@NotNull String newSegment) {
            Intrinsics.checkNotNullParameter((Object)newSegment, (String)"newSegment");
            return this.path$uri(PathPart.Companion.appendDecodedSegment(this.path, newSegment));
        }

        @Override
        @NotNull
        public Builder appendEncodedPath(@NotNull String newSegment) {
            Intrinsics.checkNotNullParameter((Object)newSegment, (String)"newSegment");
            return this.path$uri(PathPart.Companion.appendEncodedSegment(this.path, newSegment));
        }

        @NotNull
        public final Builder query$uri(@Nullable Part query) {
            Builder builder;
            Builder $this$query_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$query_u24lambda_u244.opaquePart = null;
            $this$query_u24lambda_u244.query = query;
            return builder;
        }

        @Override
        @NotNull
        public Builder query(@Nullable String query) {
            return this.query$uri(Part.Companion.fromDecoded(query));
        }

        @Override
        @NotNull
        public Builder encodedQuery(@Nullable String query) {
            return this.query$uri(Part.Companion.fromEncoded(query));
        }

        @NotNull
        public final Builder fragment$uri(@Nullable Part fragment) {
            Builder builder;
            Builder $this$fragment_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$fragment_u24lambda_u245.fragment = fragment;
            return builder;
        }

        @Override
        @NotNull
        public Builder fragment(@Nullable String fragment) {
            return this.fragment$uri(Part.Companion.fromDecoded(fragment));
        }

        @Override
        @NotNull
        public Builder encodedFragment(@Nullable String fragment) {
            return this.fragment$uri(Part.Companion.fromEncoded(fragment));
        }

        @Override
        @NotNull
        public Builder appendQueryParameter(@NotNull String key, @Nullable String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder $this$appendQueryParameter_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$appendQueryParameter_u24lambda_u246.opaquePart = null;
            String encodedKey = UriCodec.INSTANCE.encode(key, null);
            String encodedValue = UriCodec.INSTANCE.encodeOrNull(value, null);
            String encodedParameter = encodedKey + "=" + encodedValue;
            if ($this$appendQueryParameter_u24lambda_u246.query == null) {
                $this$appendQueryParameter_u24lambda_u246.query = Part.Companion.fromEncoded(encodedParameter);
                return $this$appendQueryParameter_u24lambda_u246;
            }
            Part part = $this$appendQueryParameter_u24lambda_u246.query;
            if (part == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            String oldQuery = part.getEncoded();
            CharSequence charSequence = oldQuery;
            $this$appendQueryParameter_u24lambda_u246.query = charSequence == null || charSequence.length() == 0 ? Part.Companion.fromEncoded(encodedParameter) : Part.Companion.fromEncoded(oldQuery + "&" + encodedParameter);
            return builder;
        }

        @Override
        @NotNull
        public Builder clearQuery() {
            return this.query$uri(null);
        }

        @Override
        @NotNull
        public Uri build() {
            Uri uri;
            Part opaquePart = this.opaquePart;
            if (opaquePart == null) {
                PathPart path = this.path;
                if (path == null || Intrinsics.areEqual((Object)path, (Object)PathPart.Companion.getNULL())) {
                    path = PathPart.Companion.getEMPTY();
                } else if (this.hasSchemeOrAuthority()) {
                    path = PathPart.Companion.makeAbsolute(path);
                }
                uri = new HierarchicalUri(this.scheme, this.authority, path, this.query, this.fragment);
            } else {
                if (this.scheme == null) {
                    throw new UnsupportedOperationException("An opaque URI must have a scheme.");
                }
                uri = new OpaqueUri(this.scheme, opaquePart, this.fragment);
            }
            return uri;
        }

        private final boolean hasSchemeOrAuthority() {
            return this.scheme != null || this.authority != null && this.authority != Part.Companion.getNULL();
        }

        @NotNull
        public String toString() {
            return this.build().toString();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0005J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005J&\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017J\"\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/eygraber/uri/Uri$Companion;", "", "<init>", "()V", "NOT_HIERARCHICAL", "", "EMPTY", "Lcom/eygraber/uri/Uri;", "getEMPTY", "()Lcom/eygraber/uri/Uri;", "parse", "uriString", "parseOrNull", "fromParts", "scheme", "ssp", "fragment", "encodeOrNull", "s", "allow", "encode", "decodeOrNull", "convertPlus", "", "throwOnFailure", "decode", "uri"})
    @SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\ncom/eygraber/uri/Uri$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,689:1\n1#2:690\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String NOT_HIERARCHICAL = "This isn't a hierarchical URI.";
        @NotNull
        private static final Uri EMPTY;

        private Companion() {
        }

        @NotNull
        public final Uri getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final Uri parse(@NotNull String uriString) {
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            return new StringUri(uriString);
        }

        @Nullable
        public final Uri parseOrNull(@NotNull String uriString) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
            Object object2 = this;
            try {
                Companion $this$parseOrNull_u24lambda_u240 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)new StringUri(uriString));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            return (Uri)(Result.isFailure-impl((Object)object2) ? null : object2);
        }

        @NotNull
        public final Uri fromParts(@NotNull String scheme, @NotNull String ssp, @Nullable String fragment) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            Intrinsics.checkNotNullParameter((Object)ssp, (String)"ssp");
            return new OpaqueUri(scheme, Part.Companion.fromDecoded(ssp), Part.Companion.fromDecoded(fragment));
        }

        @Nullable
        public final String encodeOrNull(@Nullable String s) {
            return UriCodec.INSTANCE.encodeOrNull(s);
        }

        @Nullable
        public final String encodeOrNull(@Nullable String s, @Nullable String allow) {
            return UriCodec.INSTANCE.encodeOrNull(s, allow);
        }

        @NotNull
        public final String encode(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return UriCodec.INSTANCE.encode(s);
        }

        @NotNull
        public final String encode(@NotNull String s, @Nullable String allow) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return UriCodec.INSTANCE.encode(s, allow);
        }

        @Nullable
        public final String decodeOrNull(@Nullable String s, boolean convertPlus, boolean throwOnFailure) {
            return UriCodec.INSTANCE.decodeOrNull(s, convertPlus, throwOnFailure);
        }

        public static /* synthetic */ String decodeOrNull$default(Companion companion, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.decodeOrNull(string, bl, bl2);
        }

        @NotNull
        public final String decode(@NotNull String s, boolean convertPlus, boolean throwOnFailure) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return UriCodec.INSTANCE.decode(s, convertPlus, throwOnFailure);
        }

        public static /* synthetic */ String decode$default(Companion companion, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.decode(string, bl, bl2);
        }

        static {
            $$INSTANCE = new Companion();
            EMPTY = new HierarchicalUri(null, Part.Companion.getNULL(), PathPart.Companion.getEMPTY(), Part.Companion.getNULL(), Part.Companion.getNULL());
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static boolean isOpaque(@NotNull Uri $this) {
            return $this.isOpaque();
        }

        @Deprecated
        public static boolean isAbsolute(@NotNull Uri $this) {
            return $this.isAbsolute();
        }

        @Deprecated
        @NotNull
        public static Set<String> getQueryParameterNames(@NotNull Uri $this) {
            return $this.getQueryParameterNames();
        }

        @Deprecated
        @NotNull
        public static List<String> getQueryParameters(@NotNull Uri $this, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return $this.getQueryParameters(key);
        }

        @Deprecated
        @Nullable
        public static String getQueryParameter(@NotNull Uri $this, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return $this.getQueryParameter(key);
        }

        @Deprecated
        public static boolean getBooleanQueryParameter(@NotNull Uri $this, @NotNull String key, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return $this.getBooleanQueryParameter(key, defaultValue);
        }

        @Deprecated
        @NotNull
        public static Uri normalizeScheme(@NotNull Uri $this) {
            return $this.normalizeScheme();
        }

        @Deprecated
        public static int compareTo(@NotNull Uri $this, @NotNull Uri other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return $this.compareTo(other);
        }
    }
}

