/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.concurrent;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/room/concurrent/FileLock;", "", "filename", "", "<init>", "(Ljava/lang/String;)V", "lockFilename", "lockChannel", "Ljava/nio/channels/FileChannel;", "lock", "", "unlock", "room-runtime"})
public final class FileLock {
    @NotNull
    private final String lockFilename;
    @Nullable
    private FileChannel lockChannel;

    public FileLock(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.lockFilename = filename + ".lck";
    }

    public final void lock() {
        if (this.lockChannel != null) {
            return;
        }
        try {
            File lockFile = new File(this.lockFilename);
            File file = lockFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            FileChannel fileChannel = this.lockChannel = new FileOutputStream(lockFile).getChannel();
            if (fileChannel != null) {
                fileChannel.lock();
            }
        }
        catch (Throwable ex) {
            FileChannel fileChannel = this.lockChannel;
            if (fileChannel != null) {
                fileChannel.close();
            }
            this.lockChannel = null;
            throw new IllegalStateException("Unable to lock file: '" + this.lockFilename + "'.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock() {
        FileChannel fileChannel = this.lockChannel;
        if (fileChannel == null) {
            return;
        }
        FileChannel channel = fileChannel;
        try {
            channel.close();
        }
        finally {
            this.lockChannel = null;
        }
    }
}

