/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.serialization;

import androidx.navigation.CollectionNavType;
import androidx.navigation.NavType;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001bB\u0017\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0002J&\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\b2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0016J4\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\b2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00162\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/navigation/serialization/RouteBuilder;", "T", "", "serializer", "Lkotlinx/serialization/KSerializer;", "<init>", "(Lkotlinx/serialization/KSerializer;)V", "path", "", "(Ljava/lang/String;Lkotlinx/serialization/KSerializer;)V", "pathArgs", "queryArgs", "build", "addPath", "", "addQuery", "name", "value", "appendPattern", "index", "", "type", "Landroidx/navigation/NavType;", "appendArg", "", "computeParamType", "Landroidx/navigation/serialization/RouteBuilder$ParamType;", "ParamType", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nRouteBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteBuilder.kt\nandroidx/navigation/serialization/RouteBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1869#2,2:112\n*S KotlinDebug\n*F\n+ 1 RouteBuilder.kt\nandroidx/navigation/serialization/RouteBuilder\n*L\n88#1:112,2\n*E\n"})
public final class RouteBuilder<T> {
    @NotNull
    private final KSerializer<T> serializer;
    @NotNull
    private final String path;
    @NotNull
    private String pathArgs;
    @NotNull
    private String queryArgs;

    public RouteBuilder(@NotNull KSerializer<T> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.pathArgs = "";
        this.queryArgs = "";
        this.serializer = serializer;
        this.path = serializer.getDescriptor().getSerialName();
    }

    public RouteBuilder(@NotNull String path, @NotNull KSerializer<T> serializer) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        this.pathArgs = "";
        this.queryArgs = "";
        this.serializer = serializer;
        this.path = path;
    }

    @NotNull
    public final String build() {
        return this.path + this.pathArgs + this.queryArgs;
    }

    private final void addPath(String path) {
        this.pathArgs = this.pathArgs + "/" + path;
    }

    private final void addQuery(String name, String value) {
        String symbol = ((CharSequence)this.queryArgs).length() == 0 ? "?" : "&";
        this.queryArgs = this.queryArgs + symbol + name + "=" + value;
    }

    public final void appendPattern(int index, @NotNull String name, @NotNull NavType<Object> type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        ParamType paramType = this.computeParamType(index, type);
        switch (WhenMappings.$EnumSwitchMapping$0[paramType.ordinal()]) {
            case 1: {
                this.addPath("{" + name + "}");
                break;
            }
            case 2: {
                this.addQuery(name, "{" + name + "}");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void appendArg(int index, @NotNull String name, @NotNull NavType<Object> type, @NotNull List<String> value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        ParamType paramType = this.computeParamType(index, type);
        switch (WhenMappings.$EnumSwitchMapping$0[paramType.ordinal()]) {
            case 1: {
                if (!(value.size() == 1)) {
                    boolean $i$a$-require-RouteBuilder$appendArg$22 = false;
                    String $i$a$-require-RouteBuilder$appendArg$22 = "Expected one value for argument " + name + ", found " + value.size() + "values instead.";
                    throw new IllegalArgumentException($i$a$-require-RouteBuilder$appendArg$22.toString());
                }
                this.addPath((String)CollectionsKt.first(value));
                break;
            }
            case 2: {
                Iterable $this$forEach$iv = value;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    this.addQuery(name, it);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final ParamType computeParamType(int index, NavType<Object> type) {
        return type instanceof CollectionNavType || this.serializer.getDescriptor().isElementOptional(index) ? ParamType.QUERY : ParamType.PATH;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/navigation/serialization/RouteBuilder$ParamType;", "", "<init>", "(Ljava/lang/String;I)V", "PATH", "QUERY", "navigation-common"})
    private static final class ParamType
    extends Enum<ParamType> {
        public static final /* enum */ ParamType PATH = new ParamType();
        public static final /* enum */ ParamType QUERY = new ParamType();
        private static final /* synthetic */ ParamType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ParamType[] values() {
            return (ParamType[])$VALUES.clone();
        }

        public static ParamType valueOf(String value) {
            return Enum.valueOf(ParamType.class, value);
        }

        @NotNull
        public static EnumEntries<ParamType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = paramTypeArray = new ParamType[]{ParamType.PATH, ParamType.QUERY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ParamType.values().length];
            try {
                nArray[ParamType.PATH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParamType.QUERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

