/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.AuthenticationObject;
import com.webauthn4j.verifier.OriginVerifier;
import com.webauthn4j.verifier.RegistrationObject;
import com.webauthn4j.verifier.exception.BadOriginException;
import org.jetbrains.annotations.NotNull;

public class OriginVerifierImpl
implements OriginVerifier {
    @Override
    public void verify(@NotNull RegistrationObject registrationObject) {
        AssertUtil.notNull((Object)registrationObject, (String)"registrationObject must not be null");
        CollectedClientData collectedClientData = registrationObject.getCollectedClientData();
        ServerProperty serverProperty = registrationObject.getServerProperty();
        this.verify(collectedClientData, serverProperty);
    }

    @Override
    public void verify(@NotNull AuthenticationObject authenticationObject) {
        AssertUtil.notNull((Object)authenticationObject, (String)"authenticationObject must not be null");
        CollectedClientData collectedClientData = authenticationObject.getCollectedClientData();
        ServerProperty serverProperty = authenticationObject.getServerProperty();
        this.verify(collectedClientData, serverProperty);
    }

    protected void verify(@NotNull CollectedClientData collectedClientData, @NotNull ServerProperty serverProperty) {
        AssertUtil.notNull((Object)collectedClientData, (String)"collectedClientData must not be null");
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        Origin clientOrigin = collectedClientData.getOrigin();
        if (!serverProperty.getOrigins().contains(clientOrigin)) {
            throw new BadOriginException("The collectedClientData '" + clientOrigin + "' origin doesn't match any of the preconfigured server origin.");
        }
    }
}

