/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kerby.asn1.Asn1Converter;
import org.apache.kerby.asn1.Asn1Dumper;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.parse.Asn1Parser;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.asn1.util.HexUtil;

public final class Asn1 {
    private Asn1() {
    }

    public static void encode(ByteBuffer buffer, Asn1Type value) throws IOException {
        value.encode(buffer);
    }

    public static byte[] encode(Asn1Type value) throws IOException {
        return value.encode();
    }

    public static Asn1Type decode(byte[] content2) throws IOException {
        return Asn1.decode(ByteBuffer.wrap(content2));
    }

    public static Asn1Type decode(ByteBuffer content2) throws IOException {
        Asn1ParseResult parseResult = Asn1Parser.parse(content2);
        return Asn1Converter.convert(parseResult, false);
    }

    public static void decode(byte[] content2, Asn1Type value) throws IOException {
        value.decode(content2);
    }

    public static void decode(ByteBuffer content2, Asn1Type value) throws IOException {
        value.decode(content2);
    }

    public static Asn1ParseResult parse(byte[] content2) throws IOException {
        return Asn1.parse(ByteBuffer.wrap(content2));
    }

    public static Asn1ParseResult parse(ByteBuffer content2) throws IOException {
        return Asn1Parser.parse(content2);
    }

    public static void dump(Asn1Type value) {
        Asn1Dumper dumper = new Asn1Dumper();
        dumper.dumpType(0, value);
        String output2 = dumper.output();
        System.out.println(output2);
    }

    public static void parseAndDump(String hexStr) throws IOException {
        byte[] data2 = HexUtil.hex2bytes(hexStr);
        Asn1.parseAndDump(data2);
    }

    public static void parseAndDump(ByteBuffer content2) throws IOException {
        byte[] bytes = new byte[content2.remaining()];
        content2.get(bytes);
        Asn1.parseAndDump(bytes);
    }

    public static void parseAndDump(byte[] content2) throws IOException {
        Asn1Dumper dumper = new Asn1Dumper();
        dumper.parseAndDump(content2);
        String output2 = dumper.output();
        System.out.println(output2);
    }

    public static void decodeAndDump(String hexStr) throws IOException {
        byte[] data2 = HexUtil.hex2bytes(hexStr);
        Asn1.decodeAndDump(data2);
    }

    public static void decodeAndDump(ByteBuffer content2) throws IOException {
        byte[] bytes = new byte[content2.remaining()];
        content2.get(bytes);
        Asn1.decodeAndDump(bytes);
    }

    public static void decodeAndDump(byte[] content2) throws IOException {
        Asn1Dumper dumper = new Asn1Dumper();
        dumper.decodeAndDump(content2);
        String output2 = dumper.output();
        System.out.println(output2);
    }
}

