/*
 * Decompiled with CFR 0.152.
 */
package world.respect.datalayer.shared.paging;

import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a#\u0010\u0004\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a+\u0010\u0007\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\b\u001a)\u0010\f\u001a\u0004\u0018\u00010\u0001\"\b\b\u0000\u0010\n*\u00020\t*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\f\u0010\r\"\u0014\u0010\u000e\u001a\u00020\u00018\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\"#\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Landroidx/paging/PagingSource$LoadParams;", "", "params", "key", "getLimit", "(Landroidx/paging/PagingSource$LoadParams;I)I", "itemCount", "getOffset", "(Landroidx/paging/PagingSource$LoadParams;II)I", "", "Value", "Landroidx/paging/PagingState;", "getClippedRefreshKey", "(Landroidx/paging/PagingState;)Ljava/lang/Integer;", "INITIAL_ITEM_COUNT", "I", "Landroidx/paging/PagingSource$LoadResult$Invalid;", "INVALID", "Landroidx/paging/PagingSource$LoadResult$Invalid;", "getINVALID", "()Landroidx/paging/PagingSource$LoadResult$Invalid;", "respect-datalayer"})
public final class DatalayerPagingUtilKt {
    public static final int INITIAL_ITEM_COUNT = -1;
    @NotNull
    private static final PagingSource.LoadResult.Invalid<Object, Object> INVALID = new PagingSource.LoadResult.Invalid();

    @NotNull
    public static final PagingSource.LoadResult.Invalid<Object, Object> getINVALID() {
        return INVALID;
    }

    public static final int getLimit(@NotNull PagingSource.LoadParams<Integer> params, int key) {
        Intrinsics.checkNotNullParameter(params, "params");
        return params instanceof PagingSource.LoadParams.Prepend ? (key < ((PagingSource.LoadParams.Prepend)params).getLoadSize() ? key : ((PagingSource.LoadParams.Prepend)params).getLoadSize()) : params.getLoadSize();
    }

    public static final int getOffset(@NotNull PagingSource.LoadParams<Integer> params, int key, int itemCount) {
        int n;
        Intrinsics.checkNotNullParameter(params, "params");
        PagingSource.LoadParams<Integer> loadParams = params;
        if (loadParams instanceof PagingSource.LoadParams.Prepend) {
            n = key < ((PagingSource.LoadParams.Prepend)params).getLoadSize() ? 0 : key - ((PagingSource.LoadParams.Prepend)params).getLoadSize();
        } else if (loadParams instanceof PagingSource.LoadParams.Append) {
            n = key;
        } else if (loadParams instanceof PagingSource.LoadParams.Refresh) {
            n = key >= itemCount ? Math.max(0, itemCount - ((PagingSource.LoadParams.Refresh)params).getLoadSize()) : key;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    @Nullable
    public static final <Value> Integer getClippedRefreshKey(@NotNull PagingState<Integer, Value> $this$getClippedRefreshKey) {
        Intrinsics.checkNotNullParameter($this$getClippedRefreshKey, "<this>");
        Integer anchorPosition = $this$getClippedRefreshKey.getAnchorPosition();
        return anchorPosition != null ? Integer.valueOf(Math.max(0, anchorPosition - $this$getClippedRefreshKey.getConfig().initialLoadSize / 2)) : null;
    }
}

