/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.ApplicationKt;
import io.ktor.server.application.ServerConfig;
import io.ktor.server.application.ServerConfigBuilder;
import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ApplicationConfigKt;
import io.ktor.server.config.ConfigLoader;
import io.ktor.server.config.MapApplicationConfig;
import io.ktor.server.config.MergedApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEnvironmentBuilderKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.CommandLineConfig;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnvironmentUtilsJvmKt;
import io.ktor.util.PlatformUtils;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\u001a\u001b\u0010\u0004\u001a\u00020\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a)\u0010\t\u001a\u00020\b2\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00070\u0006H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0019\u0010\u000e\u001a\u00020\r*\u00020\u000b2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a)\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"", "", "args", "Lio/ktor/server/engine/CommandLineConfig;", "CommandLineConfig", "([Ljava/lang/String;)Lio/ktor/server/engine/CommandLineConfig;", "", "Lkotlin/Pair;", "Lio/ktor/server/config/ApplicationConfig;", "buildApplicationConfig", "(Ljava/util/List;)Lio/ktor/server/config/ApplicationConfig;", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "deploymentConfig", "", "loadCommonConfiguration", "(Lio/ktor/server/engine/ApplicationEngine$Configuration;Lio/ktor/server/config/ApplicationConfig;)V", "", "ch", "splitPair", "(Ljava/lang/String;C)Lkotlin/Pair;", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nCommandLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandLine.kt\nio/ktor/server/engine/CommandLineKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 EngineConnectorConfig.kt\nio/ktor/server/engine/EngineConnectorConfigKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n11546#2,9:175\n13472#2:184\n13473#2:186\n11555#2:187\n1#3:185\n1#3:215\n75#4,2:188\n774#5:190\n865#5,2:191\n1563#5:193\n1634#5,3:194\n774#5:197\n865#5,2:198\n1563#5:200\n1634#5,3:201\n1563#5:204\n1634#5,3:205\n2783#5,7:208\n*S KotlinDebug\n*F\n+ 1 CommandLine.kt\nio/ktor/server/engine/CommandLineKt\n*L\n41#1:175,9\n41#1:184\n41#1:186\n41#1:187\n41#1:185\n82#1:188,2\n103#1:190\n103#1:191,2\n104#1:193\n104#1:194,3\n106#1:197\n106#1:198,2\n106#1:200\n106#1:201,3\n114#1:204\n114#1:205,3\n114#1:208,7\n*E\n"})
public final class CommandLineKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CommandLineConfig CommandLineConfig(@NotNull String[] args) {
        String sslKeyAlias;
        String string;
        String sslPort;
        String string2;
        String port;
        String string3;
        String host;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String[] $this$mapNotNull$iv = args;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Pair<String, String> it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (CommandLineKt.splitPair((String)it, '=') == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List argumentsPairs = (List)destination$iv$iv;
        Map argumentsMap = MapsKt.toMap((Iterable)argumentsPairs);
        ApplicationConfig configuration = CommandLineKt.buildApplicationConfig(argumentsPairs);
        String string4 = ApplicationConfigKt.tryGetString(configuration, "ktor.application.id");
        if (string4 == null) {
            string4 = "Application";
        }
        String applicationId = string4;
        Logger logger = KtorSimpleLoggerJvmKt.KtorSimpleLogger((String)applicationId);
        ApplicationEnvironment environment = ApplicationEnvironmentBuilderKt.applicationEnvironment((Function1<? super ApplicationEnvironmentBuilder, Unit>)((Function1)arg_0 -> CommandLineKt.CommandLineConfig$lambda$1(logger, args, configuration, arg_0)));
        ServerConfig applicationProperties2 = ApplicationKt.serverConfig(environment, (Function1<? super ServerConfigBuilder, Unit>)((Function1)arg_0 -> CommandLineKt.CommandLineConfig$lambda$4(argumentsMap, configuration, arg_0)));
        String string5 = (String)argumentsMap.get("-host");
        if (string5 == null && (string5 = ApplicationConfigKt.tryGetString(configuration, "ktor.deployment.host")) == null) {
            string5 = host = "0.0.0.0";
        }
        if ((string3 = (String)argumentsMap.get("-port")) == null) {
            string3 = port = ApplicationConfigKt.tryGetString(configuration, "ktor.deployment.port");
        }
        if ((string2 = (String)argumentsMap.get("-sslPort")) == null) {
            string2 = sslPort = ApplicationConfigKt.tryGetString(configuration, "ktor.deployment.sslPort");
        }
        if ((string = (String)argumentsMap.get("-sslKeyStore")) == null) {
            string = ApplicationConfigKt.tryGetString(configuration, "ktor.security.ssl.keyStore");
        }
        String sslKeyStorePath = string;
        String string6 = ApplicationConfigKt.tryGetString(configuration, "ktor.security.ssl.keyStorePassword");
        String sslKeyStorePassword = string6 != null ? ((Object)StringsKt.trim((CharSequence)string6)).toString() : null;
        String string7 = ApplicationConfigKt.tryGetString(configuration, "ktor.security.ssl.privateKeyPassword");
        String sslPrivateKeyPassword = string7 != null ? ((Object)StringsKt.trim((CharSequence)string7)).toString() : null;
        String string8 = ApplicationConfigKt.tryGetString(configuration, "ktor.security.ssl.keyAlias");
        if (string8 == null) {
            string8 = sslKeyAlias = "mykey";
        }
        if (port == null && sslPort == null) {
            throw new IllegalArgumentException("Neither port nor sslPort specified. Use command line options -port/-sslPort or configure connectors in application.conf");
        }
        BaseApplicationEngine.Configuration engineConfig = new BaseApplicationEngine.Configuration();
        if (port != null) {
            void $this$CommandLineConfig_u24lambda_u245;
            EngineConnectorBuilder engineConnectorBuilder;
            ApplicationEngine.Configuration $this$connector$iv = engineConfig;
            boolean $i$f$connector = false;
            EngineConnectorBuilder engineConnectorBuilder2 = engineConnectorBuilder = new EngineConnectorBuilder(null, 1, null);
            List<EngineConnectorConfig> list = $this$connector$iv.getConnectors();
            boolean bl = false;
            $this$CommandLineConfig_u24lambda_u245.setHost(host);
            $this$CommandLineConfig_u24lambda_u245.setPort(Integer.parseInt(port));
            list.add(engineConnectorBuilder);
        }
        if (sslPort != null) {
            EnvironmentUtilsJvmKt.configureSSLConnectors(engineConfig, host, sslPort, sslKeyStorePath, sslKeyStorePassword, sslPrivateKeyPassword, sslKeyAlias);
        }
        return new CommandLineConfig(applicationProperties2, engineConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationConfig buildApplicationConfig(@NotNull List<Pair<String, String>> args) {
        ApplicationConfig applicationConfig;
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Pair it;
        Iterable $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Iterable $this$filter$iv = args;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)((String)it.getFirst()), (String)"-P:", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)StringsKt.removePrefix((String)((String)it.getFirst()), (CharSequence)"-P:"), (Object)it.getSecond()));
        }
        List commandLineProperties = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = args;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it2 = (Pair)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getFirst(), (Object)"-config")) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair it2 = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add((String)it2.getSecond());
        }
        List configPaths = (List)destination$iv$iv2;
        MapApplicationConfig commandLineConfig = new MapApplicationConfig(commandLineProperties);
        MapApplicationConfig environmentConfig = new MapApplicationConfig((Collection<Pair<String, String>>)EnvironmentUtilsJvmKt.getKtorEnvironmentProperties());
        switch (configPaths.size()) {
            case 0: {
                applicationConfig = ConfigLoader.Companion.load$default(ConfigLoader.Companion, null, 1, null);
                break;
            }
            case 1: {
                applicationConfig = ConfigLoader.Companion.load((String)CollectionsKt.single((List)configPaths));
                break;
            }
            default: {
                void $this$reduce$iv;
                void $this$mapTo$iv$iv3;
                Object item$iv$iv;
                Iterable $this$map$iv3 = configPaths;
                boolean $i$f$map3 = false;
                item$iv$iv = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo32 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                    void it3;
                    String string = (String)item$iv$iv2;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    collection.add(ConfigLoader.Companion.load((String)it3));
                }
                $this$map$iv3 = (List)destination$iv$iv3;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void second;
                    ApplicationConfig $i$f$mapTo32 = (ApplicationConfig)iterator$iv.next();
                    ApplicationConfig first = (ApplicationConfig)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = MergedApplicationConfigKt.mergeWith(first, (ApplicationConfig)second);
                }
                applicationConfig = (ApplicationConfig)accumulator$iv;
            }
        }
        ApplicationConfig fileConfig = applicationConfig;
        return MergedApplicationConfigKt.mergeWith(MergedApplicationConfigKt.mergeWith(fileConfig, environmentConfig), commandLineConfig);
    }

    public static final void loadCommonConfiguration(@NotNull ApplicationEngine.Configuration $this$loadCommonConfiguration, @NotNull ApplicationConfig deploymentConfig) {
        block4: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int it;
            Intrinsics.checkNotNullParameter((Object)$this$loadCommonConfiguration, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)deploymentConfig, (String)"deploymentConfig");
            Object object5 = deploymentConfig.propertyOrNull("callGroupSize");
            if (object5 != null && (object5 = object5.getString()) != null) {
                it = Integer.parseInt((String)object5);
                boolean bl = false;
                $this$loadCommonConfiguration.setCallGroupSize(it);
            }
            if ((object4 = deploymentConfig.propertyOrNull("connectionGroupSize")) != null && (object4 = object4.getString()) != null) {
                it = Integer.parseInt((String)object4);
                boolean bl = false;
                $this$loadCommonConfiguration.setConnectionGroupSize(it);
            }
            if ((object3 = deploymentConfig.propertyOrNull("workerGroupSize")) != null && (object3 = object3.getString()) != null) {
                it = Integer.parseInt((String)object3);
                boolean bl = false;
                $this$loadCommonConfiguration.setWorkerGroupSize(it);
            }
            if ((object2 = deploymentConfig.propertyOrNull("shutdownGracePeriod")) != null && (object2 = object2.getString()) != null) {
                long it2 = Long.parseLong((String)object2);
                boolean bl = false;
                $this$loadCommonConfiguration.setShutdownGracePeriod(it2);
            }
            if ((object = deploymentConfig.propertyOrNull("shutdownTimeout")) == null || (object = object.getString()) == null) break block4;
            long it3 = Long.parseLong((String)object);
            boolean bl = false;
            $this$loadCommonConfiguration.setShutdownTimeout(it3);
        }
    }

    @Nullable
    public static final Pair<String, String> splitPair(@NotNull String $this$splitPair, char ch) {
        Intrinsics.checkNotNullParameter((Object)$this$splitPair, (String)"<this>");
        int idx = StringsKt.indexOf$default((CharSequence)$this$splitPair, (char)ch, (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        return idx == -1 ? null : new Pair((Object)StringsKt.take((String)$this$splitPair, (int)idx), (Object)StringsKt.drop((String)$this$splitPair, (int)(idx + 1)));
    }

    private static final Unit CommandLineConfig$lambda$1(Logger $logger, String[] $args, ApplicationConfig $configuration, ApplicationEnvironmentBuilder $this$applicationEnvironment) {
        Intrinsics.checkNotNullParameter((Object)$this$applicationEnvironment, (String)"$this$applicationEnvironment");
        $this$applicationEnvironment.setLog($logger);
        EnvironmentUtilsJvmKt.configurePlatformProperties($this$applicationEnvironment, $args);
        $this$applicationEnvironment.setConfig($configuration);
        return Unit.INSTANCE;
    }

    private static final Unit CommandLineConfig$lambda$4(Map $argumentsMap, ApplicationConfig $configuration, ServerConfigBuilder $this$serverConfig) {
        block4: {
            boolean bl;
            String[] it;
            Intrinsics.checkNotNullParameter((Object)$this$serverConfig, (String)"$this$serverConfig");
            String string = (String)$argumentsMap.get("-path");
            if (string == null && (string = ApplicationConfigKt.tryGetString($configuration, "ktor.deployment.rootPath")) == null) {
                string = "";
            }
            $this$serverConfig.setRootPath(string);
            ServerConfigBuilder serverConfigBuilder = $this$serverConfig;
            String string2 = ApplicationConfigKt.tryGetString($configuration, "ktor.development");
            if (string2 != null) {
                String string3 = string2;
                ServerConfigBuilder serverConfigBuilder2 = serverConfigBuilder;
                boolean bl2 = false;
                boolean bl3 = Boolean.parseBoolean((String)it);
                serverConfigBuilder = serverConfigBuilder2;
                bl = bl3;
            } else {
                bl = PlatformUtils.INSTANCE.getIS_DEVELOPMENT_MODE();
            }
            serverConfigBuilder.setDevelopmentMode(bl);
            Object object = (String)$argumentsMap.get("-watch");
            if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(it = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
                object = ApplicationConfigKt.tryGetStringList($configuration, "ktor.deployment.watch");
            }
            if (object == null) break block4;
            Object it2 = object;
            boolean bl4 = false;
            $this$serverConfig.setWatchPaths((List<String>)it2);
        }
        return Unit.INSTANCE;
    }
}

