/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode.internals;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0082\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lio/github/alexzhirkevich/qrose/qrcode/internals/BitBuffer;", "", "()V", "<set-?>", "", "buffer", "getBuffer", "()[I", "increments", "", "lengthInBits", "getLengthInBits", "()I", "get", "", "index", "put", "", "bit", "num", "length", "toString", "", "qrose"})
@StabilityInferred(parameters=0)
public final class BitBuffer {
    @NotNull
    private int[] buffer;
    private int lengthInBits;
    private final int increments;
    public static final int $stable = 8;

    public BitBuffer() {
        this.increments = 32;
        this.buffer = new int[this.increments];
        this.lengthInBits = 0;
    }

    @NotNull
    public final int[] getBuffer() {
        return this.buffer;
    }

    public final int getLengthInBits() {
        return this.lengthInBits;
    }

    private final boolean get(int index) {
        return (this.buffer[index / 8] >>> 7 - index % 8 & 1) == 1;
    }

    public final void put(int num, int length) {
        for (int i = 0; i < length; ++i) {
            this.put((num >>> length - i - 1 & 1) == 1);
        }
    }

    public final void put(boolean bit) {
        if (this.lengthInBits == this.buffer.length * 8) {
            int[] nArray = Arrays.copyOf(this.buffer, this.buffer.length + this.increments);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.buffer = nArray;
        }
        if (bit) {
            this.buffer[this.lengthInBits / 8] = this.buffer[this.lengthInBits / 8] | 128 >>> this.lengthInBits % 8;
        }
        int n = this.lengthInBits;
        this.lengthInBits = n + 1;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int n = this.lengthInBits;
        for (int i = 0; i < n; ++i) {
            buffer.append(this.get(i) ? (char)'1' : '0');
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

