/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.qrose.qrcode.internals;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.qrose.qrcode.ErrorCorrectionLevel;
import io.github.alexzhirkevich.qrose.qrcode.MaskPattern;
import io.github.alexzhirkevich.qrose.qrcode.QRCodeDataType;
import io.github.alexzhirkevich.qrose.qrcode.internals.Polynomial;
import io.github.alexzhirkevich.qrose.qrcode.internals.QRMath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u001e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0004J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006&"}, d2={"Lio/github/alexzhirkevich/qrose/qrcode/internals/QRUtil;", "", "()V", "G15", "", "G15_MASK", "G18", "MAX_LENGTH", "", "", "[[[I", "PATTERN_POSITION_TABLE", "[[I", "getBCHDigit", "data", "getBCHTypeInfo", "getBCHTypeNumber", "getDataType", "Lio/github/alexzhirkevich/qrose/qrcode/QRCodeDataType;", "s", "", "getErrorCorrectPolynomial", "Lio/github/alexzhirkevich/qrose/qrcode/internals/Polynomial;", "errorCorrectLength", "getMask", "", "maskPattern", "Lio/github/alexzhirkevich/qrose/qrcode/MaskPattern;", "i", "j", "getMaxLength", "typeNumber", "dataType", "errorCorrectionLevel", "Lio/github/alexzhirkevich/qrose/qrcode/ErrorCorrectionLevel;", "getPatternPosition", "isAlphaNum", "isNumber", "qrose"})
@StabilityInferred(parameters=0)
public final class QRUtil {
    @NotNull
    public static final QRUtil INSTANCE = new QRUtil();
    @NotNull
    private static final int[][] PATTERN_POSITION_TABLE;
    @NotNull
    private static final int[][][] MAX_LENGTH;
    private static final int G15 = 1335;
    private static final int G18 = 7973;
    private static final int G15_MASK = 21522;
    public static final int $stable;

    private QRUtil() {
    }

    @NotNull
    public final int[] getPatternPosition(int typeNumber) {
        return PATTERN_POSITION_TABLE[typeNumber - 1];
    }

    public final int getMaxLength(int typeNumber, @NotNull QRCodeDataType dataType, @NotNull ErrorCorrectionLevel errorCorrectionLevel) {
        Intrinsics.checkNotNullParameter((Object)dataType, "dataType");
        Intrinsics.checkNotNullParameter((Object)errorCorrectionLevel, "errorCorrectionLevel");
        return MAX_LENGTH[typeNumber - 1][errorCorrectionLevel.ordinal()][dataType.ordinal()];
    }

    @NotNull
    public final Polynomial getErrorCorrectPolynomial(int errorCorrectLength) {
        int[] nArray = new int[]{1};
        Polynomial a2 = new Polynomial(nArray, 0, 2, null);
        for (int i2 = 0; i2 < errorCorrectLength; ++i2) {
            int[] nArray2 = new int[]{1, QRMath.INSTANCE.gexp(i2)};
            a2 = a2.multiply(new Polynomial(nArray2, 0, 2, null));
        }
        return a2;
    }

    public final boolean getMask(@NotNull MaskPattern maskPattern, int i2, int j) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)maskPattern, "maskPattern");
        switch (WhenMappings.$EnumSwitchMapping$0[maskPattern.ordinal()]) {
            case 1: {
                if ((i2 + j) % 2 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (i2 % 2 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (j % 3 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                if ((i2 + j) % 3 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                if ((i2 / 2 + j / 3) % 2 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                if (i2 * j % 2 + i2 * j % 3 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 7: {
                if ((i2 * j % 2 + i2 * j % 3) % 2 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 8: {
                if ((i2 * j % 3 + (i2 + j) % 2) % 2 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final QRCodeDataType getDataType(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        return this.isAlphaNum(s2) ? (this.isNumber(s2) ? QRCodeDataType.NUMBERS : QRCodeDataType.UPPER_ALPHA_NUM) : QRCodeDataType.DEFAULT;
    }

    private final boolean isNumber(String s2) {
        CharSequence charSequence = s2;
        return new Regex("^\\d+$").matches(charSequence);
    }

    private final boolean isAlphaNum(String s2) {
        CharSequence charSequence = s2;
        return new Regex("^[0-9A-Z $%*+\\-./:]+$").matches(charSequence);
    }

    public final int getBCHTypeInfo(int data2) {
        int d = data2 << 10;
        while (this.getBCHDigit(d) - this.getBCHDigit(1335) >= 0) {
            d ^= 1335 << this.getBCHDigit(d) - this.getBCHDigit(1335);
        }
        return (data2 << 10 | d) ^ 0x5412;
    }

    public final int getBCHTypeNumber(int data2) {
        int d = data2 << 12;
        while (this.getBCHDigit(d) - this.getBCHDigit(7973) >= 0) {
            d ^= 7973 << this.getBCHDigit(d) - this.getBCHDigit(7973);
        }
        return data2 << 12 | d;
    }

    private final int getBCHDigit(int data2) {
        int digit = 0;
        for (int i2 = data2; i2 != 0; i2 >>>= 1) {
            ++digit;
        }
        return digit;
    }

    static {
        Object object = new int[40][];
        object[0] = new int[0];
        Object object2 = new int[]{6, 18};
        object[1] = object2;
        object2 = new int[]{6, 22};
        object[2] = object2;
        object2 = new int[]{6, 26};
        object[3] = object2;
        object2 = new int[]{6, 30};
        object[4] = object2;
        object2 = new int[]{6, 34};
        object[5] = object2;
        object2 = new int[]{6, 22, 38};
        object[6] = object2;
        object2 = new int[]{6, 24, 42};
        object[7] = object2;
        object2 = new int[]{6, 26, 46};
        object[8] = object2;
        object2 = new int[]{6, 28, 50};
        object[9] = object2;
        object2 = new int[]{6, 30, 54};
        object[10] = object2;
        object2 = new int[]{6, 32, 58};
        object[11] = object2;
        object2 = new int[]{6, 34, 62};
        object[12] = object2;
        object2 = new int[]{6, 26, 46, 66};
        object[13] = object2;
        object2 = new int[]{6, 26, 48, 70};
        object[14] = object2;
        object2 = new int[]{6, 26, 50, 74};
        object[15] = object2;
        object2 = new int[]{6, 30, 54, 78};
        object[16] = object2;
        object2 = new int[]{6, 30, 56, 82};
        object[17] = object2;
        object2 = new int[]{6, 30, 58, 86};
        object[18] = object2;
        object2 = new int[]{6, 34, 62, 90};
        object[19] = object2;
        object2 = new int[]{6, 28, 50, 72, 94};
        object[20] = object2;
        object2 = new int[]{6, 26, 50, 74, 98};
        object[21] = object2;
        object2 = new int[]{6, 30, 54, 78, 102};
        object[22] = object2;
        object2 = new int[]{6, 28, 54, 80, 106};
        object[23] = object2;
        object2 = new int[]{6, 32, 58, 84, 110};
        object[24] = object2;
        object2 = new int[]{6, 30, 58, 86, 114};
        object[25] = object2;
        object2 = new int[]{6, 34, 62, 90, 118};
        object[26] = object2;
        object2 = new int[]{6, 26, 50, 74, 98, 122};
        object[27] = object2;
        object2 = new int[]{6, 30, 54, 78, 102, 126};
        object[28] = object2;
        object2 = new int[]{6, 26, 52, 78, 104, 130};
        object[29] = object2;
        object2 = new int[]{6, 30, 56, 82, 108, 134};
        object[30] = object2;
        object2 = new int[]{6, 34, 60, 86, 112, 138};
        object[31] = object2;
        object2 = new int[]{6, 30, 58, 86, 114, 142};
        object[32] = object2;
        object2 = new int[]{6, 34, 62, 90, 118, 146};
        object[33] = object2;
        object2 = new int[]{6, 30, 54, 78, 102, 126, 150};
        object[34] = object2;
        object2 = new int[]{6, 24, 50, 76, 102, 128, 154};
        object[35] = object2;
        object2 = new int[]{6, 28, 54, 80, 106, 132, 158};
        object[36] = object2;
        object2 = new int[]{6, 32, 58, 84, 110, 136, 162};
        object[37] = object2;
        object2 = new int[]{6, 26, 54, 82, 110, 138, 166};
        object[38] = object2;
        object2 = new int[]{6, 30, 58, 86, 114, 142, 170};
        object[39] = object2;
        PATTERN_POSITION_TABLE = object;
        object = new int[34][][];
        object2 = new int[4][];
        int[] nArray = new int[]{41, 25, 17, 10};
        object2[0] = (int)nArray;
        nArray = new int[]{34, 20, 14, 8};
        object2[1] = (int)nArray;
        nArray = new int[]{27, 16, 11, 7};
        object2[2] = (int)nArray;
        nArray = new int[]{17, 10, 7, 4};
        object2[3] = (int)nArray;
        object[0] = object2;
        object2 = new int[4][];
        nArray = new int[]{77, 47, 32, 20};
        object2[0] = (int)nArray;
        nArray = new int[]{63, 38, 26, 16};
        object2[1] = (int)nArray;
        nArray = new int[]{48, 29, 20, 12};
        object2[2] = (int)nArray;
        nArray = new int[]{34, 20, 14, 8};
        object2[3] = (int)nArray;
        object[1] = object2;
        object2 = new int[4][];
        nArray = new int[]{127, 77, 53, 32};
        object2[0] = (int)nArray;
        nArray = new int[]{101, 61, 42, 26};
        object2[1] = (int)nArray;
        nArray = new int[]{77, 47, 32, 20};
        object2[2] = (int)nArray;
        nArray = new int[]{58, 35, 24, 15};
        object2[3] = (int)nArray;
        object[2] = object2;
        object2 = new int[4][];
        nArray = new int[]{187, 114, 78, 48};
        object2[0] = (int)nArray;
        nArray = new int[]{149, 90, 62, 38};
        object2[1] = (int)nArray;
        nArray = new int[]{111, 67, 46, 28};
        object2[2] = (int)nArray;
        nArray = new int[]{82, 50, 34, 21};
        object2[3] = (int)nArray;
        object[3] = object2;
        object2 = new int[4][];
        nArray = new int[]{255, 154, 106, 65};
        object2[0] = (int)nArray;
        nArray = new int[]{202, 122, 84, 52};
        object2[1] = (int)nArray;
        nArray = new int[]{144, 87, 60, 37};
        object2[2] = (int)nArray;
        nArray = new int[]{106, 64, 44, 27};
        object2[3] = (int)nArray;
        object[4] = object2;
        object2 = new int[4][];
        nArray = new int[]{322, 195, 134, 82};
        object2[0] = (int)nArray;
        nArray = new int[]{255, 154, 106, 65};
        object2[1] = (int)nArray;
        nArray = new int[]{178, 108, 74, 45};
        object2[2] = (int)nArray;
        nArray = new int[]{139, 84, 58, 36};
        object2[3] = (int)nArray;
        object[5] = object2;
        object2 = new int[4][];
        nArray = new int[]{370, 224, 154, 95};
        object2[0] = (int)nArray;
        nArray = new int[]{293, 178, 122, 75};
        object2[1] = (int)nArray;
        nArray = new int[]{207, 125, 86, 53};
        object2[2] = (int)nArray;
        nArray = new int[]{154, 93, 64, 39};
        object2[3] = (int)nArray;
        object[6] = object2;
        object2 = new int[4][];
        nArray = new int[]{461, 279, 192, 118};
        object2[0] = (int)nArray;
        nArray = new int[]{365, 221, 152, 93};
        object2[1] = (int)nArray;
        nArray = new int[]{259, 157, 108, 66};
        object2[2] = (int)nArray;
        nArray = new int[]{202, 122, 84, 52};
        object2[3] = (int)nArray;
        object[7] = object2;
        object2 = new int[4][];
        nArray = new int[]{552, 335, 230, 141};
        object2[0] = (int)nArray;
        nArray = new int[]{432, 262, 180, 111};
        object2[1] = (int)nArray;
        nArray = new int[]{312, 189, 130, 80};
        object2[2] = (int)nArray;
        nArray = new int[]{235, 143, 98, 60};
        object2[3] = (int)nArray;
        object[8] = object2;
        object2 = new int[4][];
        nArray = new int[]{652, 395, 271, 167};
        object2[0] = (int)nArray;
        nArray = new int[]{513, 311, 213, 131};
        object2[1] = (int)nArray;
        nArray = new int[]{364, 221, 151, 93};
        object2[2] = (int)nArray;
        nArray = new int[]{288, 174, 119, 74};
        object2[3] = (int)nArray;
        object[9] = object2;
        object2 = new int[4][];
        nArray = new int[]{772, 468, 321, 198};
        object2[0] = (int)nArray;
        nArray = new int[]{604, 366, 251, 155};
        object2[1] = (int)nArray;
        nArray = new int[]{427, 259, 177, 109};
        object2[2] = (int)nArray;
        nArray = new int[]{331, 200, 137, 85};
        object2[3] = (int)nArray;
        object[10] = object2;
        object2 = new int[4][];
        nArray = new int[]{883, 535, 367, 226};
        object2[0] = (int)nArray;
        nArray = new int[]{691, 419, 287, 177};
        object2[1] = (int)nArray;
        nArray = new int[]{489, 296, 203, 125};
        object2[2] = (int)nArray;
        nArray = new int[]{374, 227, 155, 96};
        object2[3] = (int)nArray;
        object[11] = object2;
        object2 = new int[4][];
        nArray = new int[]{1022, 619, 425, 262};
        object2[0] = (int)nArray;
        nArray = new int[]{796, 483, 331, 204};
        object2[1] = (int)nArray;
        nArray = new int[]{580, 352, 241, 149};
        object2[2] = (int)nArray;
        nArray = new int[]{427, 259, 177, 109};
        object2[3] = (int)nArray;
        object[12] = object2;
        object2 = new int[4][];
        nArray = new int[]{1101, 667, 458, 282};
        object2[0] = (int)nArray;
        nArray = new int[]{871, 528, 362, 223};
        object2[1] = (int)nArray;
        nArray = new int[]{621, 376, 258, 159};
        object2[2] = (int)nArray;
        nArray = new int[]{468, 283, 194, 120};
        object2[3] = (int)nArray;
        object[13] = object2;
        object2 = new int[4][];
        nArray = new int[]{1250, 758, 520, 320};
        object2[0] = (int)nArray;
        nArray = new int[]{991, 600, 412, 254};
        object2[1] = (int)nArray;
        nArray = new int[]{703, 426, 292, 180};
        object2[2] = (int)nArray;
        nArray = new int[]{530, 321, 220, 136};
        object2[3] = (int)nArray;
        object[14] = object2;
        object2 = new int[4][];
        nArray = new int[]{1408, 854, 586, 361};
        object2[0] = (int)nArray;
        nArray = new int[]{1082, 656, 450, 277};
        object2[1] = (int)nArray;
        nArray = new int[]{775, 470, 322, 198};
        object2[2] = (int)nArray;
        nArray = new int[]{602, 365, 250, 154};
        object2[3] = (int)nArray;
        object[15] = object2;
        object2 = new int[4][];
        nArray = new int[]{1548, 938, 644, 397};
        object2[0] = (int)nArray;
        nArray = new int[]{1212, 734, 504, 310};
        object2[1] = (int)nArray;
        nArray = new int[]{876, 531, 364, 224};
        object2[2] = (int)nArray;
        nArray = new int[]{674, 408, 280, 173};
        object2[3] = (int)nArray;
        object[16] = object2;
        object2 = new int[4][];
        nArray = new int[]{1725, 1046, 718, 442};
        object2[0] = (int)nArray;
        nArray = new int[]{1346, 816, 560, 345};
        object2[1] = (int)nArray;
        nArray = new int[]{948, 574, 394, 243};
        object2[2] = (int)nArray;
        nArray = new int[]{746, 452, 310, 191};
        object2[3] = (int)nArray;
        object[17] = object2;
        object2 = new int[4][];
        nArray = new int[]{1903, 1153, 792, 488};
        object2[0] = (int)nArray;
        nArray = new int[]{1500, 909, 624, 384};
        object2[1] = (int)nArray;
        nArray = new int[]{1063, 644, 442, 272};
        object2[2] = (int)nArray;
        nArray = new int[]{813, 493, 338, 208};
        object2[3] = (int)nArray;
        object[18] = object2;
        object2 = new int[4][];
        nArray = new int[]{2061, 1249, 858, 528};
        object2[0] = (int)nArray;
        nArray = new int[]{1600, 970, 666, 410};
        object2[1] = (int)nArray;
        nArray = new int[]{1159, 702, 482, 297};
        object2[2] = (int)nArray;
        nArray = new int[]{919, 557, 382, 235};
        object2[3] = (int)nArray;
        object[19] = object2;
        object2 = new int[4][];
        nArray = new int[]{2232, 1352, 929, 572};
        object2[0] = (int)nArray;
        nArray = new int[]{1708, 1035, 711, 438};
        object2[1] = (int)nArray;
        nArray = new int[]{1224, 742, 509, 314};
        object2[2] = (int)nArray;
        nArray = new int[]{969, 587, 403, 248};
        object2[3] = (int)nArray;
        object[20] = object2;
        object2 = new int[4][];
        nArray = new int[]{2409, 1460, 1003, 618};
        object2[0] = (int)nArray;
        nArray = new int[]{1872, 1134, 779, 480};
        object2[1] = (int)nArray;
        nArray = new int[]{1358, 823, 565, 348};
        object2[2] = (int)nArray;
        nArray = new int[]{1056, 640, 439, 270};
        object2[3] = (int)nArray;
        object[21] = object2;
        object2 = new int[4][];
        nArray = new int[]{2620, 1588, 1091, 672};
        object2[0] = (int)nArray;
        nArray = new int[]{2059, 1248, 857, 528};
        object2[1] = (int)nArray;
        nArray = new int[]{1468, 890, 611, 376};
        object2[2] = (int)nArray;
        nArray = new int[]{1108, 672, 461, 284};
        object2[3] = (int)nArray;
        object[22] = object2;
        object2 = new int[4][];
        nArray = new int[]{2812, 1704, 1171, 721};
        object2[0] = (int)nArray;
        nArray = new int[]{2188, 1326, 911, 561};
        object2[1] = (int)nArray;
        nArray = new int[]{1588, 963, 661, 407};
        object2[2] = (int)nArray;
        nArray = new int[]{1228, 744, 511, 315};
        object2[3] = (int)nArray;
        object[23] = object2;
        object2 = new int[4][];
        nArray = new int[]{3057, 1853, 1273, 784};
        object2[0] = (int)nArray;
        nArray = new int[]{2395, 1451, 997, 614};
        object2[1] = (int)nArray;
        nArray = new int[]{1718, 1041, 715, 440};
        object2[2] = (int)nArray;
        nArray = new int[]{1286, 779, 535, 330};
        object2[3] = (int)nArray;
        object[24] = object2;
        object2 = new int[4][];
        nArray = new int[]{3283, 1990, 1367, 842};
        object2[0] = (int)nArray;
        nArray = new int[]{2544, 1542, 1059, 652};
        object2[1] = (int)nArray;
        nArray = new int[]{1804, 1094, 751, 462};
        object2[2] = (int)nArray;
        nArray = new int[]{1425, 864, 593, 365};
        object2[3] = (int)nArray;
        object[25] = object2;
        object2 = new int[4][];
        nArray = new int[]{3517, 2132, 1465, 902};
        object2[0] = (int)nArray;
        nArray = new int[]{2701, 1637, 1125, 692};
        object2[1] = (int)nArray;
        nArray = new int[]{1933, 1172, 805, 496};
        object2[2] = (int)nArray;
        nArray = new int[]{1501, 910, 625, 385};
        object2[3] = (int)nArray;
        object[26] = object2;
        object2 = new int[4][];
        nArray = new int[]{3669, 2223, 1528, 940};
        object2[0] = (int)nArray;
        nArray = new int[]{2857, 1732, 1190, 732};
        object2[1] = (int)nArray;
        nArray = new int[]{2085, 1263, 868, 534};
        object2[2] = (int)nArray;
        nArray = new int[]{1581, 958, 658, 405};
        object2[3] = (int)nArray;
        object[27] = object2;
        object2 = new int[4][];
        nArray = new int[]{3909, 2369, 1628, 1002};
        object2[0] = (int)nArray;
        nArray = new int[]{3035, 1839, 1264, 778};
        object2[1] = (int)nArray;
        nArray = new int[]{2181, 1322, 908, 559};
        object2[2] = (int)nArray;
        nArray = new int[]{1677, 1016, 698, 430};
        object2[3] = (int)nArray;
        object[28] = object2;
        object2 = new int[4][];
        nArray = new int[]{4158, 2520, 1732, 1066};
        object2[0] = (int)nArray;
        nArray = new int[]{3289, 1994, 1370, 843};
        object2[1] = (int)nArray;
        nArray = new int[]{2358, 1429, 982, 604};
        object2[2] = (int)nArray;
        nArray = new int[]{1782, 1080, 742, 457};
        object2[3] = (int)nArray;
        object[29] = object2;
        object2 = new int[4][];
        nArray = new int[]{4417, 2677, 1840, 1132};
        object2[0] = (int)nArray;
        nArray = new int[]{3486, 2113, 1452, 894};
        object2[1] = (int)nArray;
        nArray = new int[]{2473, 1499, 1030, 634};
        object2[2] = (int)nArray;
        nArray = new int[]{1897, 1150, 790, 486};
        object2[3] = (int)nArray;
        object[30] = object2;
        object2 = new int[4][];
        nArray = new int[]{4686, 2840, 1952, 1201};
        object2[0] = (int)nArray;
        nArray = new int[]{3693, 2238, 1538, 947};
        object2[1] = (int)nArray;
        nArray = new int[]{2670, 1618, 1112, 684};
        object2[2] = (int)nArray;
        nArray = new int[]{2022, 1226, 842, 518};
        object2[3] = (int)nArray;
        object[31] = object2;
        object2 = new int[4][];
        nArray = new int[]{4965, 3009, 2068, 1273};
        object2[0] = (int)nArray;
        nArray = new int[]{3909, 2369, 1628, 1002};
        object2[1] = (int)nArray;
        nArray = new int[]{2805, 1700, 1168, 719};
        object2[2] = (int)nArray;
        nArray = new int[]{2157, 1307, 898, 553};
        object2[3] = (int)nArray;
        object[32] = object2;
        object2 = new int[4][];
        nArray = new int[]{5253, 3183, 2188, 1347};
        object2[0] = (int)nArray;
        nArray = new int[]{4134, 2506, 1722, 1060};
        object2[1] = (int)nArray;
        nArray = new int[]{2949, 1787, 1228, 756};
        object2[2] = (int)nArray;
        nArray = new int[]{2301, 1394, 958, 590};
        object2[3] = (int)nArray;
        object[33] = object2;
        MAX_LENGTH = (int[][][])object;
        $stable = 8;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MaskPattern.values().length];
            try {
                nArray[MaskPattern.PATTERN000.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MaskPattern.PATTERN001.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MaskPattern.PATTERN010.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MaskPattern.PATTERN011.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MaskPattern.PATTERN100.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MaskPattern.PATTERN101.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MaskPattern.PATTERN110.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MaskPattern.PATTERN111.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

