/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.serialization;

import androidx.annotation.RestrictTo;
import androidx.navigation.NamedNavArgument;
import androidx.navigation.NamedNavArgumentKt;
import androidx.navigation.NavArgumentBuilder;
import androidx.navigation.NavType;
import androidx.navigation.serialization.NavTypeConverterKt;
import androidx.navigation.serialization.RouteBuilder;
import androidx.navigation.serialization.RouteEncoder;
import androidx.navigation.serialization.UNKNOWN;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.ContextAwareKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\u001a>\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0000\u001a8\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005H\u0007\u001a;\u0010\f\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\r2\u0006\u0010\u000e\u001a\u0002H\u00022\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00070\u0005H\u0007\u00a2\u0006\u0002\u0010\u000f\u001a&\u0010\u0010\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002\u001a.\u0010\u0014\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u0007*\u00020\u00152\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003H\u0007\u001a\u008c\u0001\u0010\u0018\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00052S\u0010\u0019\u001aO\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0007\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00110\u001aH\u0003\u00a2\u0006\u0002\b \u001a\u008e\u0001\u0010\u0018\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00070\u00052S\u0010\u0019\u001aO\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u001b\u0012\u0019\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0007\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00110\u001aH\u0003\u00a2\u0006\u0002\b!\u001a(\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\f\u0010&\u001a\u00020'*\u00020\u0015H\u0000\u00a8\u0006("}, d2={"generateRoutePattern", "", "T", "Lkotlinx/serialization/KSerializer;", "typeMap", "", "Lkotlin/reflect/KType;", "Landroidx/navigation/NavType;", "path", "generateNavArguments", "", "Landroidx/navigation/NamedNavArgument;", "generateRouteWithArgs", "", "route", "(Ljava/lang/Object;Ljava/util/Map;)Ljava/lang/String;", "assertNotAbstractClass", "", "handler", "Lkotlin/Function0;", "computeNavType", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "generateHashCode", "", "forEachIndexed", "operation", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "index", "argName", "navType", "forEachIndexedKType", "forEachIndexedName", "unknownNavTypeErrorMessage", "fieldName", "fieldType", "className", "isValueClass", "", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nRouteSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSerializer.kt\nandroidx/navigation/serialization/RouteSerializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
public final class RouteSerializerKt {
    @NotNull
    public static final <T> String generateRoutePattern(@NotNull KSerializer<T> $this$generateRoutePattern, @NotNull Map<KType, ? extends NavType<?>> typeMap, @Nullable String path) {
        Intrinsics.checkNotNullParameter($this$generateRoutePattern, (String)"<this>");
        Intrinsics.checkNotNullParameter(typeMap, (String)"typeMap");
        RouteSerializerKt.assertNotAbstractClass($this$generateRoutePattern, (Function0<Unit>)((Function0)() -> RouteSerializerKt.generateRoutePattern$lambda$0($this$generateRoutePattern)));
        RouteBuilder<T> builder = path != null ? new RouteBuilder<T>(path, $this$generateRoutePattern) : new RouteBuilder<T>($this$generateRoutePattern);
        RouteSerializerKt.forEachIndexedKType($this$generateRoutePattern, typeMap, (Function3<? super Integer, ? super String, ? super NavType<Object>, Unit>)((Function3)(arg_0, arg_1, arg_2) -> RouteSerializerKt.generateRoutePattern$lambda$1(builder, arg_0, arg_1, arg_2)));
        return builder.build();
    }

    public static /* synthetic */ String generateRoutePattern$default(KSerializer kSerializer, Map map, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return RouteSerializerKt.generateRoutePattern(kSerializer, map, string);
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final <T> List<NamedNavArgument> generateNavArguments(@NotNull KSerializer<T> $this$generateNavArguments, @NotNull Map<KType, ? extends NavType<?>> typeMap) {
        Intrinsics.checkNotNullParameter($this$generateNavArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter(typeMap, (String)"typeMap");
        RouteSerializerKt.assertNotAbstractClass($this$generateNavArguments, (Function0<Unit>)((Function0)() -> RouteSerializerKt.generateNavArguments$lambda$2($this$generateNavArguments)));
        int n = $this$generateNavArguments.getDescriptor().getElementsCount();
        ArrayList<NamedNavArgument> arrayList = new ArrayList<NamedNavArgument>(n);
        int n2 = 0;
        while (n2 < n) {
            void index;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<NamedNavArgument> arrayList2 = arrayList;
            boolean bl = false;
            String name = $this$generateNavArguments.getDescriptor().getElementName((int)index);
            arrayList2.add(NamedNavArgumentKt.navArgument(name, (Function1<? super NavArgumentBuilder, Unit>)((Function1)arg_0 -> RouteSerializerKt.generateNavArguments$lambda$4$lambda$3($this$generateNavArguments, (int)index, typeMap, name, arg_0))));
        }
        return arrayList;
    }

    public static /* synthetic */ List generateNavArguments$default(KSerializer kSerializer, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        return RouteSerializerKt.generateNavArguments(kSerializer, map);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final <T> String generateRouteWithArgs(@NotNull T route, @NotNull Map<String, ? extends NavType<Object>> typeMap) {
        Intrinsics.checkNotNullParameter(route, (String)"route");
        Intrinsics.checkNotNullParameter(typeMap, (String)"typeMap");
        KSerializer serializer = SerializersKt.serializer((KClass)Reflection.getOrCreateKotlinClass(route.getClass()));
        Map<String, List<String>> argMap = new RouteEncoder(serializer, typeMap).encodeToArgMap(route);
        RouteBuilder builder = new RouteBuilder(serializer);
        RouteSerializerKt.forEachIndexedName(serializer, typeMap, (Function3<? super Integer, ? super String, ? super NavType<Object>, Unit>)((Function3)(arg_0, arg_1, arg_2) -> RouteSerializerKt.generateRouteWithArgs$lambda$5(argMap, builder, arg_0, arg_1, arg_2)));
        return builder.build();
    }

    private static final <T> void assertNotAbstractClass(KSerializer<T> $this$assertNotAbstractClass, Function0<Unit> handler) {
        if ($this$assertNotAbstractClass instanceof PolymorphicSerializer) {
            handler.invoke();
        }
    }

    private static final NavType<Object> computeNavType(SerialDescriptor $this$computeNavType, Map<KType, ? extends NavType<?>> typeMap) {
        NavType<?> navType;
        NavType<?> result;
        NavType<?> customType;
        NavType<?> navType2;
        NavType<?> navType3;
        NavType<?> navType4;
        Object v0;
        block6: {
            Iterable iterable = typeMap.keySet();
            for (Object t : iterable) {
                KType kType = (KType)t;
                boolean bl = false;
                if (!NavTypeConverterKt.matchKType($this$computeNavType, kType)) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        KType kType = v0;
        if (kType != null) {
            KType it = kType;
            boolean bl = false;
            navType4 = typeMap.get(it);
        } else {
            navType4 = navType3 = null;
        }
        if ((navType2 = (customType = navType3 instanceof NavType ? navType3 : null)) == null) {
            navType2 = NavTypeConverterKt.getNavType($this$computeNavType);
        }
        if (Intrinsics.areEqual(result = navType2, (Object)UNKNOWN.INSTANCE)) {
            navType = null;
        } else {
            Intrinsics.checkNotNull(result, (String)"null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any?>");
            navType = result;
        }
        return navType;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final <T> int generateHashCode(@NotNull KSerializer<T> $this$generateHashCode) {
        Intrinsics.checkNotNullParameter($this$generateHashCode, (String)"<this>");
        int hash = $this$generateHashCode.getDescriptor().getSerialName().hashCode();
        int n = $this$generateHashCode.getDescriptor().getElementsCount();
        for (int i = 0; i < n; ++i) {
            hash = 31 * hash + $this$generateHashCode.getDescriptor().getElementName(i).hashCode();
        }
        return hash;
    }

    @JvmName(name="forEachIndexedKType")
    private static final <T> void forEachIndexedKType(KSerializer<T> $this$forEachIndexed, Map<KType, ? extends NavType<?>> typeMap, Function3<? super Integer, ? super String, ? super NavType<Object>, Unit> operation) {
        int n = $this$forEachIndexed.getDescriptor().getElementsCount();
        for (int i = 0; i < n; ++i) {
            NavType<Object> navType;
            String argName = $this$forEachIndexed.getDescriptor().getElementName(i);
            if (RouteSerializerKt.computeNavType($this$forEachIndexed.getDescriptor().getElementDescriptor(i), typeMap) == null) {
                throw new IllegalArgumentException(RouteSerializerKt.unknownNavTypeErrorMessage(argName, $this$forEachIndexed.getDescriptor().getElementDescriptor(i).getSerialName(), $this$forEachIndexed.getDescriptor().getSerialName(), typeMap.toString()));
            }
            operation.invoke((Object)i, (Object)argName, navType);
        }
    }

    static /* synthetic */ void forEachIndexedKType$default(KSerializer kSerializer, Map map, Function3 function3, int n, Object object) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        RouteSerializerKt.forEachIndexedKType(kSerializer, map, (Function3<? super Integer, ? super String, ? super NavType<Object>, Unit>)function3);
    }

    @JvmName(name="forEachIndexedName")
    private static final <T> void forEachIndexedName(KSerializer<T> $this$forEachIndexed, Map<String, ? extends NavType<Object>> typeMap, Function3<? super Integer, ? super String, ? super NavType<Object>, Unit> operation) {
        int n = $this$forEachIndexed.getDescriptor().getElementsCount();
        for (int i = 0; i < n; ++i) {
            String argName = $this$forEachIndexed.getDescriptor().getElementName(i);
            NavType<Object> navType = typeMap.get(argName);
            if (navType == null) {
                boolean bl = false;
                String string = "Cannot locate NavType for argument [" + argName + "]";
                throw new IllegalStateException(string.toString());
            }
            operation.invoke((Object)i, (Object)argName, navType);
        }
    }

    private static final String unknownNavTypeErrorMessage(String fieldName, String fieldType, String className, String typeMap) {
        return "Route " + className + " could not find any NavType for argument " + fieldName + " of type " + fieldType + " - typeMap received was " + typeMap;
    }

    public static final boolean isValueClass(@NotNull SerialDescriptor $this$isValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isValueClass, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isValueClass.getKind(), (Object)StructureKind.CLASS.INSTANCE) && $this$isValueClass.isInline() && $this$isValueClass.getElementsCount() == 1;
    }

    private static final Unit generateRoutePattern$lambda$0(KSerializer $this_generateRoutePattern) {
        KClass kClass = ContextAwareKt.getCapturedKClass((SerialDescriptor)$this_generateRoutePattern.getDescriptor());
        throw new IllegalArgumentException("Cannot generate route pattern from polymorphic class " + (kClass != null ? kClass.getSimpleName() : null) + ". Routes can only be generated from concrete classes or objects.");
    }

    private static final Unit generateRoutePattern$lambda$1(RouteBuilder $builder, int index, String argName, NavType navType) {
        Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
        Intrinsics.checkNotNullParameter((Object)navType, (String)"navType");
        $builder.appendPattern(index, argName, navType);
        return Unit.INSTANCE;
    }

    private static final Unit generateNavArguments$lambda$2(KSerializer $this_generateNavArguments) {
        throw new IllegalArgumentException("Cannot generate NavArguments for polymorphic serializer " + $this_generateNavArguments + ". Arguments can only be generated from concrete classes or objects.");
    }

    private static final Unit generateNavArguments$lambda$4$lambda$3(KSerializer $this_generateNavArguments, int $index, Map $typeMap, String $name, NavArgumentBuilder $this$navArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$navArgument, (String)"$this$navArgument");
        SerialDescriptor element = $this_generateNavArguments.getDescriptor().getElementDescriptor($index);
        boolean isNullable = element.isNullable();
        NavType<Object> navType = RouteSerializerKt.computeNavType(element, $typeMap);
        if (navType == null) {
            throw new IllegalArgumentException(RouteSerializerKt.unknownNavTypeErrorMessage($name, element.getSerialName(), $this_generateNavArguments.getDescriptor().getSerialName(), $typeMap.toString()));
        }
        $this$navArgument.setType(navType);
        $this$navArgument.setNullable(isNullable);
        if ($this_generateNavArguments.getDescriptor().isElementOptional($index)) {
            $this$navArgument.setUnknownDefaultValuePresent$navigation_common(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateRouteWithArgs$lambda$5(Map $argMap, RouteBuilder $builder, int index, String argName, NavType navType) {
        Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
        Intrinsics.checkNotNullParameter((Object)navType, (String)"navType");
        Object v = $argMap.get(argName);
        Intrinsics.checkNotNull(v);
        List value = (List)v;
        $builder.appendArg(index, argName, navType, value);
        return Unit.INSTANCE;
    }
}

