/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import com.ustadmobile.libcache.db.dao.CacheEntryDao;
import com.ustadmobile.libcache.db.entities.CacheEntry;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0014\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0018\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010 \u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010\"J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010 \u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010\"J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010%\u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010\"J\u000e\u0010&\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010'J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\u0006\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010.J.\u0010/\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u00103R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/ustadmobile/libcache/db/dao/CacheEntryDao_Impl;", "Lcom/ustadmobile/libcache/db/dao/CacheEntryDao;", "__db", "Landroidx/room/RoomDatabase;", "<init>", "(Landroidx/room/RoomDatabase;)V", "__insertAdapterOfCacheEntry", "Landroidx/room/EntityInsertAdapter;", "Lcom/ustadmobile/libcache/db/entities/CacheEntry;", "__insertAdapterOfCacheEntry_1", "__deleteAdapterOfCacheEntry", "Landroidx/room/EntityDeleteOrUpdateAdapter;", "__updateAdapterOfCacheEntry", "insertAsync", "", "entry", "(Lcom/ustadmobile/libcache/db/entities/CacheEntry;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertList", "", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "upsertList", "delete", "entries", "updateList", "findByUrlAsync", "url", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findEntryAndBodyByKey", "key", "findByRequestBatchId", "batchId", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findEntriesWithLock", "findEvictableEntries", "batchSize", "totalEvictableSize", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getEntryUrlsInOrder", "offset", "limit", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateLastAccessedTime", "lastAccessTime", "(Ljava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateValidation", "headers", "lastValidated", "lastAccessed", "(Ljava/lang/String;Ljava/lang/String;JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "respect-lib-cache_release"})
public final class CacheEntryDao_Impl
extends CacheEntryDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase __db;
    @NotNull
    private final EntityInsertAdapter<CacheEntry> __insertAdapterOfCacheEntry;
    @NotNull
    private final EntityInsertAdapter<CacheEntry> __insertAdapterOfCacheEntry_1;
    @NotNull
    private final EntityDeleteOrUpdateAdapter<CacheEntry> __deleteAdapterOfCacheEntry;
    @NotNull
    private final EntityDeleteOrUpdateAdapter<CacheEntry> __updateAdapterOfCacheEntry;

    public CacheEntryDao_Impl(@NotNull RoomDatabase __db) {
        Intrinsics.checkNotNullParameter((Object)__db, (String)"__db");
        this.__db = __db;
        this.__insertAdapterOfCacheEntry = (EntityInsertAdapter)new EntityInsertAdapter<CacheEntry>(){

            protected String createQuery() {
                return "INSERT OR ABORT INTO `CacheEntry` (`key`,`url`,`message`,`statusCode`,`cacheFlags`,`method`,`lastAccessed`,`lastValidated`,`integrity`,`responseHeaders`,`storageUri`,`storageSize`,`uncompressedSize`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, CacheEntry entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getKey());
                statement.bindText(2, entity.getUrl());
                statement.bindText(3, entity.getMessage());
                statement.bindLong(4, (long)entity.getStatusCode());
                statement.bindLong(5, (long)entity.getCacheFlags());
                statement.bindLong(6, (long)entity.getMethod());
                statement.bindLong(7, entity.getLastAccessed());
                statement.bindLong(8, entity.getLastValidated());
                String _tmpIntegrity = entity.getIntegrity();
                if (_tmpIntegrity == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmpIntegrity);
                }
                statement.bindText(10, entity.getResponseHeaders());
                statement.bindText(11, entity.getStorageUri());
                statement.bindLong(12, entity.getStorageSize());
                statement.bindLong(13, entity.getUncompressedSize());
            }
        };
        this.__insertAdapterOfCacheEntry_1 = (EntityInsertAdapter)new EntityInsertAdapter<CacheEntry>(){

            protected String createQuery() {
                return "INSERT OR REPLACE INTO `CacheEntry` (`key`,`url`,`message`,`statusCode`,`cacheFlags`,`method`,`lastAccessed`,`lastValidated`,`integrity`,`responseHeaders`,`storageUri`,`storageSize`,`uncompressedSize`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(SQLiteStatement statement, CacheEntry entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getKey());
                statement.bindText(2, entity.getUrl());
                statement.bindText(3, entity.getMessage());
                statement.bindLong(4, (long)entity.getStatusCode());
                statement.bindLong(5, (long)entity.getCacheFlags());
                statement.bindLong(6, (long)entity.getMethod());
                statement.bindLong(7, entity.getLastAccessed());
                statement.bindLong(8, entity.getLastValidated());
                String _tmpIntegrity = entity.getIntegrity();
                if (_tmpIntegrity == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmpIntegrity);
                }
                statement.bindText(10, entity.getResponseHeaders());
                statement.bindText(11, entity.getStorageUri());
                statement.bindLong(12, entity.getStorageSize());
                statement.bindLong(13, entity.getUncompressedSize());
            }
        };
        this.__deleteAdapterOfCacheEntry = (EntityDeleteOrUpdateAdapter)new EntityDeleteOrUpdateAdapter<CacheEntry>(){

            protected String createQuery() {
                return "DELETE FROM `CacheEntry` WHERE `key` = ?";
            }

            protected void bind(SQLiteStatement statement, CacheEntry entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getKey());
            }
        };
        this.__updateAdapterOfCacheEntry = (EntityDeleteOrUpdateAdapter)new EntityDeleteOrUpdateAdapter<CacheEntry>(){

            protected String createQuery() {
                return "UPDATE OR ABORT `CacheEntry` SET `key` = ?,`url` = ?,`message` = ?,`statusCode` = ?,`cacheFlags` = ?,`method` = ?,`lastAccessed` = ?,`lastValidated` = ?,`integrity` = ?,`responseHeaders` = ?,`storageUri` = ?,`storageSize` = ?,`uncompressedSize` = ? WHERE `key` = ?";
            }

            protected void bind(SQLiteStatement statement, CacheEntry entity) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                statement.bindText(1, entity.getKey());
                statement.bindText(2, entity.getUrl());
                statement.bindText(3, entity.getMessage());
                statement.bindLong(4, (long)entity.getStatusCode());
                statement.bindLong(5, (long)entity.getCacheFlags());
                statement.bindLong(6, (long)entity.getMethod());
                statement.bindLong(7, entity.getLastAccessed());
                statement.bindLong(8, entity.getLastValidated());
                String _tmpIntegrity = entity.getIntegrity();
                if (_tmpIntegrity == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmpIntegrity);
                }
                statement.bindText(10, entity.getResponseHeaders());
                statement.bindText(11, entity.getStorageUri());
                statement.bindLong(12, entity.getStorageSize());
                statement.bindLong(13, entity.getUncompressedSize());
                statement.bindText(14, entity.getKey());
            }
        };
    }

    @Override
    @Nullable
    public Object insertAsync(@NotNull CacheEntry entry, @NotNull Continuation<? super Long> $completion) {
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> CacheEntryDao_Impl.insertAsync$lambda$0(this, entry, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object insertList(@NotNull List<CacheEntry> entry, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> CacheEntryDao_Impl.insertList$lambda$0(this, entry, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object upsertList(@NotNull List<CacheEntry> entry, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> CacheEntryDao_Impl.upsertList$lambda$0(this, entry, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object delete(@NotNull List<CacheEntry> entries, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> CacheEntryDao_Impl.delete$lambda$0(this, entries, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object updateList(@NotNull List<CacheEntry> entry, @NotNull Continuation<? super Unit> $completion) {
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> CacheEntryDao_Impl.updateList$lambda$0(this, entry, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object findByUrlAsync(@NotNull String url, @NotNull Continuation<? super CacheEntry> $completion) {
        String _sql = "\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.url = ? \n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> CacheEntryDao_Impl.findByUrlAsync$lambda$0(_sql, url, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findEntryAndBodyByKey(@NotNull String key, @NotNull Continuation<? super CacheEntry> $completion) {
        String _sql = "\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.key = ?\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> CacheEntryDao_Impl.findEntryAndBodyByKey$lambda$0(_sql, key, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findByRequestBatchId(int batchId, @NotNull Continuation<? super List<CacheEntry>> $completion) {
        String _sql = "\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.key IN\n               (SELECT RequestedEntry.requestedKey\n                  FROM RequestedEntry\n                 WHERE RequestedEntry.batchId = ?)\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> CacheEntryDao_Impl.findByRequestBatchId$lambda$0(_sql, batchId, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findEntriesWithLock(int batchId, @NotNull Continuation<? super List<String>> $completion) {
        String _sql = "\n        SELECT RequestedEntry.requestedKey\n          FROM RequestedEntry\n         WHERE RequestedEntry.batchId = ?\n           AND EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = RequestedEntry.requestedKey)\n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> CacheEntryDao_Impl.findEntriesWithLock$lambda$0(_sql, batchId, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object findEvictableEntries(int batchSize, @NotNull Continuation<? super List<CacheEntry>> $completion) {
        String _sql = "\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE NOT EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = CacheEntry.key) \n      ORDER BY lastAccessed ASC           \n         LIMIT ?       \n      \n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> CacheEntryDao_Impl.findEvictableEntries$lambda$0(_sql, batchSize, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object totalEvictableSize(@NotNull Continuation<? super Long> $completion) {
        String _sql = "\n        SELECT SUM(CacheEntry.storageSize)\n          FROM CacheEntry\n         WHERE NOT EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = CacheEntry.key)  \n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> CacheEntryDao_Impl.totalEvictableSize$lambda$0(_sql, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object getEntryUrlsInOrder(int offset, int limit, @NotNull Continuation<? super List<String>> $completion) {
        String _sql = "\n        SELECT CacheEntry.url\n          FROM CacheEntry\n      ORDER BY CacheEntry.key \n         LIMIT ?\n        OFFSET ?\n       \n    ";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, arg_0 -> CacheEntryDao_Impl.getEntryUrlsInOrder$lambda$0(_sql, limit, offset, arg_0), $completion);
    }

    @Override
    @Nullable
    public Object updateLastAccessedTime(@NotNull String key, long lastAccessTime, @NotNull Continuation<? super Unit> $completion) {
        String _sql = "\n        UPDATE CacheEntry\n           SET lastAccessed = ?\n         WHERE key = ?  \n    ";
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> CacheEntryDao_Impl.updateLastAccessedTime$lambda$0(_sql, lastAccessTime, key, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object updateValidation(@NotNull String key, @NotNull String headers, long lastValidated, long lastAccessed, @NotNull Continuation<? super Unit> $completion) {
        String _sql = "\n        UPDATE CacheEntry\n           SET responseHeaders = ?,\n               lastValidated = ?,\n               lastAccessed = ?\n         WHERE key = ?      \n    ";
        Object object = DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, arg_0 -> CacheEntryDao_Impl.updateValidation$lambda$0(_sql, headers, lastValidated, lastAccessed, key, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final long insertAsync$lambda$0(CacheEntryDao_Impl this$0, CacheEntry $entry, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        long _result = this$0.__insertAdapterOfCacheEntry.insertAndReturnId(_connection, (Object)$entry);
        return _result;
    }

    private static final Unit insertList$lambda$0(CacheEntryDao_Impl this$0, List $entry, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfCacheEntry.insert(_connection, (Iterable)$entry);
        return Unit.INSTANCE;
    }

    private static final Unit upsertList$lambda$0(CacheEntryDao_Impl this$0, List $entry, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__insertAdapterOfCacheEntry_1.insert(_connection, (Iterable)$entry);
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$0(CacheEntryDao_Impl this$0, List $entries, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__deleteAdapterOfCacheEntry.handleMultiple(_connection, (Iterable)$entries);
        return Unit.INSTANCE;
    }

    private static final Unit updateList$lambda$0(CacheEntryDao_Impl this$0, List $entry, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        this$0.__updateAdapterOfCacheEntry.handleMultiple(_connection, (Iterable)$entry);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CacheEntry findByUrlAsync$lambda$0(String $_sql, String $url, SQLiteConnection _connection) {
        CacheEntry cacheEntry;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $url);
            int _columnIndexOfKey = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"key");
            int _columnIndexOfUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"url");
            int _columnIndexOfMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"message");
            int _columnIndexOfStatusCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"statusCode");
            int _columnIndexOfCacheFlags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cacheFlags");
            int _columnIndexOfMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"method");
            int _columnIndexOfLastAccessed = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastAccessed");
            int _columnIndexOfLastValidated = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastValidated");
            int _columnIndexOfIntegrity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"integrity");
            int _columnIndexOfResponseHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeaders");
            int _columnIndexOfStorageUri = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storageUri");
            int _columnIndexOfStorageSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storageSize");
            int _columnIndexOfUncompressedSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uncompressedSize");
            CacheEntry _result = null;
            if (_stmt.step()) {
                String _tmpKey = null;
                _tmpKey = _stmt.getText(_columnIndexOfKey);
                String _tmpUrl = null;
                _tmpUrl = _stmt.getText(_columnIndexOfUrl);
                String _tmpMessage = null;
                _tmpMessage = _stmt.getText(_columnIndexOfMessage);
                int _tmpStatusCode = 0;
                _tmpStatusCode = (int)_stmt.getLong(_columnIndexOfStatusCode);
                int _tmpCacheFlags = 0;
                _tmpCacheFlags = (int)_stmt.getLong(_columnIndexOfCacheFlags);
                int _tmpMethod = 0;
                _tmpMethod = (int)_stmt.getLong(_columnIndexOfMethod);
                long _tmpLastAccessed = 0L;
                _tmpLastAccessed = _stmt.getLong(_columnIndexOfLastAccessed);
                long _tmpLastValidated = 0L;
                _tmpLastValidated = _stmt.getLong(_columnIndexOfLastValidated);
                String _tmpIntegrity = null;
                _tmpIntegrity = _stmt.isNull(_columnIndexOfIntegrity) ? null : _stmt.getText(_columnIndexOfIntegrity);
                String _tmpResponseHeaders = null;
                _tmpResponseHeaders = _stmt.getText(_columnIndexOfResponseHeaders);
                String _tmpStorageUri = null;
                _tmpStorageUri = _stmt.getText(_columnIndexOfStorageUri);
                long _tmpStorageSize = 0L;
                _tmpStorageSize = _stmt.getLong(_columnIndexOfStorageSize);
                long _tmpUncompressedSize = 0L;
                _tmpUncompressedSize = _stmt.getLong(_columnIndexOfUncompressedSize);
                _result = new CacheEntry(_tmpKey, _tmpUrl, _tmpMessage, _tmpStatusCode, _tmpCacheFlags, _tmpMethod, _tmpLastAccessed, _tmpLastValidated, _tmpIntegrity, _tmpResponseHeaders, _tmpStorageUri, _tmpStorageSize, _tmpUncompressedSize);
            } else {
                _result = null;
            }
            cacheEntry = _result;
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CacheEntry findEntryAndBodyByKey$lambda$0(String $_sql, String $key, SQLiteConnection _connection) {
        CacheEntry cacheEntry;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $key);
            int _columnIndexOfKey = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"key");
            int _columnIndexOfUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"url");
            int _columnIndexOfMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"message");
            int _columnIndexOfStatusCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"statusCode");
            int _columnIndexOfCacheFlags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cacheFlags");
            int _columnIndexOfMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"method");
            int _columnIndexOfLastAccessed = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastAccessed");
            int _columnIndexOfLastValidated = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastValidated");
            int _columnIndexOfIntegrity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"integrity");
            int _columnIndexOfResponseHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeaders");
            int _columnIndexOfStorageUri = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storageUri");
            int _columnIndexOfStorageSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storageSize");
            int _columnIndexOfUncompressedSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uncompressedSize");
            CacheEntry _result = null;
            if (_stmt.step()) {
                String _tmpKey = null;
                _tmpKey = _stmt.getText(_columnIndexOfKey);
                String _tmpUrl = null;
                _tmpUrl = _stmt.getText(_columnIndexOfUrl);
                String _tmpMessage = null;
                _tmpMessage = _stmt.getText(_columnIndexOfMessage);
                int _tmpStatusCode = 0;
                _tmpStatusCode = (int)_stmt.getLong(_columnIndexOfStatusCode);
                int _tmpCacheFlags = 0;
                _tmpCacheFlags = (int)_stmt.getLong(_columnIndexOfCacheFlags);
                int _tmpMethod = 0;
                _tmpMethod = (int)_stmt.getLong(_columnIndexOfMethod);
                long _tmpLastAccessed = 0L;
                _tmpLastAccessed = _stmt.getLong(_columnIndexOfLastAccessed);
                long _tmpLastValidated = 0L;
                _tmpLastValidated = _stmt.getLong(_columnIndexOfLastValidated);
                String _tmpIntegrity = null;
                _tmpIntegrity = _stmt.isNull(_columnIndexOfIntegrity) ? null : _stmt.getText(_columnIndexOfIntegrity);
                String _tmpResponseHeaders = null;
                _tmpResponseHeaders = _stmt.getText(_columnIndexOfResponseHeaders);
                String _tmpStorageUri = null;
                _tmpStorageUri = _stmt.getText(_columnIndexOfStorageUri);
                long _tmpStorageSize = 0L;
                _tmpStorageSize = _stmt.getLong(_columnIndexOfStorageSize);
                long _tmpUncompressedSize = 0L;
                _tmpUncompressedSize = _stmt.getLong(_columnIndexOfUncompressedSize);
                _result = new CacheEntry(_tmpKey, _tmpUrl, _tmpMessage, _tmpStatusCode, _tmpCacheFlags, _tmpMethod, _tmpLastAccessed, _tmpLastValidated, _tmpIntegrity, _tmpResponseHeaders, _tmpStorageUri, _tmpStorageSize, _tmpUncompressedSize);
            } else {
                _result = null;
            }
            cacheEntry = _result;
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findByRequestBatchId$lambda$0(String $_sql, int $batchId, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)$batchId);
            int _columnIndexOfKey = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"key");
            int _columnIndexOfUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"url");
            int _columnIndexOfMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"message");
            int _columnIndexOfStatusCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"statusCode");
            int _columnIndexOfCacheFlags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cacheFlags");
            int _columnIndexOfMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"method");
            int _columnIndexOfLastAccessed = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastAccessed");
            int _columnIndexOfLastValidated = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastValidated");
            int _columnIndexOfIntegrity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"integrity");
            int _columnIndexOfResponseHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeaders");
            int _columnIndexOfStorageUri = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storageUri");
            int _columnIndexOfStorageSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storageSize");
            int _columnIndexOfUncompressedSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uncompressedSize");
            List _result = new ArrayList();
            while (_stmt.step()) {
                CacheEntry _item = null;
                String _tmpKey = null;
                _tmpKey = _stmt.getText(_columnIndexOfKey);
                String _tmpUrl = null;
                _tmpUrl = _stmt.getText(_columnIndexOfUrl);
                String _tmpMessage = null;
                _tmpMessage = _stmt.getText(_columnIndexOfMessage);
                int _tmpStatusCode = 0;
                _tmpStatusCode = (int)_stmt.getLong(_columnIndexOfStatusCode);
                int _tmpCacheFlags = 0;
                _tmpCacheFlags = (int)_stmt.getLong(_columnIndexOfCacheFlags);
                int _tmpMethod = 0;
                _tmpMethod = (int)_stmt.getLong(_columnIndexOfMethod);
                long _tmpLastAccessed = 0L;
                _tmpLastAccessed = _stmt.getLong(_columnIndexOfLastAccessed);
                long _tmpLastValidated = 0L;
                _tmpLastValidated = _stmt.getLong(_columnIndexOfLastValidated);
                String _tmpIntegrity = null;
                _tmpIntegrity = _stmt.isNull(_columnIndexOfIntegrity) ? null : _stmt.getText(_columnIndexOfIntegrity);
                String _tmpResponseHeaders = null;
                _tmpResponseHeaders = _stmt.getText(_columnIndexOfResponseHeaders);
                String _tmpStorageUri = null;
                _tmpStorageUri = _stmt.getText(_columnIndexOfStorageUri);
                long _tmpStorageSize = 0L;
                _tmpStorageSize = _stmt.getLong(_columnIndexOfStorageSize);
                long _tmpUncompressedSize = 0L;
                _tmpUncompressedSize = _stmt.getLong(_columnIndexOfUncompressedSize);
                _item = new CacheEntry(_tmpKey, _tmpUrl, _tmpMessage, _tmpStatusCode, _tmpCacheFlags, _tmpMethod, _tmpLastAccessed, _tmpLastValidated, _tmpIntegrity, _tmpResponseHeaders, _tmpStorageUri, _tmpStorageSize, _tmpUncompressedSize);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findEntriesWithLock$lambda$0(String $_sql, int $batchId, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)$batchId);
            List _result = new ArrayList();
            while (_stmt.step()) {
                String _item = null;
                _item = _stmt.getText(0);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List findEvictableEntries$lambda$0(String $_sql, int $batchSize, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)$batchSize);
            int _columnIndexOfKey = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"key");
            int _columnIndexOfUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"url");
            int _columnIndexOfMessage = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"message");
            int _columnIndexOfStatusCode = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"statusCode");
            int _columnIndexOfCacheFlags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"cacheFlags");
            int _columnIndexOfMethod = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"method");
            int _columnIndexOfLastAccessed = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastAccessed");
            int _columnIndexOfLastValidated = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastValidated");
            int _columnIndexOfIntegrity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"integrity");
            int _columnIndexOfResponseHeaders = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"responseHeaders");
            int _columnIndexOfStorageUri = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storageUri");
            int _columnIndexOfStorageSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storageSize");
            int _columnIndexOfUncompressedSize = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uncompressedSize");
            List _result = new ArrayList();
            while (_stmt.step()) {
                CacheEntry _item = null;
                String _tmpKey = null;
                _tmpKey = _stmt.getText(_columnIndexOfKey);
                String _tmpUrl = null;
                _tmpUrl = _stmt.getText(_columnIndexOfUrl);
                String _tmpMessage = null;
                _tmpMessage = _stmt.getText(_columnIndexOfMessage);
                int _tmpStatusCode = 0;
                _tmpStatusCode = (int)_stmt.getLong(_columnIndexOfStatusCode);
                int _tmpCacheFlags = 0;
                _tmpCacheFlags = (int)_stmt.getLong(_columnIndexOfCacheFlags);
                int _tmpMethod = 0;
                _tmpMethod = (int)_stmt.getLong(_columnIndexOfMethod);
                long _tmpLastAccessed = 0L;
                _tmpLastAccessed = _stmt.getLong(_columnIndexOfLastAccessed);
                long _tmpLastValidated = 0L;
                _tmpLastValidated = _stmt.getLong(_columnIndexOfLastValidated);
                String _tmpIntegrity = null;
                _tmpIntegrity = _stmt.isNull(_columnIndexOfIntegrity) ? null : _stmt.getText(_columnIndexOfIntegrity);
                String _tmpResponseHeaders = null;
                _tmpResponseHeaders = _stmt.getText(_columnIndexOfResponseHeaders);
                String _tmpStorageUri = null;
                _tmpStorageUri = _stmt.getText(_columnIndexOfStorageUri);
                long _tmpStorageSize = 0L;
                _tmpStorageSize = _stmt.getLong(_columnIndexOfStorageSize);
                long _tmpUncompressedSize = 0L;
                _tmpUncompressedSize = _stmt.getLong(_columnIndexOfUncompressedSize);
                _item = new CacheEntry(_tmpKey, _tmpUrl, _tmpMessage, _tmpStatusCode, _tmpCacheFlags, _tmpMethod, _tmpLastAccessed, _tmpLastValidated, _tmpIntegrity, _tmpResponseHeaders, _tmpStorageUri, _tmpStorageSize, _tmpUncompressedSize);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final long totalEvictableSize$lambda$0(String $_sql, SQLiteConnection _connection) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            long _result = 0L;
            if (_stmt.step()) {
                long _tmp = 0L;
                _result = _tmp = _stmt.getLong(0);
            } else {
                _result = 0L;
            }
        }
        return (long)var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getEntryUrlsInOrder$lambda$0(String $_sql, int $limit, int $offset, SQLiteConnection _connection) {
        List list;
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)$limit);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, (long)$offset);
            List _result = new ArrayList();
            while (_stmt.step()) {
                String _item = null;
                _item = _stmt.getText(0);
                _result.add(_item);
            }
            list = _result;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateLastAccessedTime$lambda$0(String $_sql, long $lastAccessTime, String $key, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, $lastAccessTime);
            _argIndex = 2;
            _stmt.bindText(_argIndex, $key);
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit updateValidation$lambda$0(String $_sql, String $headers, long $lastValidated, long $lastAccessed, String $key, SQLiteConnection _connection) {
        Intrinsics.checkNotNullParameter((Object)_connection, (String)"_connection");
        try (SQLiteStatement _stmt = _connection.prepare($_sql);){
            int _argIndex = 1;
            _stmt.bindText(_argIndex, $headers);
            _argIndex = 2;
            _stmt.bindLong(_argIndex, $lastValidated);
            _argIndex = 3;
            _stmt.bindLong(_argIndex, $lastAccessed);
            _argIndex = 4;
            _stmt.bindText(_argIndex, $key);
            _stmt.step();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/libcache/db/dao/CacheEntryDao_Impl$Companion;", "", "<init>", "()V", "getRequiredConverters", "", "Lkotlin/reflect/KClass;", "respect-lib-cache_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<KClass<?>> getRequiredConverters() {
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

