/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.draw;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.draw.InnerShadowScope;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.graphics.shadow.InnerShadowPainter;
import androidx.compose.ui.graphics.shadow.Shadow;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.node.ObserverModifierNode;
import androidx.compose.ui.node.ObserverModifierNodeKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpOffset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B(\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010@\u001a\u00020\tH\u0016J\b\u0010A\u001a\u00020\tH\u0016J\b\u0010B\u001a\u00020\tH\u0002J'\u0010C\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\nJ\f\u0010D\u001a\u00020\t*\u00020EH\u0016J\b\u0010F\u001a\u00020\u0012H\u0002J\b\u0010G\u001a\u00020\tH\u0016J\b\u0010H\u001a\u00020\tH\u0002J\u0013\u0010I\u001a\u00020\u00142\b\u0010J\u001a\u0004\u0018\u00010KH\u0096\u0002J\b\u0010L\u001a\u00020MH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R@\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n2\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR$\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0019@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010!R$\u0010\"\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0019@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001b\"\u0004\b$\u0010!R&\u0010&\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020%@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R&\u0010-\u001a\u00020,2\u0006\u0010\u0015\u001a\u00020,@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b.\u0010(\"\u0004\b/\u0010*R(\u00101\u001a\u0004\u0018\u0001002\b\u0010\u0015\u001a\u0004\u0018\u000100@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00106\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0019@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001b\"\u0004\b8\u0010!R&\u0010:\u001a\u0002092\u0006\u0010\u0015\u001a\u000209@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010?\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006N"}, d2={"Landroidx/compose/ui/draw/BlockInnerShadowNode;", "Landroidx/compose/ui/node/DrawModifierNode;", "Landroidx/compose/ui/Modifier$Node;", "Landroidx/compose/ui/node/ObserverModifierNode;", "Landroidx/compose/ui/draw/InnerShadowScope;", "shape", "Landroidx/compose/ui/graphics/Shape;", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Landroidx/compose/ui/graphics/Shape;Lkotlin/jvm/functions/Function1;)V", "densityObject", "Landroidx/compose/ui/unit/Density;", "targetShadow", "Landroidx/compose/ui/graphics/shadow/Shadow;", "shadowPainter", "Landroidx/compose/ui/graphics/shadow/InnerShadowPainter;", "blockRead", "", "value", "setBlock", "(Lkotlin/jvm/functions/Function1;)V", "density", "", "getDensity", "()F", "fontScale", "getFontScale", "radius", "getRadius", "setRadius", "(F)V", "spread", "getSpread", "setSpread", "Landroidx/compose/ui/geometry/Offset;", "offset", "getOffset-F1C5BW0", "()J", "setOffset-k-4lQ0M", "(J)V", "J", "Landroidx/compose/ui/graphics/Color;", "color", "getColor-0d7_KjU", "setColor-8_81llA", "Landroidx/compose/ui/graphics/Brush;", "brush", "getBrush", "()Landroidx/compose/ui/graphics/Brush;", "setBrush", "(Landroidx/compose/ui/graphics/Brush;)V", "alpha", "getAlpha", "setAlpha", "Landroidx/compose/ui/graphics/BlendMode;", "blendMode", "getBlendMode-0nO6VwU", "()I", "setBlendMode-s9anfk8", "(I)V", "I", "onAttach", "onDensityChange", "updateDensity", "update", "draw", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "obtainPainter", "onObservedReadsChanged", "invalidateShadow", "equals", "other", "", "hashCode", "", "ui"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nShadow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shadow.kt\nandroidx/compose/ui/draw/BlockInnerShadowNode\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 7 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,865:1\n635#2:866\n1#3:867\n65#4:868\n69#4:871\n60#5:869\n70#5:872\n53#5,3:874\n22#6:870\n188#7:873\n*S KotlinDebug\n*F\n+ 1 Shadow.kt\nandroidx/compose/ui/draw/BlockInnerShadowNode\n*L\n492#1:866\n565#1:868\n565#1:871\n565#1:869\n565#1:872\n565#1:874,3\n565#1:870\n565#1:873\n*E\n"})
public final class BlockInnerShadowNode
extends Modifier.Node
implements DrawModifierNode,
ObserverModifierNode,
InnerShadowScope {
    @NotNull
    private Shape shape;
    @Nullable
    private Density densityObject;
    @Nullable
    private Shadow targetShadow;
    @Nullable
    private InnerShadowPainter shadowPainter;
    private boolean blockRead;
    @NotNull
    private Function1<? super InnerShadowScope, Unit> block;
    private float radius;
    private float spread;
    private long offset;
    private long color;
    @Nullable
    private Brush brush;
    private float alpha;
    private int blendMode;
    public static final int $stable;

    public BlockInnerShadowNode(@NotNull Shape shape, @NotNull Function1<? super InnerShadowScope, Unit> block2) {
        Intrinsics.checkNotNullParameter(shape, "shape");
        Intrinsics.checkNotNullParameter(block2, "block");
        this.shape = shape;
        this.block = block2;
        this.offset = Offset.Companion.getZero-F1C5BW0();
        this.color = Color.Companion.getBlack-0d7_KjU();
        this.alpha = 1.0f;
        this.blendMode = BlendMode.Companion.getSrcOver-0nO6VwU();
    }

    private final void setBlock(Function1<? super InnerShadowScope, Unit> value) {
        if (this.block != value) {
            this.block = value;
            this.blockRead = false;
            DrawModifierNodeKt.invalidateDraw(this);
        }
    }

    @Override
    public float getDensity() {
        Density density = this.densityObject;
        return density != null ? density.getDensity() : 1.0f;
    }

    @Override
    public float getFontScale() {
        Density density = this.densityObject;
        return density != null ? density.getFontScale() : 1.0f;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(float value) {
        if (!(this.radius == value)) {
            this.radius = value;
            this.invalidateShadow();
        }
    }

    @Override
    public float getSpread() {
        return this.spread;
    }

    @Override
    public void setSpread(float value) {
        if (!(this.spread == value)) {
            this.spread = value;
            this.invalidateShadow();
        }
    }

    @Override
    public long getOffset-F1C5BW0() {
        return this.offset;
    }

    @Override
    public void setOffset-k-4lQ0M(long value) {
        if (!Offset.equals-impl0(this.offset, value)) {
            this.offset = value;
            this.invalidateShadow();
        }
    }

    @Override
    public long getColor-0d7_KjU() {
        return this.color;
    }

    @Override
    public void setColor-8_81llA(long value) {
        long target;
        long $this$isSpecified$iv = value;
        boolean bl = false;
        long l = target = $this$isSpecified$iv != 16L ? value : Color.Companion.getBlack-0d7_KjU();
        if (!Color.equals-impl0(this.color, target)) {
            this.color = target;
            this.invalidateShadow();
        }
    }

    @Override
    @Nullable
    public Brush getBrush() {
        return this.brush;
    }

    @Override
    public void setBrush(@Nullable Brush value) {
        if (!Intrinsics.areEqual(this.brush, value)) {
            this.brush = value;
            this.invalidateShadow();
        }
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float value) {
        if (!(this.alpha == value)) {
            this.alpha = value;
            this.invalidateShadow();
        }
    }

    @Override
    public int getBlendMode-0nO6VwU() {
        return this.blendMode;
    }

    @Override
    public void setBlendMode-s9anfk8(int value) {
        if (!BlendMode.equals-impl0(this.blendMode, value)) {
            this.blendMode = value;
            this.invalidateShadow();
        }
    }

    @Override
    public void onAttach() {
        super.onAttach();
        this.updateDensity();
    }

    @Override
    public void onDensityChange() {
        if (this.isAttached()) {
            this.updateDensity();
        }
    }

    private final void updateDensity() {
        Density newDensity = DelegatableNodeKt.requireDensity(this);
        if (!Intrinsics.areEqual(this.densityObject, newDensity)) {
            this.densityObject = newDensity;
            this.block.invoke(this);
            this.invalidateShadow();
        }
    }

    public final void update(@NotNull Shape shape, @NotNull Function1<? super InnerShadowScope, Unit> block2) {
        Intrinsics.checkNotNullParameter(shape, "shape");
        Intrinsics.checkNotNullParameter(block2, "block");
        this.shape = shape;
        this.setBlock(block2);
    }

    @Override
    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter($this$draw, "<this>");
        InnerShadowPainter $this$draw_u24lambda_u240 = this.obtainPainter();
        boolean bl = false;
        Painter.draw-x_KDEd0$default($this$draw_u24lambda_u240, $this$draw, $this$draw.getSize-NH-jbRc(), 0.0f, null, 6, null);
        $this$draw.drawContent();
    }

    /*
     * WARNING - void declaration
     */
    private final InnerShadowPainter obtainPainter() {
        void val1$iv$iv;
        void x$iv;
        if (!this.blockRead) {
            this.blockRead = true;
            ObserverModifierNodeKt.observeReads((Modifier.Node)this, () -> BlockInnerShadowNode.obtainPainter$lambda$1(this));
        }
        Shadow shadow = this.targetShadow;
        Object painter = this.shadowPainter;
        Brush tmpBrush = this.getBrush();
        float radiusDp = this.toDp-u2uoSUM(this.getRadius());
        float spreadDp = this.toDp-u2uoSUM(this.getSpread());
        long arg0$iv22 = this.getOffset-F1C5BW0();
        boolean bl = false;
        long value$iv$iv = arg0$iv22;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float arg0$iv22 = this.toDp-u2uoSUM(Float.intBitsToFloat(bits$iv$iv$iv));
        long arg0$iv = this.getOffset-F1C5BW0();
        boolean $i$f$getY-impl22 = false;
        long value$iv$iv2 = arg0$iv;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float y$iv = this.toDp-u2uoSUM(Float.intBitsToFloat(bits$iv$iv$iv2));
        boolean bl2 = false;
        void $i$f$getY-impl22 = x$iv;
        float val2$iv$iv = y$iv;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv);
        long v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
        long dpOffset = DpOffset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
        if (!(painter != null && shadow != null && Dp.equals-impl0(shadow.getRadius-D9Ej5fM(), radiusDp) && Dp.equals-impl0(shadow.getSpread-D9Ej5fM(), spreadDp) && Color.equals-impl0(shadow.getColor-0d7_KjU(), this.getColor-0d7_KjU()) && Intrinsics.areEqual(shadow.getBrush(), tmpBrush) && shadow.getAlpha() == this.getAlpha() && BlendMode.equals-impl0(shadow.getBlendMode-0nO6VwU(), this.getBlendMode-0nO6VwU()) && DpOffset.equals-impl0(shadow.getOffset-RKDOV3M(), dpOffset))) {
            Object object;
            Object it = object = tmpBrush != null ? new Shadow(radiusDp, tmpBrush, spreadDp, dpOffset, this.getAlpha(), this.getBlendMode-0nO6VwU(), null) : new Shadow(radiusDp, this.getColor-0d7_KjU(), spreadDp, dpOffset, this.getAlpha(), this.getBlendMode-0nO6VwU(), null);
            boolean bl3 = false;
            this.targetShadow = it;
            shadow = object;
            it = object = DelegatableNodeKt.requireGraphicsContext(this).getShadowContext().createInnerShadowPainter(this.shape, shadow);
            boolean bl4 = false;
            this.shadowPainter = it;
            painter = object;
        }
        return painter;
    }

    @Override
    public void onObservedReadsChanged() {
        this.invalidateShadow();
        this.blockRead = false;
    }

    private final void invalidateShadow() {
        this.targetShadow = null;
        this.shadowPainter = null;
        DrawModifierNodeKt.invalidateDraw(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof BlockInnerShadowNode)) {
            return false;
        }
        if (!(this.getAlpha() == ((BlockInnerShadowNode)other).getAlpha())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.shape, ((BlockInnerShadowNode)other).shape)) {
            return false;
        }
        if (this.block != ((BlockInnerShadowNode)other).block) {
            return false;
        }
        if (!(this.getRadius() == ((BlockInnerShadowNode)other).getRadius())) {
            return false;
        }
        if (!(this.getSpread() == ((BlockInnerShadowNode)other).getSpread())) {
            return false;
        }
        if (!Offset.equals-impl0(this.getOffset-F1C5BW0(), ((BlockInnerShadowNode)other).getOffset-F1C5BW0())) {
            return false;
        }
        if (!Color.equals-impl0(this.getColor-0d7_KjU(), ((BlockInnerShadowNode)other).getColor-0d7_KjU())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getBrush(), ((BlockInnerShadowNode)other).getBrush())) {
            return false;
        }
        return BlendMode.equals-impl0(this.getBlendMode-0nO6VwU(), ((BlockInnerShadowNode)other).getBlendMode-0nO6VwU());
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.getAlpha());
        result2 = 31 * result2 + this.shape.hashCode();
        result2 = 31 * result2 + this.block.hashCode();
        result2 = 31 * result2 + Float.hashCode(this.getRadius());
        result2 = 31 * result2 + Float.hashCode(this.getSpread());
        result2 = 31 * result2 + Offset.hashCode-impl(this.getOffset-F1C5BW0());
        result2 = 31 * result2 + Color.hashCode-impl(this.getColor-0d7_KjU());
        Brush brush = this.getBrush();
        result2 = 31 * result2 + (brush != null ? brush.hashCode() : 0);
        result2 = 31 * result2 + BlendMode.hashCode-impl(this.getBlendMode-0nO6VwU());
        return result2;
    }

    private static final Unit obtainPainter$lambda$1(BlockInnerShadowNode this$0) {
        this$0.block.invoke(this$0);
        return Unit.INSTANCE;
    }
}

