/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation;

import androidx.compose.foundation.OverscrollEffect;
import androidx.compose.foundation.OverscrollFactory;
import androidx.compose.foundation.OverscrollKt;
import androidx.compose.foundation.gestures.BringIntoViewSpec;
import androidx.compose.foundation.gestures.FlingBehavior;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollableDefaults;
import androidx.compose.foundation.gestures.ScrollableNode;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.interaction.MutableInteractionSource;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNode;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNodeKt;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DelegatingNode;
import androidx.compose.ui.node.ObserverModifierNode;
import androidx.compose.ui.node.ObserverModifierNodeKt;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BW\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\t\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\b\u0010!\u001a\u0004\u0018\u00010\u0013J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020#H\u0016JV\u0010&\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0006\u0010 \u001a\u00020\tJ\b\u0010(\u001a\u00020#H\u0002J\b\u0010)\u001a\u00020#H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/compose/foundation/ScrollingContainerNode;", "Landroidx/compose/ui/node/DelegatingNode;", "Landroidx/compose/ui/node/CompositionLocalConsumerModifierNode;", "Landroidx/compose/ui/node/ObserverModifierNode;", "state", "Landroidx/compose/foundation/gestures/ScrollableState;", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "enabled", "", "reverseScrolling", "flingBehavior", "Landroidx/compose/foundation/gestures/FlingBehavior;", "interactionSource", "Landroidx/compose/foundation/interaction/MutableInteractionSource;", "bringIntoViewSpec", "Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "useLocalOverscrollFactory", "userProvidedOverscrollEffect", "Landroidx/compose/foundation/OverscrollEffect;", "<init>", "(Landroidx/compose/foundation/gestures/ScrollableState;Landroidx/compose/foundation/gestures/Orientation;ZZLandroidx/compose/foundation/gestures/FlingBehavior;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/gestures/BringIntoViewSpec;ZLandroidx/compose/foundation/OverscrollEffect;)V", "shouldAutoInvalidate", "getShouldAutoInvalidate", "()Z", "scrollableNode", "Landroidx/compose/foundation/gestures/ScrollableNode;", "overscrollNode", "Landroidx/compose/ui/node/DelegatableNode;", "localOverscrollFactory", "Landroidx/compose/foundation/OverscrollFactory;", "localOverscrollFactoryCreatedOverscrollEffect", "shouldReverseDirection", "getOverscrollEffect", "onAttach", "", "onDetach", "onLayoutDirectionChange", "update", "overscrollEffect", "attachOverscrollNodeIfNeeded", "onObservedReadsChanged", "foundation"})
@SourceDebugExtension(value={"SMAP\nScrollingContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollingContainer.kt\nandroidx/compose/foundation/ScrollingContainerNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
final class ScrollingContainerNode
extends DelegatingNode
implements CompositionLocalConsumerModifierNode,
ObserverModifierNode {
    @NotNull
    private ScrollableState state;
    @NotNull
    private Orientation orientation;
    private boolean enabled;
    private boolean reverseScrolling;
    @Nullable
    private FlingBehavior flingBehavior;
    @Nullable
    private MutableInteractionSource interactionSource;
    @Nullable
    private BringIntoViewSpec bringIntoViewSpec;
    private boolean useLocalOverscrollFactory;
    @Nullable
    private OverscrollEffect userProvidedOverscrollEffect;
    private final boolean shouldAutoInvalidate;
    @Nullable
    private ScrollableNode scrollableNode;
    @Nullable
    private DelegatableNode overscrollNode;
    @Nullable
    private OverscrollFactory localOverscrollFactory;
    @Nullable
    private OverscrollEffect localOverscrollFactoryCreatedOverscrollEffect;
    private boolean shouldReverseDirection;

    public ScrollingContainerNode(@NotNull ScrollableState state2, @NotNull Orientation orientation, boolean enabled, boolean reverseScrolling, @Nullable FlingBehavior flingBehavior, @Nullable MutableInteractionSource interactionSource, @Nullable BringIntoViewSpec bringIntoViewSpec, boolean useLocalOverscrollFactory, @Nullable OverscrollEffect userProvidedOverscrollEffect) {
        Intrinsics.checkNotNullParameter(state2, "state");
        Intrinsics.checkNotNullParameter((Object)orientation, "orientation");
        this.state = state2;
        this.orientation = orientation;
        this.enabled = enabled;
        this.reverseScrolling = reverseScrolling;
        this.flingBehavior = flingBehavior;
        this.interactionSource = interactionSource;
        this.bringIntoViewSpec = bringIntoViewSpec;
        this.useLocalOverscrollFactory = useLocalOverscrollFactory;
        this.userProvidedOverscrollEffect = userProvidedOverscrollEffect;
    }

    @Override
    public boolean getShouldAutoInvalidate() {
        return this.shouldAutoInvalidate;
    }

    @Nullable
    public final OverscrollEffect getOverscrollEffect() {
        return this.useLocalOverscrollFactory ? this.localOverscrollFactoryCreatedOverscrollEffect : this.userProvidedOverscrollEffect;
    }

    @Override
    public void onAttach() {
        this.shouldReverseDirection = this.shouldReverseDirection();
        this.attachOverscrollNodeIfNeeded();
        if (this.scrollableNode == null) {
            this.scrollableNode = (ScrollableNode)this.delegate((DelegatableNode)new ScrollableNode(this.state, this.getOverscrollEffect(), this.flingBehavior, this.orientation, this.enabled, this.shouldReverseDirection, this.interactionSource, this.bringIntoViewSpec));
        }
    }

    @Override
    public void onDetach() {
        block0: {
            DelegatableNode delegatableNode = this.overscrollNode;
            if (delegatableNode == null) break block0;
            DelegatableNode it = delegatableNode;
            boolean bl = false;
            this.undelegate(it);
        }
    }

    @Override
    public void onLayoutDirectionChange() {
        boolean reverseDirection = this.shouldReverseDirection();
        if (this.shouldReverseDirection != reverseDirection) {
            this.shouldReverseDirection = reverseDirection;
            this.update(this.state, this.orientation, this.useLocalOverscrollFactory, this.getOverscrollEffect(), this.enabled, this.reverseScrolling, this.flingBehavior, this.interactionSource, this.bringIntoViewSpec);
        }
    }

    public final void update(@NotNull ScrollableState state2, @NotNull Orientation orientation, boolean useLocalOverscrollFactory, @Nullable OverscrollEffect overscrollEffect, boolean enabled, boolean reverseScrolling, @Nullable FlingBehavior flingBehavior, @Nullable MutableInteractionSource interactionSource, @Nullable BringIntoViewSpec bringIntoViewSpec) {
        block4: {
            Intrinsics.checkNotNullParameter(state2, "state");
            Intrinsics.checkNotNullParameter((Object)orientation, "orientation");
            this.state = state2;
            this.orientation = orientation;
            boolean useLocalOverscrollFactoryChanged = false;
            if (this.useLocalOverscrollFactory != useLocalOverscrollFactory) {
                useLocalOverscrollFactoryChanged = true;
                this.useLocalOverscrollFactory = useLocalOverscrollFactory;
            }
            boolean overscrollEffectChanged = false;
            if (!Intrinsics.areEqual(this.userProvidedOverscrollEffect, overscrollEffect)) {
                overscrollEffectChanged = true;
                this.userProvidedOverscrollEffect = overscrollEffect;
            }
            if (useLocalOverscrollFactoryChanged || overscrollEffectChanged && !useLocalOverscrollFactory) {
                DelegatableNode delegatableNode = this.overscrollNode;
                if (delegatableNode != null) {
                    DelegatableNode it = delegatableNode;
                    boolean bl = false;
                    this.undelegate(it);
                }
                this.overscrollNode = null;
                this.attachOverscrollNodeIfNeeded();
            }
            this.enabled = enabled;
            this.reverseScrolling = reverseScrolling;
            this.flingBehavior = flingBehavior;
            this.interactionSource = interactionSource;
            this.bringIntoViewSpec = bringIntoViewSpec;
            this.shouldReverseDirection = this.shouldReverseDirection();
            ScrollableNode scrollableNode = this.scrollableNode;
            if (scrollableNode == null) break block4;
            scrollableNode.update(state2, orientation, this.getOverscrollEffect(), enabled, this.shouldReverseDirection, flingBehavior, interactionSource, bringIntoViewSpec);
        }
    }

    public final boolean shouldReverseDirection() {
        LayoutDirection layoutDirection = LayoutDirection.Ltr;
        if (this.isAttached()) {
            layoutDirection = DelegatableNodeKt.requireLayoutDirection(this);
        }
        return ScrollableDefaults.INSTANCE.reverseDirection(layoutDirection, this.orientation, this.reverseScrolling);
    }

    private final void attachOverscrollNodeIfNeeded() {
        block3: {
            block2: {
                DelegatableNode node2;
                OverscrollEffect effect;
                if (this.overscrollNode != null) break block2;
                if (this.useLocalOverscrollFactory) {
                    ObserverModifierNodeKt.observeReads((Modifier.Node)this, () -> ScrollingContainerNode.attachOverscrollNodeIfNeeded$lambda$2(this));
                }
                if ((effect = this.getOverscrollEffect()) == null || (node2 = effect.getNode()).getNode().isAttached()) break block3;
                this.overscrollNode = this.delegate(node2);
                break block3;
            }
            DelegatableNode delegatableNode = this.overscrollNode;
            if (delegatableNode == null) break block3;
            DelegatableNode it = delegatableNode;
            boolean bl = false;
            if (!it.getNode().isAttached()) {
                this.delegate(it);
            }
        }
    }

    @Override
    public void onObservedReadsChanged() {
        block2: {
            OverscrollFactory factory2 = (OverscrollFactory)CompositionLocalConsumerModifierNodeKt.currentValueOf(this, OverscrollKt.getLocalOverscrollFactory());
            if (Intrinsics.areEqual(factory2, this.localOverscrollFactory)) break block2;
            this.localOverscrollFactory = factory2;
            this.localOverscrollFactoryCreatedOverscrollEffect = null;
            DelegatableNode delegatableNode = this.overscrollNode;
            if (delegatableNode != null) {
                DelegatableNode it = delegatableNode;
                boolean bl = false;
                this.undelegate(it);
            }
            this.overscrollNode = null;
            this.attachOverscrollNodeIfNeeded();
            ScrollableNode scrollableNode = this.scrollableNode;
            if (scrollableNode != null) {
                scrollableNode.update(this.state, this.orientation, this.getOverscrollEffect(), this.enabled, this.shouldReverseDirection, this.flingBehavior, this.interactionSource, this.bringIntoViewSpec);
            }
        }
    }

    private static final Unit attachOverscrollNodeIfNeeded$lambda$2(ScrollingContainerNode this$0) {
        OverscrollFactory overscrollFactory = this$0.localOverscrollFactory = (OverscrollFactory)CompositionLocalConsumerModifierNodeKt.currentValueOf(this$0, OverscrollKt.getLocalOverscrollFactory());
        this$0.localOverscrollFactoryCreatedOverscrollEffect = overscrollFactory != null ? overscrollFactory.createOverscrollEffect() : null;
        return Unit.INSTANCE;
    }
}

