/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.LazyGridSnapLayoutInfoProviderKt;
import androidx.compose.foundation.lazy.grid.LazyGridItemInfo;
import androidx.compose.foundation.lazy.grid.LazyGridLayoutInfo;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchScope;
import androidx.compose.foundation.lazy.grid.LazyGridPrefetchStrategy;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.lazy.layout.NestedPrefetchScope;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.collection.MutableVector;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0014\u001a\u00020\r*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy;", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchStrategy;", "nestedPrefetchItemCount", "", "<init>", "(I)V", "lineToPrefetch", "currentLinePrefetchHandles", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "wasScrollingForward", "", "onScroll", "", "Landroidx/compose/foundation/lazy/grid/LazyGridPrefetchScope;", "delta", "", "layoutInfo", "Landroidx/compose/foundation/lazy/grid/LazyGridLayoutInfo;", "onVisibleItemsUpdated", "onNestedPrefetch", "Landroidx/compose/foundation/lazy/layout/NestedPrefetchScope;", "firstVisibleItemIndex", "foundation"})
@Stable
@SourceDebugExtension(value={"SMAP\nLazyGridPrefetchStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridPrefetchStrategy.kt\nandroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1101#2:231\n1083#2,2:232\n424#3,8:234\n136#3:242\n424#3,8:243\n424#3,8:251\n424#3,8:259\n1#4:267\n*S KotlinDebug\n*F\n+ 1 LazyGridPrefetchStrategy.kt\nandroidx/compose/foundation/lazy/grid/DefaultLazyGridPrefetchStrategy\n*L\n134#1:231\n134#1:232,2\n174#1:234,8\n179#1:242\n190#1:243,8\n199#1:251,8\n220#1:259,8\n*E\n"})
final class DefaultLazyGridPrefetchStrategy
implements LazyGridPrefetchStrategy {
    private final int nestedPrefetchItemCount;
    private int lineToPrefetch;
    @NotNull
    private final MutableVector<LazyLayoutPrefetchState.PrefetchHandle> currentLinePrefetchHandles;
    private boolean wasScrollingForward;

    public DefaultLazyGridPrefetchStrategy(int nestedPrefetchItemCount) {
        this.nestedPrefetchItemCount = nestedPrefetchItemCount;
        this.lineToPrefetch = -1;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.currentLinePrefetchHandles = new MutableVector<LazyLayoutPrefetchState.PrefetchHandle>(new LazyLayoutPrefetchState.PrefetchHandle[capacity$iv$iv], 0);
    }

    public /* synthetic */ DefaultLazyGridPrefetchStrategy(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    @Override
    public void onScroll(@NotNull LazyGridPrefetchScope $this$onScroll, float delta, @NotNull LazyGridLayoutInfo layoutInfo) {
        block8: {
            block9: {
                int n;
                LazyGridItemInfo it;
                int n2;
                Intrinsics.checkNotNullParameter($this$onScroll, "<this>");
                Intrinsics.checkNotNullParameter(layoutInfo, "layoutInfo");
                if (!(!((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty())) break block8;
                boolean scrollingForward = delta < 0.0f;
                int lineToPrefetch = 0;
                int closestNextItemToPrefetch = 0;
                if (scrollingForward) {
                    LazyGridItemInfo lazyGridItemInfo = CollectionsKt.last(layoutInfo.getVisibleItemsInfo());
                    n2 = 1;
                    boolean bl = false;
                    n = layoutInfo.getOrientation() == Orientation.Vertical ? it.getRow() : it.getColumn();
                    lineToPrefetch = n2 + n;
                    closestNextItemToPrefetch = CollectionsKt.last(layoutInfo.getVisibleItemsInfo()).getIndex() + 1;
                } else {
                    it = CollectionsKt.first(layoutInfo.getVisibleItemsInfo());
                    n2 = -1;
                    boolean bl = false;
                    n = layoutInfo.getOrientation() == Orientation.Vertical ? it.getRow() : it.getColumn();
                    lineToPrefetch = n2 + n;
                    closestNextItemToPrefetch = CollectionsKt.first(layoutInfo.getVisibleItemsInfo()).getIndex() - 1;
                }
                boolean bl = 0 <= closestNextItemToPrefetch ? closestNextItemToPrefetch < layoutInfo.getTotalItemsCount() : false;
                if (!bl) break block8;
                if (lineToPrefetch != this.lineToPrefetch && lineToPrefetch >= 0) {
                    MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv;
                    if (this.wasScrollingForward != scrollingForward) {
                        this_$iv = this.currentLinePrefetchHandles;
                        boolean $i$f$forEach = false;
                        T[] content$iv = this_$iv.content;
                        int size$iv = this_$iv.getSize();
                        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                            LazyLayoutPrefetchState.PrefetchHandle it2 = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                            boolean bl2 = false;
                            it2.cancel();
                        }
                    }
                    this.wasScrollingForward = scrollingForward;
                    this.lineToPrefetch = lineToPrefetch;
                    this.currentLinePrefetchHandles.clear();
                    this_$iv = this.currentLinePrefetchHandles;
                    List<LazyLayoutPrefetchState.PrefetchHandle> elements$iv = $this$onScroll.scheduleLinePrefetch(lineToPrefetch);
                    boolean $i$f$addAll = false;
                    this_$iv.addAll(this_$iv.getSize(), elements$iv);
                }
                if (!scrollingForward) break block9;
                LazyGridItemInfo lastItem = CollectionsKt.last(layoutInfo.getVisibleItemsInfo());
                int itemSize = LazyGridSnapLayoutInfoProviderKt.sizeOnMainAxis(lastItem, layoutInfo.getOrientation());
                int itemSpacing = layoutInfo.getMainAxisItemSpacing();
                int distanceToPrefetchItem = LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(lastItem, layoutInfo.getOrientation()) + itemSize + itemSpacing - layoutInfo.getViewportEndOffset();
                if (!((float)distanceToPrefetchItem < -delta)) break block8;
                MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
                boolean $i$f$forEach = false;
                T[] content$iv = this_$iv.content;
                int size$iv = this_$iv.getSize();
                for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                    LazyLayoutPrefetchState.PrefetchHandle it3 = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                    boolean bl3 = false;
                    it3.markAsUrgent();
                }
                break block8;
            }
            LazyGridItemInfo firstItem = CollectionsKt.first(layoutInfo.getVisibleItemsInfo());
            int distanceToPrefetchItem = layoutInfo.getViewportStartOffset() - LazyGridSnapLayoutInfoProviderKt.offsetOnMainAxis(firstItem, layoutInfo.getOrientation());
            if ((float)distanceToPrefetchItem < delta) {
                MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
                boolean $i$f$forEach = false;
                T[] content$iv = this_$iv.content;
                int size$iv = this_$iv.getSize();
                for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                    LazyLayoutPrefetchState.PrefetchHandle it = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                    boolean bl = false;
                    it.markAsUrgent();
                }
            }
        }
    }

    @Override
    public void onVisibleItemsUpdated(@NotNull LazyGridPrefetchScope $this$onVisibleItemsUpdated, @NotNull LazyGridLayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter($this$onVisibleItemsUpdated, "<this>");
        Intrinsics.checkNotNullParameter(layoutInfo, "layoutInfo");
        if (this.lineToPrefetch != -1 && !((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty()) {
            int expectedLineToPrefetch;
            int n;
            LazyGridItemInfo it;
            if (this.wasScrollingForward) {
                it = CollectionsKt.last(layoutInfo.getVisibleItemsInfo());
                boolean bl = false;
                n = (layoutInfo.getOrientation() == Orientation.Vertical ? it.getRow() : it.getColumn()) + 1;
            } else {
                it = CollectionsKt.first(layoutInfo.getVisibleItemsInfo());
                boolean bl = false;
                n = expectedLineToPrefetch = (layoutInfo.getOrientation() == Orientation.Vertical ? it.getRow() : it.getColumn()) - 1;
            }
            if (this.lineToPrefetch != expectedLineToPrefetch) {
                this.lineToPrefetch = -1;
                MutableVector<LazyLayoutPrefetchState.PrefetchHandle> this_$iv = this.currentLinePrefetchHandles;
                boolean $i$f$forEach = false;
                T[] content$iv = this_$iv.content;
                int size$iv = this_$iv.getSize();
                for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                    LazyLayoutPrefetchState.PrefetchHandle it2 = (LazyLayoutPrefetchState.PrefetchHandle)content$iv[i$iv];
                    boolean bl = false;
                    it2.cancel();
                }
                this.currentLinePrefetchHandles.clear();
            }
        }
    }

    @Override
    public void onNestedPrefetch(@NotNull NestedPrefetchScope $this$onNestedPrefetch, int firstVisibleItemIndex) {
        Intrinsics.checkNotNullParameter($this$onNestedPrefetch, "<this>");
        int n = this.nestedPrefetchItemCount;
        int n2 = 0;
        while (n2 < n) {
            int i2 = n2++;
            boolean bl = false;
            $this$onNestedPrefetch.schedulePrefetch(firstVisibleItemIndex + i2);
        }
    }

    public DefaultLazyGridPrefetchStrategy() {
        this(0, 1, null);
    }
}

