/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.StringHelpers_jvmKt;
import androidx.compose.foundation.text.input.TextFieldCharSequence;
import androidx.compose.foundation.text.input.internal.CodepointHelpers_jvmKt;
import androidx.compose.foundation.text.input.internal.CodepointTransformation;
import androidx.compose.foundation.text.input.internal.MaskCodepointTransformation;
import androidx.compose.foundation.text.input.internal.OffsetMappingCalculator;
import androidx.compose.runtime.Stable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0001\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"mask", "Landroidx/compose/foundation/text/input/internal/CodepointTransformation;", "Landroidx/compose/foundation/text/input/internal/CodepointTransformation$Companion;", "character", "", "toVisualText", "", "Landroidx/compose/foundation/text/input/TextFieldCharSequence;", "codepointTransformation", "offsetMappingCalculator", "Landroidx/compose/foundation/text/input/internal/OffsetMappingCalculator;", "foundation"})
public final class CodepointTransformationKt {
    @Stable
    @NotNull
    public static final CodepointTransformation mask(@NotNull CodepointTransformation.Companion $this$mask, char character) {
        Intrinsics.checkNotNullParameter($this$mask, "<this>");
        return new MaskCodepointTransformation(character);
    }

    @NotNull
    public static final CharSequence toVisualText(@NotNull TextFieldCharSequence $this$toVisualText, @NotNull CodepointTransformation codepointTransformation, @NotNull OffsetMappingCalculator offsetMappingCalculator) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$toVisualText, "<this>");
        Intrinsics.checkNotNullParameter(codepointTransformation, "codepointTransformation");
        Intrinsics.checkNotNullParameter(offsetMappingCalculator, "offsetMappingCalculator");
        TextFieldCharSequence text = $this$toVisualText;
        boolean changed = false;
        StringBuilder $this$toVisualText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int charOffset = 0;
        int codePointOffset = 0;
        while (charOffset < text.length()) {
            int codePoint = CodepointHelpers_jvmKt.codePointAt(text, charOffset);
            int newCodePoint = codepointTransformation.transform(codePointOffset, codePoint);
            int charCount = CodepointHelpers_jvmKt.charCount(codePoint);
            if (newCodePoint != codePoint) {
                changed = true;
                int newCharCount = CodepointHelpers_jvmKt.charCount(newCodePoint);
                offsetMappingCalculator.recordEditOperation($this$toVisualText_u24lambda_u240.length(), $this$toVisualText_u24lambda_u240.length() + charCount, newCharCount);
            }
            StringHelpers_jvmKt.appendCodePointX($this$toVisualText_u24lambda_u240, newCodePoint);
            charOffset += charCount;
            ++codePointOffset;
        }
        String newText = stringBuilder.toString();
        return changed ? (CharSequence)newText : (CharSequence)$this$toVisualText;
    }
}

