/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.collection.MutableIntObjectMap;
import androidx.compose.ui.graphics.colorspace.Adaptation;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.Connector;
import androidx.compose.ui.graphics.colorspace.ConnectorKt;
import androidx.compose.ui.graphics.colorspace.RenderIntent;
import androidx.compose.ui.graphics.colorspace.Rgb;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u000b\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a%\u0010\t\u001a\u00020\u0001*\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\b\u001a\u001e\u0010\u000b\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u001a8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0000\u001a8\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0000\u001aH\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0000\u001aH\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0000\u001a8\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0000\u001a8\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0000\u001a\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u001f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001fH\u0000\u001a\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0000\u001a\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020 H\u0000\u001a\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0000\u001a\u0018\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 H\u0000\u001a\u0018\u0010&\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 H\u0000\u001a)\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020 2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020(H\u0080\b\u001a)\u0010,\u001a\u00020(2\u0006\u0010$\u001a\u00020 2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020(H\u0080\b\u001a)\u0010-\u001a\u00020(2\u0006\u0010$\u001a\u00020 2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020(H\u0080\b\u001a\u0018\u0010.\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 H\u0000\u001a \u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020 2\u0006\u00102\u001a\u00020 H\u0000\u00a8\u00063"}, d2={"createConnector", "Landroidx/compose/ui/graphics/colorspace/Connector;", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "createConnector-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I)Landroidx/compose/ui/graphics/colorspace/Connector;", "connect", "connect-YBCOT_4", "adapt", "whitePoint", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "adaptation", "Landroidx/compose/ui/graphics/colorspace/Adaptation;", "rcpResponse", "", "x", "a", "b", "c", "d", "g", "response", "e", "f", "absRcpResponse", "absResponse", "compare", "", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "", "inverse3x3", "m", "mul3x3", "lhs", "rhs", "mul3x3Float3", "mul3x3Float3_0", "", "r0", "r1", "r2", "mul3x3Float3_1", "mul3x3Float3_2", "mul3x3Diag", "chromaticAdaptation", "matrix", "srcWhitePoint", "dstWhitePoint", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nColorSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpaceKt\n+ 2 Connector.kt\nandroidx/compose/ui/graphics/colorspace/ConnectorKt\n+ 3 IntObjectMap.kt\nandroidx/collection/MutableIntObjectMap\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,717:1\n326#2:718\n679#3:719\n1#4:720\n*S KotlinDebug\n*F\n+ 1 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpaceKt\n*L\n401#1:718\n401#1:719\n401#1:720\n*E\n"})
public final class ColorSpaceKt {
    private static final Connector createConnector-YBCOT_4(ColorSpace source2, ColorSpace destination, int intent) {
        Connector connector;
        if (source2 == destination) {
            connector = Connector.Companion.identity$ui_graphics(source2);
        } else if (ColorModel.equals-impl0(source2.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) && ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw())) {
            Intrinsics.checkNotNull(source2, "null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
            Rgb rgb = (Rgb)source2;
            Intrinsics.checkNotNull(destination, "null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
            connector = new Connector.RgbConnector(rgb, (Rgb)destination, intent, null);
        } else {
            connector = new Connector(source2, destination, intent, null);
        }
        return connector;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Connector connect-YBCOT_4(@NotNull ColorSpace $this$connect_u2dYBCOT_4, @NotNull ColorSpace destination, int intent) {
        Connector connector;
        Intrinsics.checkNotNullParameter($this$connect_u2dYBCOT_4, "$this$connect");
        Intrinsics.checkNotNullParameter(destination, "destination");
        int srcId = $this$connect_u2dYBCOT_4.getId$ui_graphics();
        int dstId = destination.getId$ui_graphics();
        if ((srcId | dstId) < 0) {
            connector = ColorSpaceKt.createConnector-YBCOT_4($this$connect_u2dYBCOT_4, destination, intent);
        } else {
            void key$iv;
            void this_$iv;
            MutableIntObjectMap<Connector> mutableIntObjectMap = ConnectorKt.getConnectors();
            int n = 0;
            n = srcId | dstId << 6 | intent << 12;
            boolean $i$f$getOrPut = false;
            Object object = this_$iv.get((int)key$iv);
            if (object == null) {
                Connector connector2;
                boolean bl = false;
                Connector it$iv = connector2 = ColorSpaceKt.createConnector-YBCOT_4($this$connect_u2dYBCOT_4, destination, intent);
                boolean bl2 = false;
                this_$iv.set((int)key$iv, it$iv);
                object = connector2;
            }
            connector = (Connector)object;
        }
        return connector;
    }

    public static /* synthetic */ Connector connect-YBCOT_4$default(ColorSpace colorSpace, ColorSpace colorSpace2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            colorSpace2 = ColorSpaces.INSTANCE.getSrgb();
        }
        if ((n2 & 2) != 0) {
            n = RenderIntent.Companion.getPerceptual-uksYyKA();
        }
        return ColorSpaceKt.connect-YBCOT_4(colorSpace, colorSpace2, n);
    }

    @JvmOverloads
    @NotNull
    public static final ColorSpace adapt(@NotNull ColorSpace $this$adapt, @NotNull WhitePoint whitePoint, @NotNull Adaptation adaptation) {
        Intrinsics.checkNotNullParameter($this$adapt, "<this>");
        Intrinsics.checkNotNullParameter(whitePoint, "whitePoint");
        Intrinsics.checkNotNullParameter(adaptation, "adaptation");
        if (ColorModel.equals-impl0($this$adapt.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw())) {
            Rgb rgb = (Rgb)$this$adapt;
            if (ColorSpaceKt.compare(rgb.getWhitePoint(), whitePoint)) {
                return $this$adapt;
            }
            float[] xyz = whitePoint.toXyz$ui_graphics();
            float[] adaptationTransform = ColorSpaceKt.chromaticAdaptation(adaptation.getTransform$ui_graphics(), rgb.getWhitePoint().toXyz$ui_graphics(), xyz);
            float[] transform2 = ColorSpaceKt.mul3x3(adaptationTransform, rgb.getTransform$ui_graphics());
            return new Rgb(rgb, transform2, whitePoint);
        }
        return $this$adapt;
    }

    public static /* synthetic */ ColorSpace adapt$default(ColorSpace colorSpace, WhitePoint whitePoint, Adaptation adaptation, int n, Object object) {
        if ((n & 2) != 0) {
            adaptation = Adaptation.Companion.getBradford();
        }
        return ColorSpaceKt.adapt(colorSpace, whitePoint, adaptation);
    }

    public static final double rcpResponse(double x2, double a2, double b2, double c, double d, double g) {
        return x2 >= d * c ? (Math.pow(x2, 1.0 / g) - b2) / a2 : x2 / c;
    }

    public static final double response(double x2, double a2, double b2, double c, double d, double g) {
        return x2 >= d ? Math.pow(a2 * x2 + b2, g) : c * x2;
    }

    public static final double rcpResponse(double x2, double a2, double b2, double c, double d, double e, double f, double g) {
        return x2 >= d * c ? (Math.pow(x2 - e, 1.0 / g) - b2) / a2 : (x2 - f) / c;
    }

    public static final double response(double x2, double a2, double b2, double c, double d, double e, double f, double g) {
        return x2 >= d ? Math.pow(a2 * x2 + b2, g) + e : c * x2 + f;
    }

    public static final double absRcpResponse(double x2, double a2, double b2, double c, double d, double g) {
        return Math.copySign(ColorSpaceKt.rcpResponse(x2 < 0.0 ? -x2 : x2, a2, b2, c, d, g), x2);
    }

    public static final double absResponse(double x2, double a2, double b2, double c, double d, double g) {
        return Math.copySign(ColorSpaceKt.response(x2 < 0.0 ? -x2 : x2, a2, b2, c, d, g), x2);
    }

    public static final boolean compare(@NotNull TransferParameters a2, @Nullable TransferParameters b2) {
        Intrinsics.checkNotNullParameter(a2, "a");
        return b2 != null && Math.abs(a2.getA() - b2.getA()) < 0.001 && Math.abs(a2.getB() - b2.getB()) < 0.001 && Math.abs(a2.getC() - b2.getC()) < 0.001 && Math.abs(a2.getD() - b2.getD()) < 0.002 && Math.abs(a2.getE() - b2.getE()) < 0.001 && Math.abs(a2.getF() - b2.getF()) < 0.001 && Math.abs(a2.getGamma() - b2.getGamma()) < 0.001;
    }

    public static final boolean compare(@NotNull WhitePoint a2, @NotNull WhitePoint b2) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        if (a2 == b2) {
            return true;
        }
        return Math.abs(a2.getX() - b2.getX()) < 0.001f && Math.abs(a2.getY() - b2.getY()) < 0.001f;
    }

    public static final boolean compare(@NotNull float[] a2, @NotNull float[] b2) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        if (a2 == b2) {
            return true;
        }
        int n = a2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (Float.compare(a2[i2], b2[i2]) == 0 || !(Math.abs(a2[i2] - b2[i2]) > 0.001f)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final float[] inverse3x3(@NotNull float[] m) {
        Intrinsics.checkNotNullParameter(m, "m");
        float a2 = m[0];
        float b2 = m[3];
        float c = m[6];
        float d = m[1];
        float e = m[4];
        float f = m[7];
        float g = m[2];
        float h = m[5];
        float i2 = m[8];
        float xA = e * i2 - f * h;
        float xB = f * g - d * i2;
        float xC = d * h - e * g;
        float det = a2 * xA + b2 * xB + c * xC;
        float[] inverted = new float[m.length];
        inverted[0] = xA / det;
        inverted[1] = xB / det;
        inverted[2] = xC / det;
        inverted[3] = (c * h - b2 * i2) / det;
        inverted[4] = (a2 * i2 - c * g) / det;
        inverted[5] = (b2 * g - a2 * h) / det;
        inverted[6] = (b2 * f - c * e) / det;
        inverted[7] = (c * d - a2 * f) / det;
        inverted[8] = (a2 * e - b2 * d) / det;
        return inverted;
    }

    @NotNull
    public static final float[] mul3x3(@NotNull float[] lhs, @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        float[] r = new float[9];
        if (lhs.length < 9) {
            return r;
        }
        if (rhs.length < 9) {
            return r;
        }
        r[0] = lhs[0] * rhs[0] + lhs[3] * rhs[1] + lhs[6] * rhs[2];
        r[1] = lhs[1] * rhs[0] + lhs[4] * rhs[1] + lhs[7] * rhs[2];
        r[2] = lhs[2] * rhs[0] + lhs[5] * rhs[1] + lhs[8] * rhs[2];
        r[3] = lhs[0] * rhs[3] + lhs[3] * rhs[4] + lhs[6] * rhs[5];
        r[4] = lhs[1] * rhs[3] + lhs[4] * rhs[4] + lhs[7] * rhs[5];
        r[5] = lhs[2] * rhs[3] + lhs[5] * rhs[4] + lhs[8] * rhs[5];
        r[6] = lhs[0] * rhs[6] + lhs[3] * rhs[7] + lhs[6] * rhs[8];
        r[7] = lhs[1] * rhs[6] + lhs[4] * rhs[7] + lhs[7] * rhs[8];
        r[8] = lhs[2] * rhs[6] + lhs[5] * rhs[7] + lhs[8] * rhs[8];
        return r;
    }

    @NotNull
    public static final float[] mul3x3Float3(@NotNull float[] lhs, @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        if (lhs.length < 9) {
            return rhs;
        }
        if (rhs.length < 3) {
            return rhs;
        }
        float r0 = rhs[0];
        float r1 = rhs[1];
        float r2 = rhs[2];
        rhs[0] = lhs[0] * r0 + lhs[3] * r1 + lhs[6] * r2;
        rhs[1] = lhs[1] * r0 + lhs[4] * r1 + lhs[7] * r2;
        rhs[2] = lhs[2] * r0 + lhs[5] * r1 + lhs[8] * r2;
        return rhs;
    }

    public static final float mul3x3Float3_0(@NotNull float[] lhs, float r0, float r1, float r2) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        boolean $i$f$mul3x3Float3_0 = false;
        return lhs[0] * r0 + lhs[3] * r1 + lhs[6] * r2;
    }

    public static final float mul3x3Float3_1(@NotNull float[] lhs, float r0, float r1, float r2) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        boolean $i$f$mul3x3Float3_1 = false;
        return lhs[1] * r0 + lhs[4] * r1 + lhs[7] * r2;
    }

    public static final float mul3x3Float3_2(@NotNull float[] lhs, float r0, float r1, float r2) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        boolean $i$f$mul3x3Float3_2 = false;
        return lhs[2] * r0 + lhs[5] * r1 + lhs[8] * r2;
    }

    @NotNull
    public static final float[] mul3x3Diag(@NotNull float[] lhs, @NotNull float[] rhs) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        float[] fArray = new float[]{lhs[0] * rhs[0], lhs[1] * rhs[1], lhs[2] * rhs[2], lhs[0] * rhs[3], lhs[1] * rhs[4], lhs[2] * rhs[5], lhs[0] * rhs[6], lhs[1] * rhs[7], lhs[2] * rhs[8]};
        return fArray;
    }

    @NotNull
    public static final float[] chromaticAdaptation(@NotNull float[] matrix, @NotNull float[] srcWhitePoint, @NotNull float[] dstWhitePoint) {
        Intrinsics.checkNotNullParameter(matrix, "matrix");
        Intrinsics.checkNotNullParameter(srcWhitePoint, "srcWhitePoint");
        Intrinsics.checkNotNullParameter(dstWhitePoint, "dstWhitePoint");
        float[] srcLMS = ColorSpaceKt.mul3x3Float3(matrix, srcWhitePoint);
        float[] dstLMS = ColorSpaceKt.mul3x3Float3(matrix, dstWhitePoint);
        float[] fArray = new float[]{dstLMS[0] / srcLMS[0], dstLMS[1] / srcLMS[1], dstLMS[2] / srcLMS[2]};
        float[] LMS = fArray;
        return ColorSpaceKt.mul3x3(ColorSpaceKt.inverse3x3(matrix), ColorSpaceKt.mul3x3Diag(LMS, matrix));
    }

    @JvmOverloads
    @NotNull
    public static final ColorSpace adapt(@NotNull ColorSpace $this$adapt, @NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter($this$adapt, "<this>");
        Intrinsics.checkNotNullParameter(whitePoint, "whitePoint");
        return ColorSpaceKt.adapt$default($this$adapt, whitePoint, null, 2, null);
    }
}

