/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.awt.Utils_desktopKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.DesktopTextInputService2Kt;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.TextEditingScope;
import androidx.compose.ui.text.input.TextEditorState;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00122\u0010\u0006\u001a.\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J\u001f\u0010+\u001a\u0004\u0018\u00010,2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.H\u0016\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020)H\u0016J\b\u00102\u001a\u00020)H\u0016J\u001d\u00103\u001a\u00020,2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.H\u0016\u00a2\u0006\u0002\u00100J\u0014\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u00010'H\u0016J-\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020)2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.H\u0016\u00a2\u0006\u0002\u0010:J\u000e\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020=R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0006\u001a.\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"\u00a8\u0006>"}, d2={"Landroidx/compose/ui/platform/InputMethodRequestsImpl;", "Ljava/awt/im/InputMethodRequests;", "component", "Landroidx/compose/ui/platform/PlatformComponent;", "state", "Landroidx/compose/ui/text/input/TextEditorState;", "editText", "Lkotlin/Function1;", "Landroidx/compose/ui/text/input/TextEditingScope;", "", "Lkotlin/ExtensionFunctionType;", "Lkotlin/ParameterName;", "name", "block", "<init>", "(Landroidx/compose/ui/platform/PlatformComponent;Landroidx/compose/ui/text/input/TextEditorState;Lkotlin/jvm/functions/Function1;)V", "selection", "Landroidx/compose/ui/text/TextRange;", "getSelection-d9O1mEE", "()J", "composition", "getComposition-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "focusedRect", "Landroidx/compose/ui/geometry/Rect;", "getFocusedRect", "()Landroidx/compose/ui/geometry/Rect;", "setFocusedRect", "(Landroidx/compose/ui/geometry/Rect;)V", "charKeyPressed", "", "getCharKeyPressed", "()Z", "setCharKeyPressed", "(Z)V", "needToDeletePreviousChar", "getNeedToDeletePreviousChar", "setNeedToDeletePreviousChar", "getLocationOffset", "Ljava/awt/font/TextHitInfo;", "x", "", "y", "cancelLatestCommittedText", "Ljava/text/AttributedCharacterIterator;", "attributes", "", "Ljava/text/AttributedCharacterIterator$Attribute;", "([Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "getInsertPositionOffset", "getCommittedTextLength", "getSelectedText", "getTextLocation", "Ljava/awt/Rectangle;", "offset", "getCommittedText", "beginIndex", "endIndex", "(II[Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "replaceInputMethodText", "event", "Ljava/awt/event/InputMethodEvent;", "ui"})
final class InputMethodRequestsImpl
implements InputMethodRequests {
    @NotNull
    private final PlatformComponent component;
    @NotNull
    private final TextEditorState state;
    @NotNull
    private final Function1<Function1<? super TextEditingScope, Unit>, Unit> editText;
    @Nullable
    private Rect focusedRect;
    private boolean charKeyPressed;
    private boolean needToDeletePreviousChar;

    public InputMethodRequestsImpl(@NotNull PlatformComponent component, @NotNull TextEditorState state2, @NotNull Function1<? super Function1<? super TextEditingScope, Unit>, Unit> editText) {
        Intrinsics.checkNotNullParameter(component, "component");
        Intrinsics.checkNotNullParameter(state2, "state");
        Intrinsics.checkNotNullParameter(editText, "editText");
        this.component = component;
        this.state = state2;
        this.editText = editText;
    }

    private final long getSelection-d9O1mEE() {
        return this.state.getSelection-d9O1mEE();
    }

    private final TextRange getComposition-MzsxiRA() {
        return this.state.getComposition-MzsxiRA();
    }

    @Nullable
    public final Rect getFocusedRect() {
        return this.focusedRect;
    }

    public final void setFocusedRect(@Nullable Rect rect2) {
        this.focusedRect = rect2;
    }

    public final boolean getCharKeyPressed() {
        return this.charKeyPressed;
    }

    public final void setCharKeyPressed(boolean bl) {
        this.charKeyPressed = bl;
    }

    public final boolean getNeedToDeletePreviousChar() {
        return this.needToDeletePreviousChar;
    }

    public final void setNeedToDeletePreviousChar(boolean bl) {
        this.needToDeletePreviousChar = bl;
    }

    @Override
    @Nullable
    public TextHitInfo getLocationOffset(int x2, int y2) {
        if (this.getComposition-MzsxiRA() != null) {
            return TextHitInfo.leading(0);
        }
        return null;
    }

    @Override
    @Nullable
    public AttributedCharacterIterator cancelLatestCommittedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        TextRange textRange = this.getComposition-MzsxiRA();
        int composedStartIndex = textRange != null ? TextRange.getStart-impl(textRange.unbox-impl()) : 0;
        TextRange textRange2 = this.getComposition-MzsxiRA();
        int composedEndIndex = textRange2 != null ? TextRange.getEnd-impl(textRange2.unbox-impl()) : 0;
        int caretIndex = TextRange.getStart-impl(this.getSelection-d9O1mEE());
        if (caretIndex < composedStartIndex) {
            return caretIndex;
        }
        if (caretIndex < composedEndIndex) {
            return composedStartIndex;
        }
        return caretIndex - (composedEndIndex - composedStartIndex);
    }

    @Override
    public int getCommittedTextLength() {
        TextRange textRange = this.getComposition-MzsxiRA();
        return this.state.length() - (textRange != null ? TextRange.getLength-impl(textRange.unbox-impl()) : 0);
    }

    @Override
    @NotNull
    public AttributedCharacterIterator getSelectedText(@Nullable AttributedCharacterIterator.Attribute[] attributes) {
        if (this.charKeyPressed && OsArch_jvmKt.getHostOs() == OS.MacOS) {
            this.needToDeletePreviousChar = true;
        }
        String str2 = TextRangeKt.substring-FDrldGo(this.state, this.getSelection-d9O1mEE());
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(str2).getIterator();
        Intrinsics.checkNotNullExpressionValue(attributedCharacterIterator, "getIterator(...)");
        return attributedCharacterIterator;
    }

    @Override
    @Nullable
    public Rectangle getTextLocation(@Nullable TextHitInfo offset) {
        Object object;
        block3: {
            block2: {
                object = this.focusedRect;
                if (object == null) break block2;
                Rect it = object;
                boolean bl = false;
                Rectangle rectangle = Utils_desktopKt.toAwtRectangle(Rect.copy$default(it, it.getRight(), 0.0f, 0.0f, 0.0f, 14, null), this.component.getDensity());
                object = rectangle;
                if (rectangle != null) break block3;
            }
            return null;
        }
        Object awtRect = object;
        Point locationOnScreen = this.component.getLocationOnScreen();
        ((Rectangle)awtRect).translate(locationOnScreen.x, locationOnScreen.y);
        return awtRect;
    }

    @Override
    @NotNull
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, @Nullable AttributedCharacterIterator.Attribute[] attributes) {
        TextRange comp = this.getComposition-MzsxiRA();
        long range = TextRangeKt.TextRange(RangesKt.coerceAtMost(beginIndex, this.state.length()), RangesKt.coerceAtMost(endIndex, this.state.length()));
        if (comp == null) {
            String res = TextRangeKt.substring-FDrldGo(this.state, range);
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString(res).getIterator();
            Intrinsics.checkNotNullExpressionValue(attributedCharacterIterator, "getIterator(...)");
            return attributedCharacterIterator;
        }
        String committed = TextRangeKt.substring-FDrldGo(this.state, TextRangeKt.TextRange(RangesKt.coerceAtMost(Math.min(TextRange.getMin-impl(range), TextRange.getMin-impl(comp.unbox-impl())), this.state.length()), RangesKt.coerceAtMost(Math.max(TextRange.getMax-impl(range), TextRange.getMax-impl(comp.unbox-impl())), this.state.length())));
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(committed).getIterator();
        Intrinsics.checkNotNullExpressionValue(attributedCharacterIterator, "getIterator(...)");
        return attributedCharacterIterator;
    }

    public final void replaceInputMethodText(@NotNull InputMethodEvent event) {
        Object object;
        Object committed;
        Intrinsics.checkNotNullParameter(event, "event");
        Object object2 = event.getText();
        if (object2 == null || (object2 = DesktopTextInputService2Kt.access$toStringUntil((AttributedCharacterIterator)object2, event.getCommittedCharacterCount())) == null) {
            object2 = committed = "";
        }
        if ((object = event.getText()) == null || (object = DesktopTextInputService2Kt.access$toStringFrom((AttributedCharacterIterator)object, event.getCommittedCharacterCount())) == null) {
            object = "";
        }
        Object composing = object;
        this.editText.invoke(arg_0 -> InputMethodRequestsImpl.replaceInputMethodText$lambda$1(this, composing, committed, arg_0));
    }

    private static final Unit replaceInputMethodText$lambda$1(InputMethodRequestsImpl this$0, Object $composing, Object $committed, TextEditingScope $this$editText) {
        Intrinsics.checkNotNullParameter($this$editText, "$this$editText");
        if (this$0.needToDeletePreviousChar && TextRange.getMin-impl(this$0.getSelection-d9O1mEE()) > 0 && ((CharSequence)$composing).length() == 0) {
            this$0.needToDeletePreviousChar = false;
            $this$editText.deleteSurroundingTextInCodePoints(1, 0);
        }
        $this$editText.commitText((CharSequence)$committed, 1);
        if (((CharSequence)$composing).length() > 0) {
            $this$editText.setComposingText((CharSequence)$composing, 1);
        }
        return Unit.INSTANCE;
    }
}

