/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Rects_skikoKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.CharHelpers_jvmKt;
import androidx.compose.ui.text.CharHelpers_skikoKt;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.TextInclusionStrategy;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.paragraph.Direction;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.RectHeightMode;
import org.jetbrains.skia.paragraph.RectWidthMode;
import org.jetbrains.skia.paragraph.TextBox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0005H\u0016J\u0010\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020\u0005H\u0016J\u0010\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010A\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010B\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010C\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0015\u0010D\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bEJ\u0010\u0010F\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0015\u0010G\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bHJ\u0012\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010>\u001a\u00020\u0005H\u0002J\u0010\u0010K\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010L\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010M\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0018\u0010N\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u00052\u0006\u0010O\u001a\u00020/H\u0016J\u0010\u0010P\u001a\u00020/2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010Q\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u0005H\u0016J\u0010\u0010R\u001a\u00020\u00052\u0006\u0010S\u001a\u00020!H\u0016J\u0012\u0010T\u001a\u0004\u0018\u00010J2\u0006\u0010S\u001a\u00020!H\u0002J\u0018\u0010U\u001a\u00020!2\u0006\u0010>\u001a\u00020\u00052\u0006\u0010V\u001a\u00020/H\u0016J\u0010\u0010W\u001a\u00020!2\u0006\u0010X\u001a\u00020/H\u0002J\u0013\u0010_\u001a\b\u0012\u0004\u0012\u00020J0ZH\u0002\u00a2\u0006\u0002\u0010^J\u0012\u0010`\u001a\u0004\u0018\u00010a2\u0006\u0010>\u001a\u00020\u0005H\u0002J\u001c\u0010b\u001a\u0004\u0018\u00010a2\u0006\u0010>\u001a\u00020\u00052\b\b\u0002\u0010<\u001a\u00020\u0005H\u0002J\u0010\u0010c\u001a\u00020d2\u0006\u0010>\u001a\u00020\u0005H\u0016J\u0010\u0010e\u001a\u00020d2\u0006\u0010>\u001a\u00020\u0005H\u0016J\u0017\u0010f\u001a\u00020\u00052\u0006\u0010g\u001a\u00020hH\u0016\u00a2\u0006\u0004\bi\u0010jJ'\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u0002062\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020qH\u0016\u00a2\u0006\u0004\br\u0010sJ\u0010\u0010t\u001a\u0002062\u0006\u0010>\u001a\u00020\u0005H\u0016J'\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020l2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b{\u0010|J\u0017\u0010}\u001a\u00020l2\u0006\u0010>\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b~\u0010\u007fJ>\u0010\u0080\u0001\u001a\u00020v2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001H\u0016\u00a2\u0006\u0006\b\u0089\u0001\u0010\u008a\u0001JT\u0010\u0080\u0001\u001a\u00020v2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\n\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0017\u00a2\u0006\u0006\b\u008f\u0001\u0010\u0090\u0001J]\u0010\u0080\u0001\u001a\u00020v2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0007\u0010\u0093\u0001\u001a\u00020!2\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\n\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0017\u00a2\u0006\u0006\b\u0094\u0001\u0010\u0095\u0001J\u0012\u0010\u0096\u0001\u001a\u00020v2\u0006\u0010>\u001a\u00020\u0005H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u00020\t\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010#R\u0014\u0010(\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010#R\u0014\u0010*\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010#R\u0014\u0010,\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010#R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\rR\u001c\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u000106058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0018\u0010Y\u001a\n\u0012\u0004\u0012\u00020J\u0018\u00010ZX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010[R\u001a\u0010\\\u001a\b\u0012\u0004\u0012\u00020J0Z8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010^\u00a8\u0006\u0097\u0001"}, d2={"Landroidx/compose/ui/text/SkiaParagraph;", "Landroidx/compose/ui/text/Paragraph;", "paragraphIntrinsics", "Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "maxLines", "", "overflow", "Landroidx/compose/ui/text/style/TextOverflow;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "<init>", "(Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;IIJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getMaxLines", "()I", "getConstraints-msEJaDk", "()J", "J", "layouter", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "defaultFont", "Lorg/jetbrains/skia/Font;", "getDefaultFont$ui_text", "()Lorg/jetbrains/skia/Font;", "value", "Lorg/jetbrains/skia/paragraph/Paragraph;", "paragraph", "setParagraph", "(Lorg/jetbrains/skia/paragraph/Paragraph;)V", "text", "", "getText", "()Ljava/lang/String;", "width", "", "getWidth", "()F", "height", "getHeight", "minIntrinsicWidth", "getMinIntrinsicWidth", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "firstBaseline", "getFirstBaseline", "lastBaseline", "getLastBaseline", "didExceedMaxLines", "", "getDidExceedMaxLines", "()Z", "lineCount", "getLineCount", "placeholderRects", "", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "end", "getCursorRect", "offset", "getLineLeft", "lineIndex", "getLineRight", "getLineTop", "getLineBottom", "getLineAscent", "getLineAscent$ui_text", "getLineBaseline", "getLineDescent", "getLineDescent$ui_text", "lineMetricsForOffset", "Lorg/jetbrains/skia/paragraph/LineMetrics;", "getLineHeight", "getLineWidth", "getLineStart", "getLineEnd", "visibleEnd", "isLineEllipsized", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineMetricsForVerticalPosition", "getHorizontalPosition", "usePrimaryDirection", "getAlignedStartingPosition", "isRtl", "_lineMetrics", "", "[Lorg/jetbrains/skia/paragraph/LineMetrics;", "lineMetrics", "getLineMetrics", "()[Lorg/jetbrains/skia/paragraph/LineMetrics;", "receiveLineMetrics", "getBoxForwardByOffset", "Lorg/jetbrains/skia/paragraph/TextBox;", "getBoxBackwardByOffset", "getParagraphDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getBidiRunDirection", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getRangeForRect", "Landroidx/compose/ui/text/TextRange;", "rect", "granularity", "Landroidx/compose/ui/text/TextGranularity;", "inclusionStrategy", "Landroidx/compose/ui/text/TextInclusionStrategy;", "getRangeForRect-8-6BmAI", "(Landroidx/compose/ui/geometry/Rect;ILandroidx/compose/ui/text/TextInclusionStrategy;)J", "getBoundingBox", "fillBoundingBoxes", "", "range", "array", "", "arrayStart", "fillBoundingBoxes-8ffj60Q", "(J[FI)V", "getWordBoundary", "getWordBoundary--jx7JFs", "(I)J", "paint", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "color", "Landroidx/compose/ui/graphics/Color;", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "paint-LG529CI", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "brush", "Landroidx/compose/ui/graphics/Brush;", "alpha", "paint-hn5TExg", "(Landroidx/compose/ui/graphics/Canvas;Landroidx/compose/ui/graphics/Brush;FLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "checkOffsetIsValid", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSkiaParagraph.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n+ 2 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph_skikoKt\n+ 7 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 8 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,708:1\n623#1,4:718\n623#1,4:742\n623#1,4:746\n623#1,4:773\n33#2:709\n33#2:777\n53#3,3:710\n60#3:751\n70#3:754\n70#3:756\n60#3:759\n60#3:762\n70#3:765\n60#3:768\n70#3:771\n53#3,3:778\n1#4:713\n11228#5:714\n11563#5,3:715\n697#6,10:722\n697#6,10:732\n65#7:750\n69#7:753\n69#7:755\n65#7:758\n65#7:761\n69#7:764\n65#7:767\n69#7:770\n22#8:752\n22#8:757\n22#8:760\n22#8:763\n22#8:766\n22#8:769\n22#8:772\n*S KotlinDebug\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n*L\n209#1:718,4\n316#1:742,4\n332#1:746,4\n522#1:773,4\n90#1:709\n603#1:777\n90#1:710,3\n395#1:751\n395#1:754\n434#1:756\n438#1:759\n480#1:762\n481#1:765\n482#1:768\n483#1:771\n603#1:778,3\n131#1:714\n131#1:715,3\n211#1:722,10\n255#1:732,10\n395#1:750\n395#1:753\n434#1:755\n438#1:758\n480#1:761\n481#1:764\n482#1:767\n483#1:770\n395#1:752\n434#1:757\n438#1:760\n480#1:763\n481#1:766\n482#1:769\n483#1:772\n*E\n"})
public final class SkiaParagraph
implements Paragraph {
    @NotNull
    private final SkiaParagraphIntrinsics paragraphIntrinsics;
    private final int maxLines;
    private final long constraints;
    @NotNull
    private final ParagraphLayouter layouter;
    @NotNull
    private org.jetbrains.skia.paragraph.Paragraph paragraph;
    @Nullable
    private LineMetrics[] _lineMetrics;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private SkiaParagraph(SkiaParagraphIntrinsics paragraphIntrinsics, int maxLines, int overflow, long constraints) {
        void width$iv;
        void $this$layouter_u24lambda_u240;
        ParagraphLayouter paragraphLayouter;
        Intrinsics.checkNotNullParameter(paragraphIntrinsics, "paragraphIntrinsics");
        this.paragraphIntrinsics = paragraphIntrinsics;
        this.maxLines = maxLines;
        this.constraints = constraints;
        ParagraphLayouter paragraphLayouter2 = paragraphLayouter = this.paragraphIntrinsics.layouter();
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        TextOverflow[] textOverflowArray = new TextOverflow[]{TextOverflow.box-impl(TextOverflow.Companion.getEllipsis-gIe3tQ8()), TextOverflow.box-impl(TextOverflow.Companion.getMiddleEllipsis-gIe3tQ8()), TextOverflow.box-impl(TextOverflow.Companion.getStartEllipsis-gIe3tQ8())};
        String ellipsisChar = CollectionsKt.listOf(textOverflowArray).contains(TextOverflow.box-impl(overflow)) ? "\u2026" : "";
        $this$layouter_u24lambda_u240.setParagraphStyle(this.maxLines, ellipsisChar);
        skiaParagraph.layouter = paragraphLayouter;
        this.paragraph = this.layouter.layoutParagraph(this.getWidth());
        float f = this.getWidth();
        float height$iv = this.getHeight();
        boolean $i$f$Size = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)width$iv);
        long v2$iv$iv = Float.floatToRawIntBits(height$iv);
        this.layouter.setBrushSize-uvyYCjk(Size.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        this.setParagraph(this.layouter.layoutParagraph(this.getWidth()));
        this.paragraph.layout(this.getWidth());
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final long getConstraints-msEJaDk() {
        return this.constraints;
    }

    @NotNull
    public final Font getDefaultFont$ui_text() {
        return this.layouter.getDefaultFont();
    }

    private final void setParagraph(org.jetbrains.skia.paragraph.Paragraph value) {
        this.paragraph = value;
        this._lineMetrics = null;
    }

    private final String getText() {
        return this.paragraphIntrinsics.getText();
    }

    @Override
    public float getWidth() {
        return Constraints.getMaxWidth-impl(this.constraints);
    }

    @Override
    public float getHeight() {
        return this.paragraph.getHeight();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        float f;
        LineMetrics lineMetrics = ArraysKt.firstOrNull(this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_firstBaseline__u24lambda_u241 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_firstBaseline__u24lambda_u241.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLastBaseline() {
        float f;
        LineMetrics lineMetrics = ArraysKt.lastOrNull(this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_lastBaseline__u24lambda_u242 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_lastBaseline__u24lambda_u242.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.paragraph.didExceedMaxLines();
    }

    @Override
    public int getLineCount() {
        return Intrinsics.areEqual(this.getText(), "") || this.paragraph.getLineNumber() < 1 ? 1 : this.paragraph.getLineNumber();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Rect> getPlaceholderRects() {
        void $this$mapTo$iv$iv;
        TextBox[] $this$map$iv = this.paragraph.getRectsForPlaceholders();
        boolean $i$f$map = false;
        TextBox[] textBoxArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Rects_skikoKt.toComposeRect(it.getRect()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public androidx.compose.ui.graphics.Path getPathForRange(int start2, int end) {
        TextBox[] boxes = this.paragraph.getRectsForRange(start2, end, RectHeightMode.MAX, RectWidthMode.TIGHT);
        androidx.compose.ui.graphics.Path path = SkiaBackedPath_skikoKt.Path();
        for (TextBox b2 : boxes) {
            Path.addRect$default(SkiaBackedPath_skikoKt.asSkiaPath(path), b2.getRect(), null, 0, 6, null);
        }
        return path;
    }

    @Override
    @NotNull
    public Rect getCursorRect(int offset) {
        double d;
        double d2;
        float horizontal = this.getHorizontalPosition(offset, true);
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        Intrinsics.checkNotNull(lineMetrics);
        LineMetrics line = lineMetrics;
        boolean isNewEmptyLine = offset - 1 == line.getStartIndex() && offset == this.getText().length();
        FontMetrics metrics2 = this.getDefaultFont$ui_text().getMetrics();
        double it = line.getAscent();
        boolean bl = false;
        if (isNewEmptyLine) {
            double ascent = -((double)metrics2.getAscent());
            d2 = RangesKt.coerceAtMost(it, ascent);
        } else {
            d2 = it;
        }
        double asc = d2;
        double it2 = line.getDescent();
        boolean bl2 = false;
        if (isNewEmptyLine) {
            double descent = metrics2.getDescent();
            d = RangesKt.coerceAtMost(it2, descent);
        } else {
            d = it2;
        }
        double desc = d;
        return new Rect(horizontal, (float)(line.getBaseline() - asc), horizontal, (float)(line.getBaseline() + desc));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getLeft() : 0.0f;
    }

    @Override
    public float getLineRight(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getRight() : 0.0f;
    }

    @Override
    public float getLineTop(int lineIndex) {
        float f;
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() - line.getAscent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLineBottom(int lineIndex) {
        float f;
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() + line.getDescent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final float getLineAscent$ui_text(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return -(lineMetrics != null ? (float)lineMetrics.getAscent() : 0.0f);
    }

    @Override
    public float getLineBaseline(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getBaseline() : 0.0f;
    }

    public final float getLineDescent$ui_text(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getDescent() : 0.0f;
    }

    private final LineMetrics lineMetricsForOffset(int offset) {
        LineMetrics lineMetrics;
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = false;
            String $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException($i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22.toString());
        }
        LineMetrics[] $this$binarySearchFirstMatchingOrLast$iv = this.getLineMetrics();
        boolean $i$f$binarySearchFirstMatchingOrLast = false;
        if ($this$binarySearchFirstMatchingOrLast$iv.length == 0) {
            lineMetrics = null;
        } else {
            int index$iv = CollectionsKt.binarySearch$default(ArraysKt.asList($this$binarySearchFirstMatchingOrLast$iv), 0, 0, new Function1<LineMetrics, Integer>(offset){
                final /* synthetic */ int $offset$inlined;
                {
                    this.$offset$inlined = n;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Integer invoke(Object it) {
                    LineMetrics it2 = (LineMetrics)it;
                    boolean bl = false;
                    return this.$offset$inlined < it2.getEndIncludingNewline() ? 1 : -1;
                }
            }, 3, null);
            lineMetrics = $this$binarySearchFirstMatchingOrLast$iv[RangesKt.coerceAtMost(-index$iv - 1, ArraysKt.getLastIndex($this$binarySearchFirstMatchingOrLast$iv))];
        }
        return lineMetrics;
    }

    @Override
    public float getLineHeight(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getHeight() : 0.0f;
    }

    @Override
    public float getLineWidth(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getWidth() : 0.0f;
    }

    @Override
    public int getLineStart(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? lineMetrics.getStartIndex() : 0;
    }

    @Override
    public int getLineEnd(int lineIndex, boolean visibleEnd) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        if (lineMetrics == null) {
            return 0;
        }
        LineMetrics metrics2 = lineMetrics;
        return visibleEnd ? (lineIndex > 0 && metrics2.getStartIndex() < this.getLineMetrics()[lineIndex - 1].getEndIndex() ? metrics2.getEndIndex() : (metrics2.getStartIndex() < this.getText().length() && this.getText().charAt(metrics2.getStartIndex()) == '\n' ? metrics2.getStartIndex() : metrics2.getEndExcludingWhitespaces())) : metrics2.getEndIndex();
    }

    @Override
    public boolean isLineEllipsized(int lineIndex) {
        return false;
    }

    @Override
    public int getLineForOffset(int offset) {
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    @Override
    public int getLineForVerticalPosition(float vertical) {
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(vertical);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    private final LineMetrics getLineMetricsForVerticalPosition(float vertical) {
        LineMetrics lineMetrics;
        LineMetrics[] $this$binarySearchFirstMatchingOrLast$iv = this.getLineMetrics();
        boolean $i$f$binarySearchFirstMatchingOrLast = false;
        if ($this$binarySearchFirstMatchingOrLast$iv.length == 0) {
            lineMetrics = null;
        } else {
            int index$iv = CollectionsKt.binarySearch$default(ArraysKt.asList($this$binarySearchFirstMatchingOrLast$iv), 0, 0, new Function1<LineMetrics, Integer>(vertical){
                final /* synthetic */ float $vertical$inlined;
                {
                    this.$vertical$inlined = f;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Integer invoke(Object it) {
                    LineMetrics it2 = (LineMetrics)it;
                    boolean bl = false;
                    return (double)this.$vertical$inlined < it2.getBaseline() + it2.getDescent() ? 1 : -1;
                }
            }, 3, null);
            lineMetrics = $this$binarySearchFirstMatchingOrLast$iv[RangesKt.coerceAtMost(-index$iv - 1, ArraysKt.getLastIndex($this$binarySearchFirstMatchingOrLast$iv))];
        }
        return lineMetrics;
    }

    @Override
    public float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        float f;
        TextBox prevBox = SkiaParagraph.getBoxBackwardByOffset$default(this, offset, 0, 2, null);
        TextBox nextBox = this.getBoxForwardByOffset(offset);
        boolean isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        boolean isLtr = !isRtl;
        if (prevBox == null && nextBox == null) {
            f = this.getAlignedStartingPosition(isRtl);
        } else if (prevBox == null) {
            TextBox textBox = nextBox;
            Intrinsics.checkNotNull(textBox);
            f = androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox, true);
        } else {
            f = nextBox == null ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : (nextBox.getDirection() == prevBox.getDirection() ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isLtr && prevBox.getDirection() == Direction.LTR ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isRtl && prevBox.getDirection() == Direction.RTL ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (usePrimaryDirection ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true)))));
        }
        return f;
    }

    private final float getAlignedStartingPosition(boolean isRtl) {
        int n = this.layouter.getTextStyle().getTextAlign-e0LSkKk();
        return TextAlign.equals-impl0(n, TextAlign.Companion.getLeft-e0LSkKk()) ? 0.0f : (TextAlign.equals-impl0(n, TextAlign.Companion.getRight-e0LSkKk()) ? this.getWidth() : (TextAlign.equals-impl0(n, TextAlign.Companion.getCenter-e0LSkKk()) ? this.getWidth() / (float)2 : (TextAlign.equals-impl0(n, TextAlign.Companion.getStart-e0LSkKk()) ? (isRtl ? this.getWidth() : 0.0f) : (TextAlign.equals-impl0(n, TextAlign.Companion.getEnd-e0LSkKk()) ? (isRtl ? 0.0f : this.getWidth()) : 0.0f))));
    }

    private final LineMetrics[] getLineMetrics() {
        LineMetrics[] lineMetricsArray = this._lineMetrics;
        if (this._lineMetrics == null) {
            LineMetrics[] lineMetricsArray2;
            LineMetrics[] it = lineMetricsArray2 = this.receiveLineMetrics();
            boolean bl = false;
            this._lineMetrics = it;
            lineMetricsArray = lineMetricsArray2;
        }
        LineMetrics[] lineMetrics = lineMetricsArray;
        return lineMetrics;
    }

    private final LineMetrics[] receiveLineMetrics() {
        LineMetrics[] lineMetrics = ((CharSequence)this.getText()).length() == 0 ? this.layouter.emptyLineMetrics$ui_text(this.paragraph) : this.paragraph.getLineMetrics();
        FontMetrics fontMetrics2 = this.getDefaultFont$ui_text().getMetrics();
        if (!(lineMetrics.length == 0)) {
            lineMetrics[0] = SkiaParagraph_skikoKt.access$trimFirstAscent(lineMetrics[0], fontMetrics2, this.layouter.getTextStyle());
            lineMetrics[lineMetrics.length - 1] = SkiaParagraph_skikoKt.access$trimLastDescent(lineMetrics[lineMetrics.length - 1], fontMetrics2, this.layouter.getTextStyle());
        }
        return lineMetrics;
    }

    private final TextBox getBoxForwardByOffset(int offset) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string2 = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException(string2.toString());
        }
        for (int to = offset + 1; to <= this.getText().length(); ++to) {
            TextBox box = ArraysKt.firstOrNull(this.paragraph.getRectsForRange(offset, to, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) continue;
            return box;
        }
        return null;
    }

    private final TextBox getBoxBackwardByOffset(int offset, int end) {
        boolean isRtl;
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = false;
            String $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException($i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22.toString());
        }
        boolean bl = isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        for (int from2 = offset - 1; from2 >= 0; --from2) {
            TextBox box = ArraysKt.firstOrNull(this.paragraph.getRectsForRange(from2, end, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) {
                continue;
            }
            if (this.getText().charAt(from2) == '\n') {
                TextBox textBox;
                if (!isRtl) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect2 = new org.jetbrains.skia.Rect(0.0f, box.getRect().getBottom(), 0.0f, bottom);
                    return new TextBox(rect2, box.getDirection());
                }
                if (from2 == StringsKt.getLastIndex(this.getText())) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect3 = new org.jetbrains.skia.Rect(this.getWidth(), box.getRect().getBottom(), this.getWidth(), bottom);
                    textBox = new TextBox(rect3, box.getDirection());
                } else {
                    TextBox nextBox = ArraysKt.first(this.paragraph.getRectsForRange(offset, offset + 1, RectHeightMode.STRUT, RectWidthMode.TIGHT));
                    org.jetbrains.skia.Rect rect4 = new org.jetbrains.skia.Rect(nextBox.getRect().getLeft(), nextBox.getRect().getTop(), nextBox.getRect().getLeft(), nextBox.getRect().getBottom());
                    textBox = new TextBox(rect4, nextBox.getDirection());
                }
                return textBox;
            }
            return box;
        }
        return null;
    }

    static /* synthetic */ TextBox getBoxBackwardByOffset$default(SkiaParagraph skiaParagraph, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return skiaParagraph.getBoxBackwardByOffset(n, n2);
    }

    @Override
    @NotNull
    public ResolvedTextDirection getParagraphDirection(int offset) {
        return this.paragraphIntrinsics.getTextDirection();
    }

    @Override
    @NotNull
    public ResolvedTextDirection getBidiRunDirection(int offset) {
        ResolvedTextDirection resolvedTextDirection;
        TextBox textBox = this.getBoxForwardByOffset(offset);
        Direction direction = textBox != null ? textBox.getDirection() : null;
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                resolvedTextDirection = ResolvedTextDirection.Rtl;
                break;
            }
            case 2: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            case -1: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resolvedTextDirection;
    }

    @Override
    public int getOffsetForPosition-k-4lQ0M(long position) {
        boolean $i$f$unpackFloat2;
        boolean hasNonSpacingMarkAtEnd;
        int lastCharIndex;
        float rightX;
        boolean isNonSpacingMark;
        boolean bl = false;
        long value$iv$iv = position;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float f = Float.intBitsToFloat(bits$iv$iv$iv);
        boolean bl2 = false;
        value$iv$iv = position;
        boolean $i$f$unpackFloat22 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        int initialGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(f, Float.intBitsToFloat(bits$iv$iv$iv)).getPosition();
        int glyphPosition = initialGlyphPosition;
        boolean bl3 = 0 <= glyphPosition ? glyphPosition < this.getText().length() : false;
        if (bl3 && (isNonSpacingMark = CharHelpers_jvmKt.isNonSpacingMark(CharHelpers_skikoKt.codePointAt(this.getText(), glyphPosition)))) {
            int precedingBreak = CharHelpers_skikoKt.findPrecedingBreak(this.getText(), glyphPosition);
            int followingBreak = CharHelpers_skikoKt.findFollowingBreak(this.getText(), glyphPosition);
            if (precedingBreak != glyphPosition && followingBreak != glyphPosition) {
                glyphPosition = followingBreak;
            }
        }
        $i$f$getY-impl = false;
        long value$iv$iv2 = position;
        boolean $i$f$unpackFloat23 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(Float.intBitsToFloat(bits$iv$iv$iv2));
        if (lineMetrics == null) {
            return glyphPosition;
        }
        LineMetrics expectedLine = lineMetrics;
        boolean isNotEmptyLine = expectedLine.getStartIndex() < expectedLine.getEndIndex();
        $i$f$getX-impl = false;
        value$iv$iv2 = position;
        boolean $i$f$unpackFloat12 = false;
        bits$iv$iv$iv2 = (int)(value$iv$iv2 >> 32);
        $i$f$floatFromBits2 = false;
        if ((double)Float.intBitsToFloat(bits$iv$iv$iv2) > expectedLine.getLeft()) {
            $i$f$getX-impl = false;
            value$iv$iv2 = position;
            $i$f$unpackFloat12 = false;
            bits$iv$iv$iv2 = (int)(value$iv$iv2 >> 32);
            $i$f$floatFromBits2 = false;
            if ((double)Float.intBitsToFloat(bits$iv$iv$iv2) < expectedLine.getRight()) {
                return glyphPosition;
            }
        }
        TextBox[] rects = isNotEmptyLine ? this.paragraph.getRectsForRange(expectedLine.getStartIndex(), expectedLine.isHardBreak() ? expectedLine.getEndIndex() : expectedLine.getEndIndex() - 1, RectHeightMode.STRUT, RectWidthMode.TIGHT) : null;
        Object object = rects;
        float leftX = rects != null && (object = (TextBox[])ArraysKt.firstOrNull(object)) != null && (object = ((TextBox)object).getRect()) != null ? ((org.jetbrains.skia.Rect)object).getLeft() : (float)expectedLine.getLeft();
        Object object2 = rects;
        float f2 = rightX = rects != null && (object2 = ArraysKt.lastOrNull(object2)) != null && (object2 = ((TextBox)object2).getRect()) != null ? ((org.jetbrains.skia.Rect)object2).getRight() : (float)expectedLine.getRight();
        if (leftX == rightX) {
            return glyphPosition;
        }
        boolean bl4 = isNotEmptyLine && expectedLine.getEndExcludingWhitespaces() > 0 ? ((lastCharIndex = expectedLine.getEndExcludingWhitespaces() - 1) >= 0 && lastCharIndex < this.getText().length() ? CharHelpers_jvmKt.isNonSpacingMark(CharHelpers_skikoKt.codePointAt(this.getText(), lastCharIndex)) : false) : (hasNonSpacingMarkAtEnd = false);
        if (hasNonSpacingMarkAtEnd) {
            return glyphPosition;
        }
        int correctedGlyphPosition = glyphPosition;
        $i$f$getX-impl = false;
        long value$iv$iv3 = position;
        boolean $i$f$unpackFloat13 = false;
        int bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
        boolean $i$f$floatFromBits3 = false;
        if (Float.intBitsToFloat(bits$iv$iv$iv3) <= leftX) {
            $i$f$getY-impl = false;
            value$iv$iv3 = position;
            $i$f$unpackFloat2 = false;
            bits$iv$iv$iv3 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
            $i$f$floatFromBits3 = false;
            correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(leftX + 1.0f, Float.intBitsToFloat(bits$iv$iv$iv3)).getPosition();
        } else {
            $i$f$getX-impl = false;
            value$iv$iv3 = position;
            $i$f$unpackFloat13 = false;
            bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
            $i$f$floatFromBits3 = false;
            if (Float.intBitsToFloat(bits$iv$iv$iv3) >= rightX) {
                boolean isNeutralChar;
                $i$f$getY-impl = false;
                value$iv$iv3 = position;
                $i$f$unpackFloat2 = false;
                bits$iv$iv$iv3 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
                $i$f$floatFromBits3 = false;
                correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(rightX - 1.0f, Float.intBitsToFloat(bits$iv$iv$iv3)).getPosition();
                boolean bl5 = isNeutralChar = (0 <= correctedGlyphPosition ? correctedGlyphPosition < ((CharSequence)this.getText()).length() : false) ? CharHelpers_jvmKt.isNeutralDirection(CharHelpers_skikoKt.codePointAt(this.getText(), correctedGlyphPosition)) : false;
                if (!isNeutralChar) {
                    TextBox textBox = SkiaParagraph.getBoxBackwardByOffset$default(this, correctedGlyphPosition, 0, 2, null);
                    if ((textBox != null ? textBox.getDirection() : null) == Direction.RTL) {
                        --correctedGlyphPosition;
                    }
                }
            }
        }
        return correctedGlyphPosition;
    }

    @Override
    public long getRangeForRect-8-6BmAI(@NotNull Rect rect2, int granularity, @NotNull TextInclusionStrategy inclusionStrategy) {
        Intrinsics.checkNotNullParameter(rect2, "rect");
        Intrinsics.checkNotNullParameter(inclusionStrategy, "inclusionStrategy");
        return TextRange.Companion.getZero-d9O1mEE();
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        TextBox textBox = this.getBoxForwardByOffset(offset);
        if (textBox == null) {
            TextBox textBox2 = this.getBoxBackwardByOffset(offset, this.getText().length());
            textBox = textBox2;
            Intrinsics.checkNotNull(textBox2);
        }
        TextBox box = textBox;
        return Rects_skikoKt.toComposeRect(box.getRect());
    }

    @Override
    public void fillBoundingBoxes-8ffj60Q(long range, @NotNull float[] array2, int arrayStart) {
        Intrinsics.checkNotNullParameter(array2, "array");
        System.out.println((Object)"Compose Multiplatform doesn't support fillBoundingBoxes` yet. Follow https://github.com/JetBrains/compose-multiplatform/issues/4236");
    }

    @Override
    public long getWordBoundary--jx7JFs(int offset) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string2 = "Invalid offset: " + offset + ". Valid range is [0, " + this_$iv.getText().length() + "]";
            throw new IllegalArgumentException(string2.toString());
        }
        if (offset < this.getText().length() && CharsKt.isWhitespace(this.getText().charAt(offset)) || offset == this.getText().length()) {
            return offset > 0 && !CharsKt.isWhitespace(this.getText().charAt(offset - 1)) ? SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset - 1)) : TextRangeKt.TextRange(offset, offset);
        }
        return SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint-RPmYEkk(@NotNull Canvas canvas2, long color, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        void $this$paint_RPmYEkk_u24lambda_u2411;
        Intrinsics.checkNotNullParameter(canvas2, "canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_RPmYEkk_u24lambda_u2411.setColor-8_81llA(color);
        $this$paint_RPmYEkk_u24lambda_u2411.setTextStyle(shadow, textDecoration);
        skiaParagraph.setParagraph($this$paint_RPmYEkk_u24lambda_u2411.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas2), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalTextApi
    public void paint-LG529CI(@NotNull Canvas canvas2, long color, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        void $this$paint_LG529CI_u24lambda_u2412;
        Intrinsics.checkNotNullParameter(canvas2, "canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_LG529CI_u24lambda_u2412.setColor-8_81llA(color);
        $this$paint_LG529CI_u24lambda_u2412.setTextStyle(shadow, textDecoration);
        $this$paint_LG529CI_u24lambda_u2412.setDrawStyle(drawStyle);
        $this$paint_LG529CI_u24lambda_u2412.setBlendMode-s9anfk8(blendMode);
        skiaParagraph.setParagraph($this$paint_LG529CI_u24lambda_u2412.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas2), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalTextApi
    public void paint-hn5TExg(@NotNull Canvas canvas2, @NotNull Brush brush, float alpha2, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        void $this$paint_hn5TExg_u24lambda_u2413;
        void width$iv;
        Intrinsics.checkNotNullParameter(canvas2, "canvas");
        Intrinsics.checkNotNullParameter(brush, "brush");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        float f = this.getWidth();
        float height$iv = this.getHeight();
        boolean $i$f$Size = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)width$iv);
        long v2$iv$iv = Float.floatToRawIntBits(height$iv);
        $this$paint_hn5TExg_u24lambda_u2413.setBrush-12SF9DM(brush, Size.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL), alpha2);
        $this$paint_hn5TExg_u24lambda_u2413.setTextStyle(shadow, textDecoration);
        $this$paint_hn5TExg_u24lambda_u2413.setDrawStyle(drawStyle);
        $this$paint_hn5TExg_u24lambda_u2413.setBlendMode-s9anfk8(blendMode);
        skiaParagraph.setParagraph($this$paint_hn5TExg_u24lambda_u2413.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas2), 0.0f, 0.0f);
    }

    private final void checkOffsetIsValid(int offset) {
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset ? offset <= this.getText().length() : false)) {
            boolean bl = false;
            String string2 = "Invalid offset: " + offset + ". Valid range is [0, " + this.getText().length() + "]";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ SkiaParagraph(SkiaParagraphIntrinsics paragraphIntrinsics, int maxLines, int overflow, long constraints, DefaultConstructorMarker $constructor_marker) {
        this(paragraphIntrinsics, maxLines, overflow, constraints);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.RTL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.LTR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

