/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.EditingBufferKt;
import androidx.compose.ui.text.input.PartialGapBuffer;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\tJ\r\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\rH\u0080\u0002\u00a2\u0006\u0002\b(J%\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b/J%\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b/J\u001d\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b1J\u001d\u00102\u001a\u00020,2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b3J\u001d\u00104\u001a\u00020,2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b5J\r\u00106\u001a\u00020,H\u0000\u00a2\u0006\u0002\b7J\r\u00108\u001a\u00020,H\u0000\u00a2\u0006\u0002\b9J\b\u0010:\u001a\u00020\bH\u0016J\r\u0010;\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b<R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001e\u0010\u0016\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u001e\u0010\u0018\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R$\u0010\"\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010\u0012R\u0014\u0010)\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0010\u00a8\u0006>"}, d2={"Landroidx/compose/ui/text/input/EditingBuffer;", "", "text", "Landroidx/compose/ui/text/AnnotatedString;", "selection", "Landroidx/compose/ui/text/TextRange;", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "gapBuffer", "Landroidx/compose/ui/text/input/PartialGapBuffer;", "value", "", "selectionStart", "getSelectionStart$ui_text", "()I", "setSelectionStart", "(I)V", "selectionEnd", "getSelectionEnd$ui_text", "setSelectionEnd", "compositionStart", "getCompositionStart$ui_text", "compositionEnd", "getCompositionEnd$ui_text", "hasComposition", "", "hasComposition$ui_text", "composition", "getComposition-MzsxiRA$ui_text", "()Landroidx/compose/ui/text/TextRange;", "getSelection-d9O1mEE$ui_text", "()J", "cursor", "getCursor$ui_text", "setCursor$ui_text", "get", "", "index", "get$ui_text", "length", "getLength$ui_text", "replace", "", "start", "end", "replace$ui_text", "delete", "delete$ui_text", "setSelection", "setSelection$ui_text", "setComposition", "setComposition$ui_text", "cancelComposition", "cancelComposition$ui_text", "commitComposition", "commitComposition$ui_text", "toString", "toAnnotatedString", "toAnnotatedString$ui_text", "Companion", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEditingBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditingBuffer.kt\nandroidx/compose/ui/text/input/EditingBuffer\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,382:1\n118#2,4:383\n118#2,4:387\n*S KotlinDebug\n*F\n+ 1 EditingBuffer.kt\nandroidx/compose/ui/text/input/EditingBuffer\n*L\n50#1:383,4\n59#1:387,4\n*E\n"})
public final class EditingBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PartialGapBuffer gapBuffer;
    private int selectionStart;
    private int selectionEnd;
    private int compositionStart;
    private int compositionEnd;
    public static final int $stable = 8;
    public static final int NOWHERE = -1;

    private EditingBuffer(AnnotatedString text, long selection) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.gapBuffer = new PartialGapBuffer(text.getText());
        this.selectionStart = TextRange.getMin-impl(selection);
        this.selectionEnd = TextRange.getMax-impl(selection);
        this.compositionStart = -1;
        this.compositionEnd = -1;
        int start2 = TextRange.getMin-impl(selection);
        int end = TextRange.getMax-impl(selection);
        if (start2 < 0 || start2 > text.length()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + text.length());
        }
        if (end < 0 || end > text.length()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + text.length());
        }
        if (start2 > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start2 + " > " + end);
        }
    }

    public final int getSelectionStart$ui_text() {
        return this.selectionStart;
    }

    private final void setSelectionStart(int value) {
        boolean value$iv = value >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Cannot set selectionStart to a negative value: " + value);
        }
        this.selectionStart = value;
    }

    public final int getSelectionEnd$ui_text() {
        return this.selectionEnd;
    }

    private final void setSelectionEnd(int value) {
        boolean value$iv = value >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Cannot set selectionEnd to a negative value: " + value);
        }
        this.selectionEnd = value;
    }

    public final int getCompositionStart$ui_text() {
        return this.compositionStart;
    }

    public final int getCompositionEnd$ui_text() {
        return this.compositionEnd;
    }

    public final boolean hasComposition$ui_text() {
        return this.compositionStart != -1;
    }

    @Nullable
    public final TextRange getComposition-MzsxiRA$ui_text() {
        return this.hasComposition$ui_text() ? TextRange.box-impl(TextRangeKt.TextRange(this.compositionStart, this.compositionEnd)) : null;
    }

    public final long getSelection-d9O1mEE$ui_text() {
        return TextRangeKt.TextRange(this.selectionStart, this.selectionEnd);
    }

    public final int getCursor$ui_text() {
        return this.selectionStart == this.selectionEnd ? this.selectionEnd : -1;
    }

    public final void setCursor$ui_text(int cursor2) {
        this.setSelection$ui_text(cursor2, cursor2);
    }

    public final char get$ui_text(int index2) {
        return this.gapBuffer.get(index2);
    }

    public final int getLength$ui_text() {
        return this.gapBuffer.getLength();
    }

    private EditingBuffer(String text, long selection) {
        Intrinsics.checkNotNullParameter(text, "text");
        this(new AnnotatedString(text, null, 2, null), selection, null);
    }

    public final void replace$ui_text(int start2, int end, @NotNull AnnotatedString text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.replace$ui_text(start2, end, text.getText());
    }

    public final void replace$ui_text(int start2, int end, @NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        if (start2 < 0 || start2 > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start2 > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start2 + " > " + end);
        }
        this.gapBuffer.replace(start2, end, text);
        this.setSelectionStart(start2 + text.length());
        this.setSelectionEnd(start2 + text.length());
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void delete$ui_text(int start2, int end) {
        long deleteRange = TextRangeKt.TextRange(start2, end);
        this.gapBuffer.replace(start2, end, "");
        long newSelection = EditingBufferKt.updateRangeAfterDelete-pWDy79M(TextRangeKt.TextRange(this.selectionStart, this.selectionEnd), deleteRange);
        this.setSelectionStart(TextRange.getMin-impl(newSelection));
        this.setSelectionEnd(TextRange.getMax-impl(newSelection));
        if (this.hasComposition$ui_text()) {
            long compositionRange = TextRangeKt.TextRange(this.compositionStart, this.compositionEnd);
            long newComposition = EditingBufferKt.updateRangeAfterDelete-pWDy79M(compositionRange, deleteRange);
            if (TextRange.getCollapsed-impl(newComposition)) {
                this.commitComposition$ui_text();
            } else {
                this.compositionStart = TextRange.getMin-impl(newComposition);
                this.compositionEnd = TextRange.getMax-impl(newComposition);
            }
        }
    }

    public final void setSelection$ui_text(int start2, int end) {
        if (start2 < 0 || start2 > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start2 > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start2 + " > " + end);
        }
        this.setSelectionStart(start2);
        this.setSelectionEnd(end);
    }

    public final void setComposition$ui_text(int start2, int end) {
        if (start2 < 0 || start2 > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start2 + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start2 >= end) {
            throw new IllegalArgumentException("Do not set reversed or empty range: " + start2 + " > " + end);
        }
        this.compositionStart = start2;
        this.compositionEnd = end;
    }

    public final void cancelComposition$ui_text() {
        this.replace$ui_text(this.compositionStart, this.compositionEnd, "");
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void commitComposition$ui_text() {
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    @NotNull
    public String toString() {
        return this.gapBuffer.toString();
    }

    @NotNull
    public final AnnotatedString toAnnotatedString$ui_text() {
        return new AnnotatedString(this.toString(), null, 2, null);
    }

    public /* synthetic */ EditingBuffer(AnnotatedString text, long selection, DefaultConstructorMarker $constructor_marker) {
        this(text, selection);
    }

    public /* synthetic */ EditingBuffer(String text, long selection, DefaultConstructorMarker $constructor_marker) {
        this(text, selection);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/compose/ui/text/input/EditingBuffer$Companion;", "", "<init>", "()V", "NOWHERE", "", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

