/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Landroidx/compose/ui/text/input/SetComposingTextCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "annotatedString", "Landroidx/compose/ui/text/AnnotatedString;", "newCursorPosition", "", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;I)V", "text", "", "(Ljava/lang/String;I)V", "getAnnotatedString", "()Landroidx/compose/ui/text/AnnotatedString;", "getNewCursorPosition", "()I", "getText", "()Ljava/lang/String;", "applyTo", "", "buffer", "Landroidx/compose/ui/text/input/EditingBuffer;", "equals", "", "other", "", "hashCode", "toString", "ui-text"})
@StabilityInferred(parameters=1)
public final class SetComposingTextCommand
implements EditCommand {
    @NotNull
    private final AnnotatedString annotatedString;
    private final int newCursorPosition;
    public static final int $stable;

    public SetComposingTextCommand(@NotNull AnnotatedString annotatedString, int newCursorPosition) {
        Intrinsics.checkNotNullParameter(annotatedString, "annotatedString");
        this.annotatedString = annotatedString;
        this.newCursorPosition = newCursorPosition;
    }

    @NotNull
    public final AnnotatedString getAnnotatedString() {
        return this.annotatedString;
    }

    public final int getNewCursorPosition() {
        return this.newCursorPosition;
    }

    public SetComposingTextCommand(@NotNull String text, int newCursorPosition) {
        Intrinsics.checkNotNullParameter(text, "text");
        this(new AnnotatedString(text, null, 2, null), newCursorPosition);
    }

    @NotNull
    public final String getText() {
        return this.annotatedString.getText();
    }

    @Override
    public void applyTo(@NotNull EditingBuffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        if (buffer.hasComposition$ui_text()) {
            int compositionStart = buffer.getCompositionStart$ui_text();
            buffer.replace$ui_text(buffer.getCompositionStart$ui_text(), buffer.getCompositionEnd$ui_text(), this.getText());
            if (((CharSequence)this.getText()).length() > 0) {
                buffer.setComposition$ui_text(compositionStart, compositionStart + this.getText().length());
            }
        } else {
            int selectionStart = buffer.getSelectionStart$ui_text();
            buffer.replace$ui_text(buffer.getSelectionStart$ui_text(), buffer.getSelectionEnd$ui_text(), this.getText());
            if (((CharSequence)this.getText()).length() > 0) {
                buffer.setComposition$ui_text(selectionStart, selectionStart + this.getText().length());
            }
        }
        int newCursor = buffer.getCursor$ui_text();
        int newCursorInBuffer = this.newCursorPosition > 0 ? newCursor + this.newCursorPosition - 1 : newCursor + this.newCursorPosition - this.getText().length();
        buffer.setCursor$ui_text(RangesKt.coerceIn(newCursorInBuffer, 0, buffer.getLength$ui_text()));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetComposingTextCommand)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getText(), ((SetComposingTextCommand)other).getText())) {
            return false;
        }
        return this.newCursorPosition == ((SetComposingTextCommand)other).newCursorPosition;
    }

    public int hashCode() {
        int result2 = this.getText().hashCode();
        result2 = 31 * result2 + this.newCursorPosition;
        return result2;
    }

    @NotNull
    public String toString() {
        return "SetComposingTextCommand(text='" + this.getText() + "', newCursorPosition=" + this.newCursorPosition + ")";
    }
}

