/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.navigation.NavUri;
import androidx.navigation.internal.InternalUri;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\n\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Landroidx/navigation/ActualUri;", "Landroidx/navigation/NavUri;", "uriString", "", "<init>", "(Ljava/lang/String;)V", "_query", "get_query", "()Ljava/lang/String;", "_query$delegate", "Lkotlin/Lazy;", "_fragment", "get_fragment", "_fragment$delegate", "schemeSeparatorIndex", "", "getSchemeSeparatorIndex", "()I", "schemeSeparatorIndex$delegate", "_pathSegments", "", "get_pathSegments", "()Ljava/util/List;", "_pathSegments$delegate", "getFragment", "getQuery", "getPathSegments", "isHierarchical", "", "getQueryParameters", "key", "getQueryParameterNames", "", "toString", "Companion", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nNavUri.nonAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavUri.nonAndroid.kt\nandroidx/navigation/ActualUri\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1617#2,9:110\n1869#2:119\n1870#2:121\n1626#2:122\n1563#2:123\n1634#2,3:124\n1563#2:127\n1634#2,3:128\n1#3:120\n*S KotlinDebug\n*F\n+ 1 NavUri.nonAndroid.kt\nandroidx/navigation/ActualUri\n*L\n86#1:110,9\n86#1:119\n86#1:121\n86#1:122\n100#1:123\n100#1:124,3\n64#1:127\n64#1:128,3\n86#1:120\n*E\n"})
final class ActualUri
extends NavUri {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String uriString;
    @NotNull
    private final Lazy _query$delegate;
    @NotNull
    private final Lazy _fragment$delegate;
    @NotNull
    private final Lazy schemeSeparatorIndex$delegate;
    @NotNull
    private final Lazy _pathSegments$delegate;
    @NotNull
    private static final Regex QUERY_PATTERN = new Regex("^[^?#]+\\?([^#]*).*");
    @NotNull
    private static final Regex FRAGMENT_PATTERN = new Regex("#(.+)");

    public ActualUri(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter(uriString, "uriString");
        this.uriString = uriString;
        this._query$delegate = LazyKt.lazy(() -> ActualUri._query_delegate$lambda$0(this));
        this._fragment$delegate = LazyKt.lazy(() -> ActualUri._fragment_delegate$lambda$1(this));
        this.schemeSeparatorIndex$delegate = LazyKt.lazy(() -> ActualUri.schemeSeparatorIndex_delegate$lambda$2(this));
        this._pathSegments$delegate = LazyKt.lazy(() -> ActualUri._pathSegments_delegate$lambda$4(this));
    }

    private final String get_query() {
        Lazy lazy = this._query$delegate;
        return (String)lazy.getValue();
    }

    private final String get_fragment() {
        Lazy lazy = this._fragment$delegate;
        return (String)lazy.getValue();
    }

    private final int getSchemeSeparatorIndex() {
        Lazy lazy = this.schemeSeparatorIndex$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final List<String> get_pathSegments() {
        Lazy lazy = this._pathSegments$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @Nullable
    public String getFragment() {
        return this.get_fragment();
    }

    @Override
    @Nullable
    public String getQuery() {
        return this.get_query();
    }

    @Override
    @NotNull
    public List<String> getPathSegments() {
        return this.get_pathSegments();
    }

    private final boolean isHierarchical() {
        if (this.getSchemeSeparatorIndex() == -1) {
            return true;
        }
        if (this.uriString.length() == this.getSchemeSeparatorIndex() + 1) {
            return false;
        }
        return this.uriString.charAt(this.getSchemeSeparatorIndex() + 1) == '/';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getQueryParameters(@NotNull String key) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(key, "key");
        if (!this.isHierarchical()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = this.get_query();
        if (string3 == null) {
            return CollectionsKt.emptyList();
        }
        String query = string3;
        String encodedKey = InternalUri.encode$default(InternalUri.INSTANCE, key, null, 2, null);
        char[] cArray = new char[]{'&'};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)query, cArray, false, 0, 6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string4;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            int i2 = StringsKt.indexOf$default((CharSequence)it, '=', 0, false, 6, null);
            if (i2 == -1) {
                string4 = Intrinsics.areEqual(it, encodedKey) ? "" : null;
            } else {
                String string5 = it.substring(0, i2);
                Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                if (Intrinsics.areEqual(string5, encodedKey)) {
                    String string6 = it.substring(i2 + 1);
                    Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
                    string4 = InternalUri.INSTANCE.decode(string6);
                } else {
                    string4 = null;
                }
            }
            if (string4 == null) continue;
            String it$iv$iv = string4;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getQueryParameterNames() {
        void $this$mapTo$iv$iv;
        if (!this.isHierarchical()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = this.get_query();
        if (string3 == null) {
            return SetsKt.emptySet();
        }
        String query = string3;
        char[] cArray = new char[]{'&'};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)query, cArray, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string4;
            void it;
            String string5 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int index2 = StringsKt.indexOf$default((CharSequence)it, '=', 0, false, 6, null);
            if (index2 == -1) {
                string4 = it;
            } else {
                String string6 = it.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
                string4 = InternalUri.INSTANCE.decode(string6);
            }
            collection.add(string4);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    @NotNull
    public String toString() {
        return this.uriString;
    }

    private static final String _query_delegate$lambda$0(ActualUri this$0) {
        Object object = Regex.find$default(QUERY_PATTERN, this$0.uriString, 0, 2, null);
        return object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null ? ((MatchGroup)object).getValue() : null;
    }

    private static final String _fragment_delegate$lambda$1(ActualUri this$0) {
        Object object = Regex.find$default(FRAGMENT_PATTERN, this$0.uriString, 0, 2, null);
        return object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null ? ((MatchGroup)object).getValue() : null;
    }

    private static final int schemeSeparatorIndex_delegate$lambda$2(ActualUri this$0) {
        return StringsKt.indexOf$default((CharSequence)this$0.uriString, ':', 0, false, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List _pathSegments_delegate$lambda$4(ActualUri this$0) {
        void $this$mapTo$iv$iv;
        int ssi = this$0.getSchemeSeparatorIndex();
        if (ssi > -1) {
            if (ssi + 1 == this$0.uriString.length()) {
                return CollectionsKt.emptyList();
            }
            Character c = StringsKt.getOrNull(this$0.uriString, ssi + 1);
            char c2 = '/';
            if (c == null || c.charValue() != c2) {
                return CollectionsKt.emptyList();
            }
        }
        String path = InternalUri.INSTANCE.parsePath(this$0.uriString, ssi);
        char[] cArray = new char[]{'/'};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)path, cArray, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InternalUri.INSTANCE.decode((String)it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/navigation/ActualUri$Companion;", "", "<init>", "()V", "QUERY_PATTERN", "Lkotlin/text/Regex;", "FRAGMENT_PATTERN", "navigation-common"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

