/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.annotation.RestrictTo;
import androidx.navigation.NavType;
import androidx.savedstate.SavedState;
import androidx.savedstate.SavedStateReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB;\b\u0000\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u0013\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Landroidx/navigation/NavArgument;", "", "type", "Landroidx/navigation/NavType;", "isNullable", "", "defaultValue", "defaultValuePresent", "unknownDefaultValuePresent", "<init>", "(Landroidx/navigation/NavType;ZLjava/lang/Object;ZZ)V", "getType", "()Landroidx/navigation/NavType;", "()Z", "isDefaultValuePresent", "isDefaultValueUnknown", "isDefaultValueUnknown$navigation_common", "getDefaultValue", "()Ljava/lang/Object;", "putDefaultValue", "", "name", "", "bundle", "Landroidx/savedstate/SavedState;", "verify", "toString", "equals", "other", "hashCode", "", "Builder", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nNavArgument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavArgument.kt\nandroidx/navigation/NavArgument\n+ 2 SavedState.kt\nandroidx/savedstate/SavedStateKt__SavedStateKt\n*L\n1#1,239:1\n90#2:240\n*S KotlinDebug\n*F\n+ 1 NavArgument.kt\nandroidx/navigation/NavArgument\n*L\n86#1:240\n*E\n"})
public final class NavArgument {
    @NotNull
    private final NavType<Object> type;
    private final boolean isNullable;
    private final boolean isDefaultValuePresent;
    private final boolean isDefaultValueUnknown;
    @Nullable
    private final Object defaultValue;

    public NavArgument(@NotNull NavType<Object> type2, boolean isNullable, @Nullable Object defaultValue, boolean defaultValuePresent, boolean unknownDefaultValuePresent) {
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!(type2.isNullableAllowed() || !isNullable)) {
            boolean $i$a$-require-NavArgument$32 = false;
            String $i$a$-require-NavArgument$32 = type2.getName() + " does not allow nullable values";
            throw new IllegalArgumentException($i$a$-require-NavArgument$32.toString());
        }
        if (!(isNullable || !defaultValuePresent || defaultValue != null)) {
            boolean bl = false;
            String string2 = "Argument with type " + type2.getName() + " has null value but is not nullable.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.type = type2;
        this.isNullable = isNullable;
        this.defaultValue = defaultValue;
        this.isDefaultValuePresent = defaultValuePresent || unknownDefaultValuePresent;
        this.isDefaultValueUnknown = unknownDefaultValuePresent;
    }

    @NotNull
    public final NavType<Object> getType() {
        return this.type;
    }

    public final boolean isNullable() {
        return this.isNullable;
    }

    public final boolean isDefaultValuePresent() {
        return this.isDefaultValuePresent;
    }

    public final boolean isDefaultValueUnknown$navigation_common() {
        return this.isDefaultValueUnknown;
    }

    @Nullable
    public final Object getDefaultValue() {
        return this.defaultValue;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void putDefaultValue(@NotNull String name, @NotNull SavedState bundle) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        if (this.isDefaultValuePresent && this.defaultValue != null) {
            this.type.put(bundle, name, this.defaultValue);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean verify(@NotNull String name, @NotNull SavedState bundle) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        if (!this.isNullable) {
            SavedState $this$read$iv = bundle;
            boolean $i$f$read = false;
            SavedState $this$verify_u24lambda_u240 = SavedStateReader.constructor-impl($this$read$iv);
            boolean bl = false;
            boolean bl2 = SavedStateReader.contains-impl($this$verify_u24lambda_u240, name) && SavedStateReader.isNull-impl($this$verify_u24lambda_u240, name);
            if (bl2) {
                return false;
            }
        }
        try {
            this.type.get(bundle, name);
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        sb.append(" Type: " + this.type);
        sb.append(" Nullable: " + this.isNullable);
        if (this.isDefaultValuePresent) {
            sb.append(" DefaultValue: " + this.defaultValue);
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NavArgument that = (NavArgument)other;
        if (this.isNullable != that.isNullable) {
            return false;
        }
        if (this.isDefaultValuePresent != that.isDefaultValuePresent) {
            return false;
        }
        if (!Intrinsics.areEqual(this.type, that.type)) {
            return false;
        }
        return this.defaultValue != null ? Intrinsics.areEqual(this.defaultValue, that.defaultValue) : that.defaultValue == null;
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + (this.isNullable ? 1 : 0);
        result2 = 31 * result2 + (this.isDefaultValuePresent ? 1 : 0);
        Object object = this.defaultValue;
        result2 = 31 * result2 + (object != null ? object.hashCode() : 0);
        return result2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\u0000\"\u0004\b\u0000\u0010\f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\f0\u0005J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0001J\u0015\u0010\u000f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0010J\u0006\u0010\u0011\u001a\u00020\u0012R\u0018\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/navigation/NavArgument$Builder;", "", "<init>", "()V", "type", "Landroidx/navigation/NavType;", "isNullable", "", "defaultValue", "defaultValuePresent", "unknownDefaultValuePresent", "setType", "T", "setIsNullable", "setDefaultValue", "setUnknownDefaultValuePresent", "setUnknownDefaultValuePresent$navigation_common", "build", "Landroidx/navigation/NavArgument;", "navigation-common"})
    public static final class Builder {
        @Nullable
        private NavType<Object> type;
        private boolean isNullable;
        @Nullable
        private Object defaultValue;
        private boolean defaultValuePresent;
        private boolean unknownDefaultValuePresent;

        @NotNull
        public final <T> Builder setType(@NotNull NavType<T> type2) {
            Intrinsics.checkNotNullParameter(type2, "type");
            this.type = type2;
            return this;
        }

        @NotNull
        public final Builder setIsNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        @NotNull
        public final Builder setDefaultValue(@Nullable Object defaultValue) {
            this.defaultValue = defaultValue;
            this.defaultValuePresent = true;
            return this;
        }

        @NotNull
        public final Builder setUnknownDefaultValuePresent$navigation_common(boolean unknownDefaultValuePresent) {
            this.unknownDefaultValuePresent = unknownDefaultValuePresent;
            return this;
        }

        @NotNull
        public final NavArgument build() {
            NavType<Object> navType = this.type;
            if (navType == null) {
                NavType<Object> navType2 = NavType.Companion.inferFromValueType(this.defaultValue);
                navType = navType2;
                Intrinsics.checkNotNull(navType2, "null cannot be cast to non-null type androidx.navigation.NavType<kotlin.Any?>");
            }
            NavType<Object> finalType = navType;
            return new NavArgument(finalType, this.isNullable, this.defaultValue, this.defaultValuePresent, this.unknownDefaultValuePresent);
        }
    }
}

