/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.navigation.NavDestination;
import androidx.navigation.NavDestinationBuilder;
import androidx.navigation.NavDestinationDsl;
import androidx.navigation.NavGraph;
import androidx.navigation.NavGraphNavigator;
import androidx.navigation.NavType;
import androidx.navigation.NavigatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlinx.serialization.SerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NavDestinationDsl
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tBH\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\n\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n\u0012\u001b\u0010\u000b\u001a\u0017\u0012\u0004\u0012\u00020\r\u0012\r\u0012\u000b\u0012\u0002\b\u00030\u000e\u00a2\u0006\u0002\b\u000f0\f\u00a2\u0006\u0004\b\b\u0010\u0010BD\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0011\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n\u0012\u001b\u0010\u000b\u001a\u0017\u0012\u0004\u0012\u00020\r\u0012\r\u0012\u000b\u0012\u0002\b\u00030\u000e\u00a2\u0006\u0002\b\u000f0\f\u00a2\u0006\u0004\b\b\u0010\u0012J\u001e\u0010\u001d\u001a\u00020\u001e\"\b\b\u0000\u0010\u001f*\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0\u0001J\r\u0010!\u001a\u00020\u001e*\u00020\u001cH\u0086\u0002J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010#\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/navigation/NavGraphBuilder;", "Landroidx/navigation/NavDestinationBuilder;", "Landroidx/navigation/NavGraph;", "provider", "Landroidx/navigation/NavigatorProvider;", "startDestination", "", "route", "<init>", "(Landroidx/navigation/NavigatorProvider;Ljava/lang/String;Ljava/lang/String;)V", "Lkotlin/reflect/KClass;", "typeMap", "", "Lkotlin/reflect/KType;", "Landroidx/navigation/NavType;", "Lkotlin/jvm/JvmSuppressWildcards;", "(Landroidx/navigation/NavigatorProvider;Lkotlin/reflect/KClass;Lkotlin/reflect/KClass;Ljava/util/Map;)V", "", "(Landroidx/navigation/NavigatorProvider;Ljava/lang/Object;Lkotlin/reflect/KClass;Ljava/util/Map;)V", "getProvider", "()Landroidx/navigation/NavigatorProvider;", "startDestinationId", "", "startDestinationRoute", "startDestinationClass", "startDestinationObject", "destinations", "", "Landroidx/navigation/NavDestination;", "destination", "", "D", "navDestination", "unaryPlus", "addDestination", "build", "navigation-common"})
@SourceDebugExtension(value={"SMAP\nNavGraphBuilder.nonAndroid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavGraphBuilder.nonAndroid.kt\nandroidx/navigation/NavGraphBuilder\n+ 2 NavigatorProvider.nonAndroid.kt\nandroidx/navigation/NavigatorProviderKt__NavigatorProvider_nonAndroidKt\n*L\n1#1,103:1\n105#2:104\n105#2:105\n105#2:106\n*S KotlinDebug\n*F\n+ 1 NavGraphBuilder.nonAndroid.kt\nandroidx/navigation/NavGraphBuilder\n*L\n37#1:104\n47#1:105\n57#1:106\n*E\n"})
public class NavGraphBuilder
extends NavDestinationBuilder<NavGraph> {
    @NotNull
    private final NavigatorProvider provider;
    private int startDestinationId;
    @Nullable
    private String startDestinationRoute;
    @Nullable
    private KClass<?> startDestinationClass;
    @Nullable
    private Object startDestinationObject;
    @NotNull
    private final List<NavDestination> destinations;

    @NotNull
    public final NavigatorProvider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - void declaration
     */
    public NavGraphBuilder(@NotNull NavigatorProvider provider, @NotNull String startDestination, @Nullable String route) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter(provider, "provider");
        Intrinsics.checkNotNullParameter(startDestination, "startDestination");
        NavigatorProvider navigatorProvider = provider;
        KClass clazz$iv = Reflection.getOrCreateKotlinClass(NavGraphNavigator.class);
        boolean $i$f$get = false;
        super($this$get$iv.getNavigator(clazz$iv), route);
        this.destinations = new ArrayList();
        this.provider = provider;
        this.startDestinationRoute = startDestination;
    }

    /*
     * WARNING - void declaration
     */
    public NavGraphBuilder(@NotNull NavigatorProvider provider, @NotNull KClass<?> startDestination, @Nullable KClass<?> route, @NotNull Map<KType, NavType<?>> typeMap) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter(provider, "provider");
        Intrinsics.checkNotNullParameter(startDestination, "startDestination");
        Intrinsics.checkNotNullParameter(typeMap, "typeMap");
        NavigatorProvider navigatorProvider = provider;
        KClass clazz$iv = Reflection.getOrCreateKotlinClass(NavGraphNavigator.class);
        boolean $i$f$get = false;
        super($this$get$iv.getNavigator(clazz$iv), route, typeMap);
        this.destinations = new ArrayList();
        this.provider = provider;
        this.startDestinationClass = startDestination;
    }

    /*
     * WARNING - void declaration
     */
    public NavGraphBuilder(@NotNull NavigatorProvider provider, @NotNull Object startDestination, @Nullable KClass<?> route, @NotNull Map<KType, NavType<?>> typeMap) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter(provider, "provider");
        Intrinsics.checkNotNullParameter(startDestination, "startDestination");
        Intrinsics.checkNotNullParameter(typeMap, "typeMap");
        NavigatorProvider navigatorProvider = provider;
        KClass clazz$iv = Reflection.getOrCreateKotlinClass(NavGraphNavigator.class);
        boolean $i$f$get = false;
        super($this$get$iv.getNavigator(clazz$iv), route, typeMap);
        this.destinations = new ArrayList();
        this.provider = provider;
        this.startDestinationObject = startDestination;
    }

    public final <D extends NavDestination> void destination(@NotNull NavDestinationBuilder<? extends D> navDestination) {
        Intrinsics.checkNotNullParameter(navDestination, "navDestination");
        ((Collection)this.destinations).add(navDestination.build());
    }

    public final void unaryPlus(@NotNull NavDestination $this$unaryPlus) {
        Intrinsics.checkNotNullParameter($this$unaryPlus, "<this>");
        this.addDestination($this$unaryPlus);
    }

    public final void addDestination(@NotNull NavDestination destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        ((Collection)this.destinations).add(destination);
    }

    @Override
    @NotNull
    public NavGraph build() {
        Object d = super.build();
        NavGraph navGraph = (NavGraph)d;
        boolean bl = false;
        navGraph.addDestinations((Collection<? extends NavDestination>)this.destinations);
        if (this.startDestinationId == 0 && this.startDestinationRoute == null && this.startDestinationClass == null && this.startDestinationObject == null) {
            if (this.getRoute() != null) {
                throw new IllegalStateException("You must set a start destination route");
            }
            throw new IllegalStateException("You must set a start destination id");
        }
        if (this.startDestinationRoute != null) {
            String string2 = this.startDestinationRoute;
            Intrinsics.checkNotNull(string2);
            navGraph.setStartDestination(string2);
        } else if (this.startDestinationClass != null) {
            KClass<?> kClass = this.startDestinationClass;
            Intrinsics.checkNotNull(kClass);
            navGraph.setStartDestination(SerializersKt.serializer(kClass), NavGraphBuilder::build$lambda$1$lambda$0);
        } else if (this.startDestinationObject != null) {
            Object object = this.startDestinationObject;
            Intrinsics.checkNotNull(object);
            navGraph.setStartDestination(object);
        } else {
            navGraph.setStartDestination(this.startDestinationId);
        }
        return (NavGraph)d;
    }

    private static final String build$lambda$1$lambda$0(NavDestination it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string2 = it.getRoute();
        Intrinsics.checkNotNull(string2);
        return string2;
    }
}

