/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.annotation.RestrictTo;
import androidx.paging.LegacyPageFetcher;
import androidx.paging.LoadState;
import androidx.paging.LoadType;
import androidx.paging.PagedList;
import androidx.paging.PagedStorage;
import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010 \n\u0002\b\u0004\b\u0017\u0018\u0000 X*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u00052\b\u0012\u0004\u0012\u0002H\u00030\u0006:\u0001XBg\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0015J%\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b4J\b\u00105\u001a\u000200H\u0016J\u0018\u00106\u001a\u0002002\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bH\u0002J\"\u00109\u001a\u0002002\u0018\u0010:\u001a\u0014\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002000;H\u0016J\u0010\u0010>\u001a\u0002002\u0006\u0010?\u001a\u00020\u0017H\u0017J\u0010\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020\u0017H\u0017J \u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020\u0017H\u0017J \u0010F\u001a\u0002002\u0006\u0010G\u001a\u00020\u00172\u0006\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020\u0017H\u0017J\"\u0010H\u001a\u00020\u001b2\u0006\u0010I\u001a\u00020<2\u0010\u0010J\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0018\u0010K\u001a\u0002002\u0006\u0010L\u001a\u00020\u00172\u0006\u0010A\u001a\u00020\u0017H\u0016J\u0018\u0010M\u001a\u0002002\u0006\u0010L\u001a\u00020\u00172\u0006\u0010A\u001a\u00020\u0017H\u0016J\u0018\u0010N\u001a\u0002002\u0006\u0010I\u001a\u00020<2\u0006\u0010O\u001a\u00020=H\u0016J\b\u0010P\u001a\u000200H\u0016J\u0018\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u00020<2\u0006\u0010S\u001a\u00020=H\u0016J\u001e\u0010T\u001a\u0002002\u0006\u0010I\u001a\u00020<2\f\u0010J\u001a\b\u0012\u0004\u0012\u00028\u00010UH\u0002J\u0010\u0010V\u001a\u0002002\u0006\u0010W\u001a\u00020\u001bH\u0002R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00018\u00008VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010(X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b)\u0010#R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Landroidx/paging/ContiguousPagedList;", "K", "", "V", "Landroidx/paging/PagedList;", "Landroidx/paging/PagedStorage$Callback;", "Landroidx/paging/LegacyPageFetcher$PageConsumer;", "pagingSource", "Landroidx/paging/PagingSource;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "notifyDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "backgroundDispatcher", "boundaryCallback", "Landroidx/paging/PagedList$BoundaryCallback;", "config", "Landroidx/paging/PagedList$Config;", "initialPage", "Landroidx/paging/PagingSource$LoadResult$Page;", "initialLastKey", "(Landroidx/paging/PagingSource;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlinx/coroutines/CoroutineDispatcher;Landroidx/paging/PagedList$BoundaryCallback;Landroidx/paging/PagedList$Config;Landroidx/paging/PagingSource$LoadResult$Page;Ljava/lang/Object;)V", "appendItemsRequested", "", "getBoundaryCallback$paging_common", "()Landroidx/paging/PagedList$BoundaryCallback;", "boundaryCallbackBeginDeferred", "", "boundaryCallbackEndDeferred", "highestIndexAccessed", "Ljava/lang/Object;", "isDetached", "()Z", "lastKey", "getLastKey$annotations", "()V", "getLastKey", "()Ljava/lang/Object;", "lowestIndexAccessed", "pager", "Landroidx/paging/LegacyPageFetcher;", "getPager$annotations", "getPagingSource", "()Landroidx/paging/PagingSource;", "prependItemsRequested", "replacePagesWithNulls", "shouldTrim", "deferBoundaryCallbacks", "", "deferEmpty", "deferBegin", "deferEnd", "deferBoundaryCallbacks$paging_common", "detach", "dispatchBoundaryCallbacks", "begin", "end", "dispatchCurrentLoadState", "callback", "Lkotlin/Function2;", "Landroidx/paging/LoadType;", "Landroidx/paging/LoadState;", "loadAroundInternal", "index", "onInitialized", "count", "onPageAppended", "endPosition", "changed", "added", "onPagePrepended", "leadingNulls", "onPageResult", "type", "page", "onPagesRemoved", "startOfDrops", "onPagesSwappedToPlaceholder", "onStateChanged", "state", "retry", "setInitialLoadState", "loadType", "loadState", "triggerBoundaryCallback", "", "tryDispatchBoundaryCallbacks", "post", "Companion", "paging-common"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@SourceDebugExtension(value={"SMAP\nContiguousPagedList.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContiguousPagedList.jvm.kt\nandroidx/paging/ContiguousPagedList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,408:1\n1#2:409\n*E\n"})
public class ContiguousPagedList<K, V>
extends PagedList<V>
implements PagedStorage.Callback,
LegacyPageFetcher.PageConsumer<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PagingSource<K, V> pagingSource;
    @Nullable
    private final PagedList.BoundaryCallback<V> boundaryCallback;
    @Nullable
    private final K initialLastKey;
    private int prependItemsRequested;
    private int appendItemsRequested;
    private boolean boundaryCallbackBeginDeferred;
    private boolean boundaryCallbackEndDeferred;
    private int lowestIndexAccessed;
    private int highestIndexAccessed;
    private boolean replacePagesWithNulls;
    private final boolean shouldTrim;
    @NotNull
    private final LegacyPageFetcher<K, V> pager;

    public ContiguousPagedList(@NotNull PagingSource<K, V> pagingSource, @NotNull CoroutineScope coroutineScope, @NotNull CoroutineDispatcher notifyDispatcher, @NotNull CoroutineDispatcher backgroundDispatcher, @Nullable PagedList.BoundaryCallback<V> boundaryCallback, @NotNull PagedList.Config config2, @NotNull PagingSource.LoadResult.Page<K, V> initialPage, @Nullable K initialLastKey) {
        Intrinsics.checkNotNullParameter(pagingSource, "pagingSource");
        Intrinsics.checkNotNullParameter(coroutineScope, "coroutineScope");
        Intrinsics.checkNotNullParameter(notifyDispatcher, "notifyDispatcher");
        Intrinsics.checkNotNullParameter(backgroundDispatcher, "backgroundDispatcher");
        Intrinsics.checkNotNullParameter(config2, "config");
        Intrinsics.checkNotNullParameter(initialPage, "initialPage");
        super(pagingSource, coroutineScope, notifyDispatcher, new PagedStorage(), config2);
        this.pagingSource = pagingSource;
        this.boundaryCallback = boundaryCallback;
        this.initialLastKey = initialLastKey;
        this.lowestIndexAccessed = Integer.MAX_VALUE;
        this.highestIndexAccessed = Integer.MIN_VALUE;
        this.shouldTrim = config2.maxSize != Integer.MAX_VALUE;
        LegacyPageFetcher.PageConsumer pageConsumer = this;
        PagedStorage pagedStorage = this.getStorage$paging_common();
        Intrinsics.checkNotNull(pagedStorage, "null cannot be cast to non-null type androidx.paging.LegacyPageFetcher.KeyProvider<K of androidx.paging.ContiguousPagedList>");
        this.pager = new LegacyPageFetcher<K, V>(coroutineScope, config2, this.pagingSource, notifyDispatcher, backgroundDispatcher, pageConsumer, pagedStorage);
        if (config2.enablePlaceholders) {
            this.getStorage$paging_common().init(initialPage.getItemsBefore() != Integer.MIN_VALUE ? initialPage.getItemsBefore() : 0, initialPage, initialPage.getItemsAfter() != Integer.MIN_VALUE ? initialPage.getItemsAfter() : 0, 0, this, initialPage.getItemsBefore() != Integer.MIN_VALUE && initialPage.getItemsAfter() != Integer.MIN_VALUE);
        } else {
            this.getStorage$paging_common().init(0, initialPage, 0, initialPage.getItemsBefore() != Integer.MIN_VALUE ? initialPage.getItemsBefore() : 0, this, false);
        }
        this.triggerBoundaryCallback(LoadType.REFRESH, initialPage.getData());
    }

    @Override
    @NotNull
    public final PagingSource<K, V> getPagingSource() {
        return this.pagingSource;
    }

    @Nullable
    public final PagedList.BoundaryCallback<V> getBoundaryCallback$paging_common() {
        return this.boundaryCallback;
    }

    private static /* synthetic */ void getPager$annotations() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public K getLastKey() {
        K k;
        PagingState pagingState = this.getStorage$paging_common().getRefreshKeyInfo(this.getConfig());
        if (pagingState != null) {
            PagingState it = pagingState;
            boolean bl = false;
            K k2 = this.pagingSource.getRefreshKey(it);
            if (k2 != null) {
                k = k2;
                return k;
            }
        }
        k = this.initialLastKey;
        return k;
    }

    public static /* synthetic */ void getLastKey$annotations() {
    }

    @Override
    public boolean isDetached() {
        return this.pager.isDetached();
    }

    @Override
    public boolean onPageResult(@NotNull LoadType type2, @NotNull PagingSource.LoadResult.Page<?, V> page) {
        boolean skipNewPage;
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(page, "page");
        boolean continueLoading = false;
        List<V> list2 = page.getData();
        boolean trimFromFront = this.lastLoad() > this.getStorage$paging_common().getMiddleOfLoadedRange();
        boolean bl = skipNewPage = this.shouldTrim && this.getStorage$paging_common().shouldPreTrimNewPage(this.getConfig().maxSize, this.getRequiredRemainder$paging_common(), list2.size());
        if (type2 == LoadType.APPEND) {
            if (skipNewPage && !trimFromFront) {
                this.appendItemsRequested = 0;
            } else {
                this.getStorage$paging_common().appendPage$paging_common(page, this);
                this.appendItemsRequested -= list2.size();
                if (this.appendItemsRequested > 0 && !((Collection)list2).isEmpty()) {
                    continueLoading = true;
                }
            }
        } else if (type2 == LoadType.PREPEND) {
            if (skipNewPage && trimFromFront) {
                this.prependItemsRequested = 0;
            } else {
                this.getStorage$paging_common().prependPage$paging_common(page, this);
                this.prependItemsRequested -= list2.size();
                if (this.prependItemsRequested > 0 && !((Collection)list2).isEmpty()) {
                    continueLoading = true;
                }
            }
        } else {
            throw new IllegalArgumentException("unexpected result type " + (Object)((Object)type2));
        }
        if (this.shouldTrim) {
            if (trimFromFront) {
                if (!(this.pager.getLoadStateManager().getStartState() instanceof LoadState.Loading) && this.getStorage$paging_common().trimFromFront$paging_common(this.replacePagesWithNulls, this.getConfig().maxSize, this.getRequiredRemainder$paging_common(), this)) {
                    this.pager.getLoadStateManager().setState(LoadType.PREPEND, LoadState.NotLoading.Companion.getIncomplete$paging_common());
                }
            } else if (!(this.pager.getLoadStateManager().getEndState() instanceof LoadState.Loading) && this.getStorage$paging_common().trimFromEnd$paging_common(this.replacePagesWithNulls, this.getConfig().maxSize, this.getRequiredRemainder$paging_common(), this)) {
                this.pager.getLoadStateManager().setState(LoadType.APPEND, LoadState.NotLoading.Companion.getIncomplete$paging_common());
            }
        }
        this.triggerBoundaryCallback(type2, list2);
        return continueLoading;
    }

    @Override
    public void onStateChanged(@NotNull LoadType type2, @NotNull LoadState state2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(state2, "state");
        this.dispatchStateChangeAsync$paging_common(type2, state2);
    }

    private final void triggerBoundaryCallback(LoadType type2, List<? extends V> page) {
        if (this.boundaryCallback != null) {
            boolean deferEmpty = this.getStorage$paging_common().size() == 0;
            boolean deferBegin = !deferEmpty && type2 == LoadType.PREPEND && page.isEmpty();
            boolean deferEnd = !deferEmpty && type2 == LoadType.APPEND && page.isEmpty();
            this.deferBoundaryCallbacks$paging_common(deferEmpty, deferBegin, deferEnd);
        }
    }

    @AnyThread
    public final void deferBoundaryCallbacks$paging_common(boolean deferEmpty, boolean deferBegin, boolean deferEnd) {
        if (this.boundaryCallback == null) {
            throw new IllegalStateException("Can't defer BoundaryCallback, no instance");
        }
        if (this.lowestIndexAccessed == Integer.MAX_VALUE) {
            this.lowestIndexAccessed = this.getStorage$paging_common().size();
        }
        if (this.highestIndexAccessed == Integer.MIN_VALUE) {
            this.highestIndexAccessed = 0;
        }
        if (deferEmpty || deferBegin || deferEnd) {
            BuildersKt.launch$default(this.getCoroutineScope$paging_common(), this.getNotifyDispatcher$paging_common(), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(deferEmpty, this, deferBegin, deferEnd, null){
                int label;
                final /* synthetic */ boolean $deferEmpty;
                final /* synthetic */ ContiguousPagedList<K, V> this$0;
                final /* synthetic */ boolean $deferBegin;
                final /* synthetic */ boolean $deferEnd;
                {
                    this.$deferEmpty = $deferEmpty;
                    this.this$0 = $receiver;
                    this.$deferBegin = $deferBegin;
                    this.$deferEnd = $deferEnd;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            if (this.$deferEmpty) {
                                this.this$0.getBoundaryCallback$paging_common().onZeroItemsLoaded();
                            }
                            if (this.$deferBegin) {
                                ContiguousPagedList.access$setBoundaryCallbackBeginDeferred$p(this.this$0, true);
                            }
                            if (this.$deferEnd) {
                                ContiguousPagedList.access$setBoundaryCallbackEndDeferred$p(this.this$0, true);
                            }
                            ContiguousPagedList.access$tryDispatchBoundaryCallbacks(this.this$0, false);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 2, null);
        }
    }

    private final void tryDispatchBoundaryCallbacks(boolean post2) {
        boolean dispatchEnd;
        boolean dispatchBegin = this.boundaryCallbackBeginDeferred && this.lowestIndexAccessed <= this.getConfig().prefetchDistance;
        boolean bl = dispatchEnd = this.boundaryCallbackEndDeferred && this.highestIndexAccessed >= this.size() - 1 - this.getConfig().prefetchDistance;
        if (!dispatchBegin && !dispatchEnd) {
            return;
        }
        if (dispatchBegin) {
            this.boundaryCallbackBeginDeferred = false;
        }
        if (dispatchEnd) {
            this.boundaryCallbackEndDeferred = false;
        }
        if (post2) {
            BuildersKt.launch$default(this.getCoroutineScope$paging_common(), this.getNotifyDispatcher$paging_common(), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, dispatchBegin, dispatchEnd, null){
                int label;
                final /* synthetic */ ContiguousPagedList<K, V> this$0;
                final /* synthetic */ boolean $dispatchBegin;
                final /* synthetic */ boolean $dispatchEnd;
                {
                    this.this$0 = $receiver;
                    this.$dispatchBegin = $dispatchBegin;
                    this.$dispatchEnd = $dispatchEnd;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            ContiguousPagedList.access$dispatchBoundaryCallbacks(this.this$0, this.$dispatchBegin, this.$dispatchEnd);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 2, null);
        } else {
            this.dispatchBoundaryCallbacks(dispatchBegin, dispatchEnd);
        }
    }

    private final void dispatchBoundaryCallbacks(boolean begin, boolean end) {
        if (begin) {
            PagedList.BoundaryCallback<V> boundaryCallback = this.boundaryCallback;
            Intrinsics.checkNotNull(boundaryCallback);
            boundaryCallback.onItemAtFrontLoaded(this.getStorage$paging_common().getFirstLoadedItem$paging_common());
        }
        if (end) {
            PagedList.BoundaryCallback<V> boundaryCallback = this.boundaryCallback;
            Intrinsics.checkNotNull(boundaryCallback);
            boundaryCallback.onItemAtEndLoaded(this.getStorage$paging_common().getLastLoadedItem$paging_common());
        }
    }

    @Override
    public void retry() {
        block1: {
            super.retry();
            this.pager.retry();
            LoadState $this$retry_u24lambda_u241 = this.pager.getLoadStateManager().getRefreshState();
            boolean bl = false;
            if (!($this$retry_u24lambda_u241 instanceof LoadState.Error)) break block1;
            Runnable runnable2 = this.getRefreshRetryCallback$paging_common();
            if (runnable2 != null) {
                runnable2.run();
            }
        }
    }

    @Override
    public void dispatchCurrentLoadState(@NotNull Function2<? super LoadType, ? super LoadState, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, "callback");
        this.pager.getLoadStateManager().dispatchCurrentLoadState(callback);
    }

    @Override
    public void setInitialLoadState(@NotNull LoadType loadType, @NotNull LoadState loadState) {
        Intrinsics.checkNotNullParameter((Object)loadType, "loadType");
        Intrinsics.checkNotNullParameter(loadState, "loadState");
        this.pager.getLoadStateManager().setState(loadType, loadState);
    }

    @Override
    @MainThread
    public void loadAroundInternal(int index2) {
        int prependItems = Companion.getPrependItemsRequested$paging_common(this.getConfig().prefetchDistance, index2, this.getStorage$paging_common().getPlaceholdersBefore());
        int appendItems = Companion.getAppendItemsRequested$paging_common(this.getConfig().prefetchDistance, index2, this.getStorage$paging_common().getPlaceholdersBefore() + this.getStorage$paging_common().getStorageCount());
        this.prependItemsRequested = Math.max(prependItems, this.prependItemsRequested);
        if (this.prependItemsRequested > 0) {
            this.pager.trySchedulePrepend();
        }
        this.appendItemsRequested = Math.max(appendItems, this.appendItemsRequested);
        if (this.appendItemsRequested > 0) {
            this.pager.tryScheduleAppend();
        }
        this.lowestIndexAccessed = Math.min(this.lowestIndexAccessed, index2);
        this.highestIndexAccessed = Math.max(this.highestIndexAccessed, index2);
        this.tryDispatchBoundaryCallbacks(true);
    }

    @Override
    public void detach() {
        this.pager.detach();
    }

    @Override
    @MainThread
    public void onInitialized(int count2) {
        this.notifyInserted$paging_common(0, count2);
        this.replacePagesWithNulls = this.getStorage$paging_common().getPlaceholdersBefore() > 0 || this.getStorage$paging_common().getPlaceholdersAfter() > 0;
    }

    @Override
    @MainThread
    public void onPagePrepended(int leadingNulls, int changed, int added) {
        this.notifyChanged(leadingNulls, changed);
        this.notifyInserted$paging_common(0, added);
        this.lowestIndexAccessed += added;
        this.highestIndexAccessed += added;
    }

    @Override
    @MainThread
    public void onPageAppended(int endPosition, int changed, int added) {
        this.notifyChanged(endPosition, changed);
        this.notifyInserted$paging_common(endPosition + changed, added);
    }

    @Override
    public void onPagesRemoved(int startOfDrops, int count2) {
        this.notifyRemoved(startOfDrops, count2);
    }

    @Override
    public void onPagesSwappedToPlaceholder(int startOfDrops, int count2) {
        this.notifyChanged(startOfDrops, count2);
    }

    public static final /* synthetic */ void access$setBoundaryCallbackBeginDeferred$p(ContiguousPagedList $this, boolean bl) {
        $this.boundaryCallbackBeginDeferred = bl;
    }

    public static final /* synthetic */ void access$setBoundaryCallbackEndDeferred$p(ContiguousPagedList $this, boolean bl) {
        $this.boundaryCallbackEndDeferred = bl;
    }

    public static final /* synthetic */ void access$tryDispatchBoundaryCallbacks(ContiguousPagedList $this, boolean post2) {
        $this.tryDispatchBoundaryCallbacks(post2);
    }

    public static final /* synthetic */ void access$dispatchBoundaryCallbacks(ContiguousPagedList $this, boolean begin, boolean end) {
        $this.dispatchBoundaryCallbacks(begin, end);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\bJ%\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Landroidx/paging/ContiguousPagedList$Companion;", "", "()V", "getAppendItemsRequested", "", "prefetchDistance", "index", "itemsBeforeTrailingNulls", "getAppendItemsRequested$paging_common", "getPrependItemsRequested", "leadingNulls", "getPrependItemsRequested$paging_common", "paging-common"})
    public static final class Companion {
        private Companion() {
        }

        public final int getPrependItemsRequested$paging_common(int prefetchDistance, int index2, int leadingNulls) {
            return prefetchDistance - (index2 - leadingNulls);
        }

        public final int getAppendItemsRequested$paging_common(int prefetchDistance, int index2, int itemsBeforeTrailingNulls) {
            return index2 + prefetchDistance + 1 - itemsBeforeTrailingNulls;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

