/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.fixed;

import com.ethlo.time.DateTime;
import com.ethlo.time.DateTimeParser;
import com.ethlo.time.Field;
import com.ethlo.time.ParseConfig;
import com.ethlo.time.TimezoneOffset;
import com.ethlo.time.internal.util.ArrayUtils;
import com.ethlo.time.internal.util.ErrorUtil;
import com.ethlo.time.internal.util.LimitedCharArrayIntegerUtil;
import java.text.ParsePosition;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.Arrays;

public class ITUParser
implements DateTimeParser {
    public static final char DATE_SEPARATOR = '-';
    public static final char TIME_SEPARATOR = ':';
    public static final char SEPARATOR_UPPER = 'T';
    public static final char SEPARATOR_LOWER = 't';
    public static final char SEPARATOR_SPACE = ' ';
    public static final char PLUS = '+';
    public static final char MINUS = '-';
    public static final char FRACTION_SEPARATOR = '.';
    public static final char ZULU_UPPER = 'Z';
    public static final char ZULU_LOWER = 'z';
    public static final int MAX_FRACTION_DIGITS = 9;
    public static final int RADIX = 10;
    public static final int DIGITS_IN_NANO = 9;
    private static final DateTimeParser instance = new ITUParser();

    private ITUParser() {
    }

    private static DateTime handleTime(int offset, ParseConfig parseConfig, String chars, int year2, int month2, int day2, int hour2, int minute2) {
        switch (chars.charAt(offset + 16)) {
            case ':': {
                return ITUParser.handleTimeResolution(offset, parseConfig, year2, month2, day2, hour2, minute2, chars);
            }
            case '+': 
            case '-': 
            case 'Z': 
            case 'z': {
                TimezoneOffset zoneOffset = ITUParser.parseTimezone(offset, parseConfig, chars, offset + 16);
                int charLength = Field.MINUTE.getRequiredLength() + (zoneOffset != null ? zoneOffset.getRequiredLength() : 0);
                return new DateTime(Field.MINUTE, year2, month2, day2, hour2, minute2, 0, 0, zoneOffset, 0, charLength);
            }
        }
        throw ErrorUtil.raiseUnexpectedCharacter(chars, offset + 16, ':', 'Z', 'z', '+', '-');
    }

    private static void assertAllowedDateTimeSeparator(int offset, String chars, ParseConfig config2) {
        int index2 = offset + 10;
        char needle = chars.charAt(index2);
        if (!config2.isDateTimeSeparator(needle)) {
            String allowedCharStr = config2.getDateTimeSeparators().length > 1 ? Arrays.toString(config2.getDateTimeSeparators()) : Character.toString(config2.getDateTimeSeparators()[0]);
            throw new DateTimeParseException(String.format("Expected character %s at position %d, found %s: %s", allowedCharStr, index2 + 1, Character.valueOf(chars.charAt(index2)), chars), chars, index2);
        }
    }

    private static TimezoneOffset parseTimezone(int offset, ParseConfig parseConfig, String chars, int idx) {
        if (idx >= chars.length()) {
            return null;
        }
        int len = chars.length();
        int left = len - idx;
        char c = chars.charAt(idx);
        if (c == 'Z' || c == 'z') {
            ITUParser.assertNoMoreChars(offset, parseConfig, chars, idx);
            return TimezoneOffset.UTC;
        }
        char sign2 = chars.charAt(idx);
        if (sign2 != '+' && sign2 != '-') {
            ErrorUtil.raiseUnexpectedCharacter(chars, idx, 'Z', 'z', '+', '-');
        }
        if (left < 6) {
            throw new DateTimeParseException(String.format("Invalid timezone offset: %s", chars), chars, idx);
        }
        int hours = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, idx + 1, idx + 3);
        int minutes = LimitedCharArrayIntegerUtil.parsePositiveInt(chars, idx + 4, idx + 4 + 2);
        if (sign2 == '-') {
            hours = -hours;
            minutes = -minutes;
            if (hours == 0 && minutes == 0) {
                throw new DateTimeParseException("Unknown 'Local Offset Convention' date-time not allowed", chars, idx);
            }
        }
        ITUParser.assertNoMoreChars(offset, parseConfig, chars, idx + 5);
        return TimezoneOffset.ofHoursMinutes(hours, minutes);
    }

    private static void assertNoMoreChars(int offset, ParseConfig parseConfig, String chars, int lastUsed) {
        if (parseConfig.isFailOnTrailingJunk() && offset == 0 && chars.length() > lastUsed + 1) {
            throw new DateTimeParseException(String.format("Trailing junk data after position %d: %s", lastUsed + 2, chars), chars, lastUsed + 1);
        }
    }

    public static DateTime parseLenient(String chars, ParseConfig parseConfig, int offset) {
        if (chars == null) {
            throw new NullPointerException("text cannot be null");
        }
        int availableLength = chars.length() - offset;
        if (availableLength < 0) {
            throw new IndexOutOfBoundsException(String.format("offset is %d which is equal to or larger than the input length of %d", offset, chars.length()));
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(String.format("offset cannot be negative, was %d", offset));
        }
        int years = ITUParser.parseYears(chars, offset);
        if (4 == availableLength) {
            return new DateTime(Field.YEAR, years, 0, 0, 0, 0, 0, 0, null, 0, availableLength);
        }
        ErrorUtil.assertPositionContains(Field.MONTH, chars, offset + 4, '-');
        int month2 = ITUParser.parseMonth(chars, offset);
        if (7 == availableLength) {
            return new DateTime(Field.MONTH, years, month2, 0, 0, 0, 0, 0, null, 0, availableLength);
        }
        ErrorUtil.assertPositionContains(Field.DAY, chars, offset + 7, '-');
        int days = ITUParser.parseDays(chars, offset);
        if (10 == availableLength) {
            return new DateTime(Field.DAY, years, month2, days, 0, 0, 0, 0, null, 0, availableLength);
        }
        ITUParser.assertAllowedDateTimeSeparator(offset, chars, parseConfig);
        int hours = ITUParser.parseHours(chars, offset);
        ErrorUtil.assertPositionContains(Field.MINUTE, chars, offset + 13, ':');
        int minutes = ITUParser.parseMinutes(chars, offset);
        if (availableLength == 16) {
            return new DateTime(Field.MINUTE, years, month2, days, hours, minutes, 0, 0, null, 0, 16);
        }
        return ITUParser.handleTime(offset, parseConfig, chars, years, month2, days, hours, minutes);
    }

    private static int parseSeconds(int offset, String chars) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 17, offset + 19);
    }

    private static int parseMinutes(String chars, int offset) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 14, offset + 16);
    }

    private static int parseHours(String chars, int offset) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 11, offset + 13);
    }

    private static int parseDays(String chars, int offset) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 8, offset + 10);
    }

    private static int parseMonth(String chars, int offset) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset + 5, offset + 7);
    }

    private static int parseYears(String chars, int offset) {
        return LimitedCharArrayIntegerUtil.parsePositiveInt(chars, offset, offset + 4);
    }

    private static DateTime handleTimeResolution(int offset, ParseConfig parseConfig, int year2, int month2, int day2, int hour2, int minute2, String chars) {
        int length = chars.length() - offset;
        if (length > 19) {
            char c = chars.charAt(offset + 19);
            if (parseConfig.isFractionSeparator(c)) {
                return ITUParser.handleFractionalSeconds(offset, parseConfig, year2, month2, day2, hour2, minute2, chars);
            }
            if (c == 'Z' || c == 'z') {
                TimezoneOffset timezoneOffset = TimezoneOffset.UTC;
                return ITUParser.handleSecondResolution(offset, year2, month2, day2, hour2, minute2, chars, timezoneOffset);
            }
            if (c == '+' || c == '-') {
                TimezoneOffset timezoneOffset = ITUParser.parseTimezone(offset, parseConfig, chars, offset + 19);
                return ITUParser.handleSecondResolution(offset, year2, month2, day2, hour2, minute2, chars, timezoneOffset);
            }
            throw ErrorUtil.raiseUnexpectedCharacter(chars, offset + 19, ArrayUtils.merge(parseConfig.getFractionSeparators(), new char[]{'Z', 'z', '+', '-'}));
        }
        if (length == 19) {
            int seconds = ITUParser.parseSeconds(offset, chars);
            return new DateTime(Field.SECOND, year2, month2, day2, hour2, minute2, seconds, 0, null, 0, length);
        }
        throw ErrorUtil.raiseUnexpectedEndOfText(chars, offset + 16);
    }

    private static DateTime handleSecondResolution(int offset, int year2, int month2, int day2, int hour2, int minute2, String chars, TimezoneOffset timezoneOffset) {
        int seconds = ITUParser.parseSeconds(offset, chars);
        int charLength = Field.SECOND.getRequiredLength() + (timezoneOffset != null ? timezoneOffset.getRequiredLength() : 0);
        return new DateTime(Field.SECOND, year2, month2, day2, hour2, minute2, seconds, 0, timezoneOffset, 0, charLength);
    }

    private static DateTime handleFractionalSeconds(int offset, ParseConfig parseConfig, int year2, int month2, int day2, int hour2, int minute2, String chars) {
        char c;
        int idx;
        int fractionDigits = 0;
        int nanos = 0;
        for (idx = offset + 20; idx < chars.length() && (c = chars.charAt(idx)) >= '0' && c <= '9'; ++idx) {
            ++fractionDigits;
            nanos = nanos * 10 + (c - 48);
        }
        ErrorUtil.assertFractionDigits(chars, fractionDigits, offset + (idx - 1));
        for (int pos = fractionDigits; pos < 9; ++pos) {
            nanos *= 10;
        }
        TimezoneOffset timezoneOffset = ITUParser.parseTimezone(offset, parseConfig, chars, idx);
        int charLength = idx + (timezoneOffset != null ? timezoneOffset.getRequiredLength() : 0) - offset;
        int second2 = ITUParser.parseSeconds(offset, chars);
        return new DateTime(Field.NANO, year2, month2, day2, hour2, minute2, second2, nanos, timezoneOffset, fractionDigits, charLength);
    }

    public static OffsetDateTime parseDateTime(String chars, int offset) {
        DateTime dateTime = ITUParser.parseLenient(chars, ParseConfig.DEFAULT, offset);
        if (dateTime.includesGranularity(Field.SECOND)) {
            return dateTime.toOffsetDatetime();
        }
        Field field = dateTime.getMostGranularField();
        Field nextGranularity = Field.values()[field.ordinal() + 1];
        throw new DateTimeParseException(String.format("Unexpected end of input, missing field %s: %s", new Object[]{nextGranularity, chars}), chars, field.getRequiredLength());
    }

    public static DateTime parseLenient(String text, ParseConfig parseConfig, ParsePosition position) {
        try {
            int offset = position.getIndex();
            DateTime result2 = ITUParser.parseLenient(text, parseConfig, position.getIndex());
            position.setIndex(offset + result2.getParseLength());
            return result2;
        }
        catch (DateTimeParseException exc) {
            position.setErrorIndex(exc.getErrorIndex());
            position.setIndex(position.getErrorIndex());
            throw exc;
        }
    }

    public static DateTimeParser getInstance() {
        return instance;
    }

    @Override
    public DateTime parse(String text, ParsePosition parsePosition) {
        return ITUParser.parseLenient(text, ParseConfig.DEFAULT, parsePosition);
    }

    @Override
    public DateTime parse(String text) {
        return ITUParser.parseLenient(text, ParseConfig.DEFAULT, 0);
    }
}

