/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.AbstractBigDecimalParser;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FastIntegerMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FftMultiplier;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.ParseDigitsTaskByteArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.NavigableMap;

final class JavaBigDecimalFromByteArray
extends AbstractBigDecimalParser {
    public BigDecimal parseBigDecimalString(byte[] str2, int offset, int length) {
        try {
            int exponentIndicatorIndex;
            long exponent;
            int digitCount;
            boolean isNegative2;
            int index2;
            int endIndex = JavaBigDecimalFromByteArray.checkBounds(str2.length, offset, length);
            if (JavaBigDecimalFromByteArray.hasManyDigits(length)) {
                return this.parseBigDecimalStringWithManyDigits(str2, offset, length);
            }
            long significand = 0L;
            int decimalPointIndex = -1;
            byte ch = JavaBigDecimalFromByteArray.charAt(str2, index2, endIndex);
            boolean illegal = false;
            boolean bl = isNegative2 = ch == 45;
            if ((isNegative2 || ch == 43) && (ch = JavaBigDecimalFromByteArray.charAt(str2, ++index2, endIndex)) == 0) {
                throw new NumberFormatException("illegal syntax");
            }
            int integerPartIndex = index2;
            for (index2 = offset; index2 < endIndex; ++index2) {
                int digits;
                ch = str2[index2];
                char digit = (char)(ch - 48);
                if (digit < '\n') {
                    significand = 10L * significand + (long)digit;
                    continue;
                }
                if (ch != 46) break;
                illegal |= decimalPointIndex >= 0;
                decimalPointIndex = index2;
                while (index2 < endIndex - 4 && (digits = FastDoubleSwar.tryToParseFourDigits(str2, index2 + 1)) >= 0) {
                    significand = 10000L * significand + (long)digits;
                    index2 += 4;
                }
            }
            int significandEndIndex = index2;
            if (decimalPointIndex < 0) {
                digitCount = significandEndIndex - integerPartIndex;
                decimalPointIndex = significandEndIndex;
                exponent = 0L;
            } else {
                digitCount = significandEndIndex - integerPartIndex - 1;
                exponent = decimalPointIndex - significandEndIndex + 1;
            }
            long expNumber = 0L;
            if ((ch | 0x20) == 101) {
                char digit;
                boolean isExponentNegative;
                exponentIndicatorIndex = index2++;
                ch = JavaBigDecimalFromByteArray.charAt(str2, index2, endIndex);
                boolean bl2 = isExponentNegative = ch == 45;
                if (isExponentNegative || ch == 43) {
                    ch = JavaBigDecimalFromByteArray.charAt(str2, ++index2, endIndex);
                }
                illegal |= (digit = (char)(ch - 48)) >= '\n';
                do {
                    if (expNumber >= Integer.MAX_VALUE) continue;
                    expNumber = 10L * expNumber + (long)digit;
                } while ((digit = (char)((ch = JavaBigDecimalFromByteArray.charAt(str2, ++index2, endIndex)) - 48)) < '\n');
                if (isExponentNegative) {
                    expNumber = -expNumber;
                }
                exponent += expNumber;
            } else {
                exponentIndicatorIndex = endIndex;
            }
            JavaBigDecimalFromByteArray.checkParsedBigDecimalBounds(illegal |= digitCount == 0, index2, endIndex, digitCount, exponent);
            if (digitCount < 19) {
                return new BigDecimal(isNegative2 ? -significand : significand).scaleByPowerOfTen((int)exponent);
            }
            return this.valueOfBigDecimalString(str2, integerPartIndex, decimalPointIndex, decimalPointIndex + 1, exponentIndicatorIndex, isNegative2, (int)exponent);
        }
        catch (ArithmeticException e) {
            NumberFormatException nfe = new NumberFormatException("value exceeds limits");
            nfe.initCause(e);
            throw nfe;
        }
    }

    BigDecimal parseBigDecimalStringWithManyDigits(byte[] str2, int offset, int length) {
        int exponentIndicatorIndex;
        long exponent;
        int digitCountWithoutLeadingZeros;
        boolean isNegative2;
        int index2;
        int nonZeroFractionalPartIndex = -1;
        int decimalPointIndex = -1;
        int endIndex = offset + length;
        byte ch = JavaBigDecimalFromByteArray.charAt(str2, index2, endIndex);
        boolean illegal = false;
        boolean bl = isNegative2 = ch == 45;
        if ((isNegative2 || ch == 43) && (ch = JavaBigDecimalFromByteArray.charAt(str2, ++index2, endIndex)) == 0) {
            throw new NumberFormatException("illegal syntax");
        }
        int integerPartIndex = index2;
        int swarLimit = Math.min(endIndex - 8, 0x40000000);
        for (index2 = offset; index2 < swarLimit && FastDoubleSwar.isEightZeroes(str2, index2); index2 += 8) {
        }
        while (index2 < endIndex && str2[index2] == 48) {
            ++index2;
        }
        int nonZeroIntegerPartIndex = index2;
        while (index2 < swarLimit && FastDoubleSwar.isEightDigits(str2, index2)) {
            index2 += 8;
        }
        while (index2 < endIndex && FastDoubleSwar.isDigit(ch = str2[index2])) {
            ++index2;
        }
        if (ch == 46) {
            decimalPointIndex = index2++;
            while (index2 < swarLimit && FastDoubleSwar.isEightZeroes(str2, index2)) {
                index2 += 8;
            }
            while (index2 < endIndex && str2[index2] == 48) {
                ++index2;
            }
            nonZeroFractionalPartIndex = index2;
            while (index2 < swarLimit && FastDoubleSwar.isEightDigits(str2, index2)) {
                index2 += 8;
            }
            while (index2 < endIndex && FastDoubleSwar.isDigit(ch = str2[index2])) {
                ++index2;
            }
        }
        int significandEndIndex = index2;
        if (decimalPointIndex < 0) {
            digitCountWithoutLeadingZeros = significandEndIndex - nonZeroIntegerPartIndex;
            decimalPointIndex = significandEndIndex;
            nonZeroFractionalPartIndex = significandEndIndex;
            exponent = 0L;
        } else {
            digitCountWithoutLeadingZeros = nonZeroIntegerPartIndex == decimalPointIndex ? significandEndIndex - nonZeroFractionalPartIndex : significandEndIndex - nonZeroIntegerPartIndex - 1;
            exponent = decimalPointIndex - significandEndIndex + 1;
        }
        long expNumber = 0L;
        if ((ch | 0x20) == 101) {
            char digit;
            boolean isExponentNegative;
            exponentIndicatorIndex = index2++;
            ch = JavaBigDecimalFromByteArray.charAt(str2, index2, endIndex);
            boolean bl2 = isExponentNegative = ch == 45;
            if (isExponentNegative || ch == 43) {
                ch = JavaBigDecimalFromByteArray.charAt(str2, ++index2, endIndex);
            }
            illegal |= (digit = (char)(ch - 48)) >= '\n';
            do {
                if (expNumber >= Integer.MAX_VALUE) continue;
                expNumber = 10L * expNumber + (long)digit;
            } while ((digit = (char)((ch = JavaBigDecimalFromByteArray.charAt(str2, ++index2, endIndex)) - 48)) < '\n');
            if (isExponentNegative) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        } else {
            exponentIndicatorIndex = endIndex;
        }
        JavaBigDecimalFromByteArray.checkParsedBigDecimalBounds(illegal |= integerPartIndex == decimalPointIndex && decimalPointIndex == exponentIndicatorIndex, index2, endIndex, digitCountWithoutLeadingZeros, exponent);
        return this.valueOfBigDecimalString(str2, nonZeroIntegerPartIndex, decimalPointIndex, nonZeroFractionalPartIndex, exponentIndicatorIndex, isNegative2, (int)exponent);
    }

    BigDecimal valueOfBigDecimalString(byte[] str2, int integerPartIndex, int decimalPointIndex, int nonZeroFractionalPartIndex, int exponentIndicatorIndex, boolean isNegative2, int exponent) {
        BigInteger significand;
        BigInteger integerPart;
        int fractionDigitsCount = exponentIndicatorIndex - decimalPointIndex - 1;
        int nonZeroFractionDigitsCount = exponentIndicatorIndex - nonZeroFractionalPartIndex;
        int integerDigitsCount = decimalPointIndex - integerPartIndex;
        NavigableMap<Integer, BigInteger> powersOfTen = null;
        if (integerDigitsCount > 0) {
            if (integerDigitsCount > 400) {
                powersOfTen = FastIntegerMath.createPowersOfTenFloor16Map();
                FastIntegerMath.fillPowersOfNFloor16Recursive(powersOfTen, integerPartIndex, decimalPointIndex);
                integerPart = ParseDigitsTaskByteArray.parseDigitsRecursive(str2, integerPartIndex, decimalPointIndex, powersOfTen, 400);
            } else {
                integerPart = ParseDigitsTaskByteArray.parseDigitsIterative(str2, integerPartIndex, decimalPointIndex);
            }
        } else {
            integerPart = BigInteger.ZERO;
        }
        if (fractionDigitsCount > 0) {
            BigInteger fractionalPart;
            if (nonZeroFractionDigitsCount > 400) {
                if (powersOfTen == null) {
                    powersOfTen = FastIntegerMath.createPowersOfTenFloor16Map();
                }
                FastIntegerMath.fillPowersOfNFloor16Recursive(powersOfTen, nonZeroFractionalPartIndex, exponentIndicatorIndex);
                fractionalPart = ParseDigitsTaskByteArray.parseDigitsRecursive(str2, nonZeroFractionalPartIndex, exponentIndicatorIndex, powersOfTen, 400);
            } else {
                fractionalPart = ParseDigitsTaskByteArray.parseDigitsIterative(str2, nonZeroFractionalPartIndex, exponentIndicatorIndex);
            }
            if (integerPart.signum() == 0) {
                significand = fractionalPart;
            } else {
                BigInteger integerFactor = FastIntegerMath.computePowerOfTen(powersOfTen, fractionDigitsCount);
                significand = FftMultiplier.multiply(integerPart, integerFactor).add(fractionalPart);
            }
        } else {
            significand = integerPart;
        }
        return new BigDecimal(isNegative2 ? significand.negate() : significand, -exponent);
    }
}

