/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.AbstractBigIntegerParser;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.AbstractNumberParser;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FastIntegerMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.ParseDigitsTaskByteArray;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.NavigableMap;

class JavaBigIntegerFromByteArray
extends AbstractBigIntegerParser {
    JavaBigIntegerFromByteArray() {
    }

    public BigInteger parseBigIntegerString(byte[] str2, int offset, int length, int radix) throws NumberFormatException {
        try {
            boolean isNegative2;
            int endIndex = AbstractNumberParser.checkBounds(str2.length, offset, length);
            int index2 = offset;
            byte ch = str2[index2];
            boolean bl = isNegative2 = ch == 45;
            if ((isNegative2 || ch == 43) && (ch = JavaBigIntegerFromByteArray.charAt(str2, ++index2, endIndex)) == 0) {
                throw new NumberFormatException("illegal syntax");
            }
            switch (radix) {
                case 10: {
                    return this.parseDecDigits(str2, index2, endIndex, isNegative2);
                }
                case 16: {
                    return this.parseHexDigits(str2, index2, endIndex, isNegative2);
                }
            }
            return new BigInteger(new String(str2, offset, length, StandardCharsets.ISO_8859_1), radix);
        }
        catch (ArithmeticException e) {
            NumberFormatException nfe = new NumberFormatException("value exceeds limits");
            nfe.initCause(e);
            throw nfe;
        }
    }

    private BigInteger parseDecDigits(byte[] str2, int from2, int to, boolean isNegative2) {
        int numDigits = to - from2;
        if (JavaBigIntegerFromByteArray.hasManyDigits(numDigits)) {
            return this.parseManyDecDigits(str2, from2, to, isNegative2);
        }
        int preroll = from2 + (numDigits & 7);
        long significand = FastDoubleSwar.tryToParseUpTo7Digits(str2, from2, preroll);
        boolean success = significand >= 0L;
        for (from2 = preroll; from2 < to; from2 += 8) {
            int addend = FastDoubleSwar.tryToParseEightDigitsUtf8(str2, from2);
            success &= addend >= 0;
            significand = significand * 100000000L + (long)addend;
        }
        if (!success) {
            throw new NumberFormatException("illegal syntax");
        }
        return BigInteger.valueOf(isNegative2 ? -significand : significand);
    }

    private BigInteger parseHexDigits(byte[] str2, int from2, int to, boolean isNegative2) {
        int numDigits = to - (from2 = this.skipZeroes(str2, from2, to));
        if (numDigits <= 0) {
            return BigInteger.ZERO;
        }
        JavaBigIntegerFromByteArray.checkHexBigIntegerBounds(numDigits);
        byte[] bytes = new byte[(numDigits + 1 >> 1) + 1];
        int index2 = 1;
        boolean illegalDigits = false;
        if ((numDigits & 1) != 0) {
            byte chLow = str2[from2++];
            int valueLow = JavaBigIntegerFromByteArray.lookupHex(chLow);
            bytes[index2++] = (byte)valueLow;
            illegalDigits = valueLow < 0;
        }
        int prerollLimit = from2 + (to - from2 & 7);
        while (from2 < prerollLimit) {
            byte chHigh = str2[from2];
            byte chLow = str2[from2 + 1];
            int valueHigh = JavaBigIntegerFromByteArray.lookupHex(chHigh);
            int valueLow = JavaBigIntegerFromByteArray.lookupHex(chLow);
            bytes[index2++] = (byte)(valueHigh << 4 | valueLow);
            illegalDigits |= valueHigh < 0 || valueLow < 0;
            from2 += 2;
        }
        while (from2 < to) {
            long value = FastDoubleSwar.tryToParseEightHexDigits(str2, from2);
            FastDoubleSwar.writeIntBE(bytes, index2, (int)value);
            illegalDigits |= value < 0L;
            from2 += 8;
            index2 += 4;
        }
        if (illegalDigits) {
            throw new NumberFormatException("illegal syntax");
        }
        BigInteger result2 = new BigInteger(bytes);
        return isNegative2 ? result2.negate() : result2;
    }

    private BigInteger parseManyDecDigits(byte[] str2, int from2, int to, boolean isNegative2) {
        from2 = this.skipZeroes(str2, from2, to);
        int numDigits = to - from2;
        JavaBigIntegerFromByteArray.checkDecBigIntegerBounds(numDigits);
        NavigableMap<Integer, BigInteger> powersOfTen = FastIntegerMath.fillPowersOf10Floor16(from2, to);
        BigInteger result2 = ParseDigitsTaskByteArray.parseDigitsRecursive(str2, from2, to, powersOfTen, 400);
        return isNegative2 ? result2.negate() : result2;
    }

    private int skipZeroes(byte[] str2, int from2, int to) {
        while (from2 < to - 8 && FastDoubleSwar.isEightZeroes(str2, from2)) {
            from2 += 8;
        }
        while (from2 < to && str2[from2] == 48) {
            ++from2;
        }
        return from2;
    }
}

