/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.DiscriminatorContext;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.Keyword;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.PathType;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidationMessageHandler;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import com.networknt.schema.i18n.DefaultMessageSource;
import com.networknt.schema.i18n.MessageSource;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;

public abstract class BaseJsonValidator
extends ValidationMessageHandler
implements JsonValidator {
    protected final boolean suppressSubSchemaRetrieval;
    protected final JsonNode schemaNode;
    protected final ValidationContext validationContext;

    public BaseJsonValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, ValidationContext validationContext) {
        this(schemaLocation, evaluationPath, schemaNode, parentSchema, validatorType, validatorType, validationContext, false);
    }

    public BaseJsonValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ErrorMessageType errorMessageType, Keyword keyword, ValidationContext validationContext, boolean suppressSubSchemaRetrieval) {
        super(errorMessageType, validationContext != null && validationContext.getConfig() != null ? validationContext.getConfig().getErrorMessageKeyword() : null, validationContext != null && validationContext.getConfig() != null ? validationContext.getConfig().getMessageSource() : DefaultMessageSource.getInstance(), keyword, parentSchema, schemaLocation, evaluationPath);
        this.validationContext = validationContext;
        this.schemaNode = schemaNode;
        this.suppressSubSchemaRetrieval = suppressSubSchemaRetrieval;
    }

    protected BaseJsonValidator(boolean suppressSubSchemaRetrieval, JsonNode schemaNode, ValidationContext validationContext, ErrorMessageType errorMessageType, String errorMessageKeyword, MessageSource messageSource, Keyword keyword, JsonSchema parentSchema, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonSchema evaluationParentSchema, Map<String, String> errorMessage) {
        super(errorMessageType, errorMessageKeyword, messageSource, keyword, parentSchema, schemaLocation, evaluationPath, evaluationParentSchema, errorMessage);
        this.suppressSubSchemaRetrieval = suppressSubSchemaRetrieval;
        this.schemaNode = schemaNode;
        this.validationContext = validationContext;
    }

    private static JsonSchema obtainSubSchemaNode(JsonNode schemaNode, ValidationContext validationContext) {
        JsonNode node2 = schemaNode.get("id");
        if (node2 == null) {
            return null;
        }
        if (node2.equals(schemaNode.get("$schema"))) {
            return null;
        }
        String text = node2.textValue();
        if (text == null) {
            return null;
        }
        SchemaLocation schemaLocation = SchemaLocation.of(node2.textValue());
        return validationContext.getJsonSchemaFactory().getSchema(schemaLocation, validationContext.getConfig());
    }

    protected static boolean equals(double n1, double n2) {
        return Math.abs(n1 - n2) < 1.0E-12;
    }

    public static void debug(Logger logger, ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        if (executionContext.getExecutionConfig().isDebugEnabled() && logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("validate( ");
            builder.append(node2.toString());
            builder.append(", ");
            builder.append(rootNode.toString());
            builder.append(", ");
            builder.append(instanceLocation.toString());
            builder.append(")");
            logger.debug(builder.toString());
        }
    }

    protected static void checkDiscriminatorMatch(DiscriminatorContext currentDiscriminatorContext, ObjectNode discriminator, String discriminatorPropertyValue, JsonSchema jsonSchema) {
        if (discriminatorPropertyValue == null) {
            currentDiscriminatorContext.markIgnore();
            return;
        }
        JsonNode discriminatorMapping = discriminator.get("mapping");
        if (null == discriminatorMapping) {
            BaseJsonValidator.checkForImplicitDiscriminatorMappingMatch(currentDiscriminatorContext, discriminatorPropertyValue, jsonSchema);
        } else {
            BaseJsonValidator.checkForExplicitDiscriminatorMappingMatch(currentDiscriminatorContext, discriminatorPropertyValue, discriminatorMapping, jsonSchema);
            if (!currentDiscriminatorContext.isDiscriminatorMatchFound() && BaseJsonValidator.noExplicitDiscriminatorKeyOverride(discriminatorMapping, jsonSchema)) {
                BaseJsonValidator.checkForImplicitDiscriminatorMappingMatch(currentDiscriminatorContext, discriminatorPropertyValue, jsonSchema);
            }
        }
    }

    protected static void registerAndMergeDiscriminator(DiscriminatorContext currentDiscriminatorContext, ObjectNode discriminator, JsonSchema schema, JsonNodePath instanceLocation) {
        JsonNode discriminatorOnSchema = schema.schemaNode.get("discriminator");
        if (null != discriminatorOnSchema && null != currentDiscriminatorContext.getDiscriminatorForPath(schema.schemaLocation)) {
            JsonNode propertyName = discriminatorOnSchema.get("propertyName");
            if (null != propertyName) {
                throw new JsonSchemaException(instanceLocation + " schema " + schema + " attempts redefining the discriminator property");
            }
            ObjectNode mappingOnContextDiscriminator = (ObjectNode)discriminator.get("mapping");
            ObjectNode mappingOnCurrentSchemaDiscriminator = (ObjectNode)discriminatorOnSchema.get("mapping");
            if (null == mappingOnContextDiscriminator && null != mappingOnCurrentSchemaDiscriminator) {
                discriminator.set("mapping", discriminatorOnSchema);
            } else if (null != mappingOnContextDiscriminator && null != mappingOnCurrentSchemaDiscriminator) {
                Iterator<Map.Entry<String, JsonNode>> fieldsToAdd = mappingOnCurrentSchemaDiscriminator.fields();
                while (fieldsToAdd.hasNext()) {
                    Map.Entry<String, JsonNode> fieldToAdd = fieldsToAdd.next();
                    String mappingKeyToAdd = fieldToAdd.getKey();
                    JsonNode mappingValueToAdd = fieldToAdd.getValue();
                    JsonNode currentMappingValue = mappingOnContextDiscriminator.get(mappingKeyToAdd);
                    if (null != currentMappingValue && currentMappingValue != mappingValueToAdd) {
                        throw new JsonSchemaException(instanceLocation + "discriminator mapping redefinition from " + mappingKeyToAdd + "/" + currentMappingValue + " to " + mappingValueToAdd);
                    }
                    if (null != currentMappingValue) continue;
                    mappingOnContextDiscriminator.set(mappingKeyToAdd, mappingValueToAdd);
                }
            }
        }
        currentDiscriminatorContext.registerDiscriminator(schema.schemaLocation, discriminator);
    }

    private static void checkForImplicitDiscriminatorMappingMatch(DiscriminatorContext currentDiscriminatorContext, String discriminatorPropertyValue, JsonSchema schema) {
        if (schema.schemaLocation.getFragment().getName(-1).equals(discriminatorPropertyValue)) {
            currentDiscriminatorContext.markMatch();
        }
    }

    private static void checkForExplicitDiscriminatorMappingMatch(DiscriminatorContext currentDiscriminatorContext, String discriminatorPropertyValue, JsonNode discriminatorMapping, JsonSchema schema) {
        Iterator<Map.Entry<String, JsonNode>> explicitMappings = discriminatorMapping.fields();
        while (explicitMappings.hasNext()) {
            Map.Entry<String, JsonNode> candidateExplicitMapping = explicitMappings.next();
            if (!candidateExplicitMapping.getKey().equals(discriminatorPropertyValue) || !("#" + schema.schemaLocation.getFragment().toString()).equals(candidateExplicitMapping.getValue().asText())) continue;
            currentDiscriminatorContext.markMatch();
            break;
        }
    }

    private static boolean noExplicitDiscriminatorKeyOverride(JsonNode discriminatorMapping, JsonSchema parentSchema) {
        Iterator<Map.Entry<String, JsonNode>> explicitMappings = discriminatorMapping.fields();
        while (explicitMappings.hasNext()) {
            Map.Entry<String, JsonNode> candidateExplicitMapping = explicitMappings.next();
            if (!candidateExplicitMapping.getValue().asText().equals(parentSchema.schemaLocation.getFragment().toString())) continue;
            return false;
        }
        return true;
    }

    @Override
    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public JsonNodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    @Override
    public String getKeyword() {
        return this.keyword.getValue();
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public JsonSchema getParentSchema() {
        return this.parentSchema;
    }

    public JsonSchema getEvaluationParentSchema() {
        if (this.evaluationParentSchema != null) {
            return this.evaluationParentSchema;
        }
        return this.getParentSchema();
    }

    protected JsonSchema fetchSubSchemaNode(ValidationContext validationContext) {
        return this.suppressSubSchemaRetrieval ? null : BaseJsonValidator.obtainSubSchemaNode(this.schemaNode, validationContext);
    }

    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2) {
        return this.validate(executionContext, node2, node2, this.atRoot());
    }

    protected String getNodeFieldType() {
        JsonNode typeField = this.getParentSchema().getSchemaNode().get("type");
        if (typeField != null) {
            return typeField.asText();
        }
        return null;
    }

    protected void preloadJsonSchemas(Collection<JsonSchema> schemas) {
        for (JsonSchema schema : schemas) {
            schema.initializeValidators();
        }
    }

    protected JsonNodePath atRoot() {
        if (this.validationContext.getConfig().getPathType().equals((Object)PathType.JSON_POINTER)) {
            return JsonNodePathJsonPointer.getInstance();
        }
        if (this.validationContext.getConfig().getPathType().equals((Object)PathType.LEGACY)) {
            return JsonNodePathLegacy.getInstance();
        }
        if (this.validationContext.getConfig().getPathType().equals((Object)PathType.JSON_PATH)) {
            return JsonNodePathJsonPath.getInstance();
        }
        return new JsonNodePath(this.validationContext.getConfig().getPathType());
    }

    public String toString() {
        return this.getEvaluationPath().getName(-1);
    }

    protected boolean hasAdjacentKeywordInEvaluationPath(String keyword) {
        for (JsonSchema schema = this.getEvaluationParentSchema(); schema != null; schema = schema.getEvaluationParentSchema()) {
            for (JsonValidator validator : schema.getValidators()) {
                if (!keyword.equals(validator.getKeyword())) continue;
                return true;
            }
            Object element = schema.getEvaluationPath().getElement(-1);
            if (!"properties".equals(element) && !"items".equals(element)) continue;
            return false;
        }
        return false;
    }

    @Override
    protected MessageSourceValidationMessage.Builder message() {
        return (MessageSourceValidationMessage.Builder)super.message().schemaNode(this.schemaNode);
    }

    protected boolean collectAnnotations(ExecutionContext executionContext) {
        return this.collectAnnotations(executionContext, this.getKeyword());
    }

    protected boolean collectAnnotations(ExecutionContext executionContext, String keyword) {
        return executionContext.getExecutionConfig().isAnnotationCollectionEnabled() && executionContext.getExecutionConfig().getAnnotationCollectionFilter().test(keyword);
    }

    protected void putAnnotation(ExecutionContext executionContext, Consumer<JsonNodeAnnotation.Builder> customizer) {
        JsonNodeAnnotation.Builder builder = JsonNodeAnnotation.builder().evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword());
        customizer.accept(builder);
        executionContext.getAnnotations().put(builder.build());
    }

    public static class JsonNodePathJsonPath {
        private static final JsonNodePath INSTANCE = new JsonNodePath(PathType.JSON_PATH);

        public static JsonNodePath getInstance() {
            return INSTANCE;
        }
    }

    public static class JsonNodePathJsonPointer {
        private static final JsonNodePath INSTANCE = new JsonNodePath(PathType.JSON_POINTER);

        public static JsonNodePath getInstance() {
            return INSTANCE;
        }
    }

    public static class JsonNodePathLegacy {
        private static final JsonNodePath INSTANCE = new JsonNodePath(PathType.LEGACY);

        public static JsonNodePath getInstance() {
            return INSTANCE;
        }
    }
}

