/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.okhttp;

import com.ustadmobile.ihttp.okhttp.request.HttpRequestOkHttpAdapterKt;
import com.ustadmobile.ihttp.okhttp.request.OkHttpRequestAdapterKt;
import com.ustadmobile.ihttp.request.IHttpRequest;
import com.ustadmobile.libcache.distributed.DistributedCacheHashtable;
import com.ustadmobile.libcache.logging.UstadCacheLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/ustadmobile/libcache/okhttp/DistributedCacheInterceptor;", "Lokhttp3/Interceptor;", "Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;", "distributedCacheHashtable", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "logger", "<init>", "(Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;Lcom/ustadmobile/libcache/logging/UstadCacheLogger;)V", "Lokhttp3/Interceptor$Chain;", "chain", "Lokhttp3/Response;", "intercept", "(Lokhttp3/Interceptor$Chain;)Lokhttp3/Response;", "Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;", "getDistributedCacheHashtable", "()Lcom/ustadmobile/libcache/distributed/DistributedCacheHashtable;", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "respect-lib-cache"})
public final class DistributedCacheInterceptor
implements Interceptor {
    @NotNull
    private final DistributedCacheHashtable distributedCacheHashtable;
    @NotNull
    private final UstadCacheLogger logger;

    public DistributedCacheInterceptor(@NotNull DistributedCacheHashtable distributedCacheHashtable, @NotNull UstadCacheLogger logger) {
        Intrinsics.checkNotNullParameter(distributedCacheHashtable, "distributedCacheHashtable");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.distributedCacheHashtable = distributedCacheHashtable;
        this.logger = logger;
    }

    @NotNull
    public final DistributedCacheHashtable getDistributedCacheHashtable() {
        return this.distributedCacheHashtable;
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter(chain, "chain");
        Request chainRequest = chain.request();
        IHttpRequest localRequest = this.distributedCacheHashtable.localRequestFor(OkHttpRequestAdapterKt.asIHttpRequest(chainRequest));
        if (localRequest != null) {
            UstadCacheLogger.i$default(this.logger, "DistCache", "Local Download: " + chainRequest.url() + " from " + localRequest.getUrl(), null, 4, null);
            try {
                Response response2 = chain.proceed(HttpRequestOkHttpAdapterKt.asOkHttpRequest(localRequest));
                if (response2.isSuccessful()) {
                    return response2;
                }
                Util.closeQuietly(response2);
            }
            catch (Exception e) {
                this.logger.w("DistCache", "Local request failed", e);
            }
        }
        return chain.proceed(chainRequest);
    }
}

