/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.Parameters;
import io.ktor.http.URLProtocol;
import io.ktor.http.UrlJvmSerializer;
import io.ktor.http.UrlSerializer;
import io.ktor.utils.io.JvmSerializable_jvmKt;
import java.io.Serializable;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlinx.serialization.Serializable(with=UrlSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b:\b\u0007\u0018\u0000 P2\u00060\u0001j\u0002`\u0002:\u0001PBe\b\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001f\u001a\u0004\b \u0010\u0016R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010!\u001a\u0004\b\"\u0010\u001cR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010#\u001a\u0004\b$\u0010%R\u0017\u0010\r\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001f\u001a\u0004\b&\u0010\u0016R\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001f\u001a\u0004\b'\u0010\u0016R\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001f\u001a\u0004\b(\u0010\u0016R\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010)\u001a\u0004\b*\u0010+R\u0014\u0010\u0012\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u001fR&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\n\u0010,\u0012\u0004\b/\u00100\u001a\u0004\b-\u0010.R\u001d\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\t8\u0006\u00a2\u0006\f\n\u0004\b1\u0010,\u001a\u0004\b2\u0010.R!\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u0010.R\u0019\u00107\u001a\u0004\u0018\u00010\u00038\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00108\u001a\u0004\b;\u0010:R\u0011\u0010=\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u001cR\u001b\u0010@\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u00104\u001a\u0004\b?\u0010\u0016R\u001b\u0010C\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u00104\u001a\u0004\bB\u0010\u0016R\u001b\u0010F\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u00104\u001a\u0004\bE\u0010\u0016R\u001d\u0010I\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u00104\u001a\u0004\bH\u0010\u0016R\u001d\u0010L\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u00104\u001a\u0004\bK\u0010\u0016R\u001b\u0010O\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u00104\u001a\u0004\bN\u0010\u0016\u00a8\u0006Q"}, d2={"Lio/ktor/http/Url;", "Ljava/io/Serializable;", "Lio/ktor/utils/io/JvmSerializable;", "Lio/ktor/http/URLProtocol;", "protocol", "", "host", "", "specifiedPort", "", "pathSegments", "Lio/ktor/http/Parameters;", "parameters", "fragment", "user", "password", "", "trailingQuery", "urlString", "<init>", "(Lio/ktor/http/URLProtocol;Ljava/lang/String;ILjava/util/List;Lio/ktor/http/Parameters;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "toString", "()Ljava/lang/String;", "", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "writeReplace", "()Ljava/lang/Object;", "Ljava/lang/String;", "getHost", "I", "getSpecifiedPort", "Lio/ktor/http/Parameters;", "getParameters", "()Lio/ktor/http/Parameters;", "getFragment", "getUser", "getPassword", "Z", "getTrailingQuery", "()Z", "Ljava/util/List;", "getPathSegments", "()Ljava/util/List;", "getPathSegments$annotations", "()V", "rawSegments", "getRawSegments", "segments$delegate", "Lkotlin/Lazy;", "getSegments", "segments", "protocolOrNull", "Lio/ktor/http/URLProtocol;", "getProtocolOrNull", "()Lio/ktor/http/URLProtocol;", "getProtocol", "getPort", "port", "encodedPath$delegate", "getEncodedPath", "encodedPath", "encodedQuery$delegate", "getEncodedQuery", "encodedQuery", "encodedPathAndQuery$delegate", "getEncodedPathAndQuery", "encodedPathAndQuery", "encodedUser$delegate", "getEncodedUser", "encodedUser", "encodedPassword$delegate", "getEncodedPassword", "encodedPassword", "encodedFragment$delegate", "getEncodedFragment", "encodedFragment", "Companion", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Url.kt\nio/ktor/http/Url\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n1#2:301\n*E\n"})
public final class Url
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private final int specifiedPort;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final String fragment;
    @Nullable
    private final String user;
    @Nullable
    private final String password;
    private final boolean trailingQuery;
    @NotNull
    private final String urlString;
    @NotNull
    private final List<String> pathSegments;
    @NotNull
    private final List<String> rawSegments;
    @NotNull
    private final Lazy segments$delegate;
    @Nullable
    private final URLProtocol protocolOrNull;
    @NotNull
    private final URLProtocol protocol;
    @NotNull
    private final Lazy encodedPath$delegate;
    @NotNull
    private final Lazy encodedQuery$delegate;
    @NotNull
    private final Lazy encodedPathAndQuery$delegate;
    @NotNull
    private final Lazy encodedUser$delegate;
    @NotNull
    private final Lazy encodedPassword$delegate;
    @NotNull
    private final Lazy encodedFragment$delegate;

    public Url(@Nullable URLProtocol protocol, @NotNull String host, int specifiedPort, @NotNull List<String> pathSegments, @NotNull Parameters parameters, @NotNull String fragment, @Nullable String user, @Nullable String password, boolean trailingQuery, @NotNull String urlString) {
        Intrinsics.checkNotNullParameter(host, "host");
        Intrinsics.checkNotNullParameter(pathSegments, "pathSegments");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        Intrinsics.checkNotNullParameter(urlString, "urlString");
        this.host = host;
        this.specifiedPort = specifiedPort;
        this.parameters = parameters;
        this.fragment = fragment;
        this.user = user;
        this.password = password;
        this.trailingQuery = trailingQuery;
        this.urlString = urlString;
        int n = this.specifiedPort;
        if (!(0 <= n ? n < 65536 : false)) {
            boolean bl = false;
            String string2 = "Port must be between 0 and 65535, or 0 if not set. Provided: " + this.specifiedPort;
            throw new IllegalArgumentException(string2.toString());
        }
        this.pathSegments = pathSegments;
        this.rawSegments = pathSegments;
        this.segments$delegate = LazyKt.lazy(() -> Url.segments_delegate$lambda$1(pathSegments));
        this.protocolOrNull = protocol;
        URLProtocol uRLProtocol = this.protocolOrNull;
        if (uRLProtocol == null) {
            uRLProtocol = URLProtocol.Companion.getHTTP();
        }
        this.protocol = uRLProtocol;
        this.encodedPath$delegate = LazyKt.lazy(() -> Url.encodedPath_delegate$lambda$3(pathSegments, this));
        this.encodedQuery$delegate = LazyKt.lazy(() -> Url.encodedQuery_delegate$lambda$4(this));
        this.encodedPathAndQuery$delegate = LazyKt.lazy(() -> Url.encodedPathAndQuery_delegate$lambda$5(this));
        this.encodedUser$delegate = LazyKt.lazy(() -> Url.encodedUser_delegate$lambda$6(this));
        this.encodedPassword$delegate = LazyKt.lazy(() -> Url.encodedPassword_delegate$lambda$7(this));
        this.encodedFragment$delegate = LazyKt.lazy(() -> Url.encodedFragment_delegate$lambda$8(this));
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getSpecifiedPort() {
        return this.specifiedPort;
    }

    @NotNull
    public final Parameters getParameters() {
        return this.parameters;
    }

    @NotNull
    public final String getFragment() {
        return this.fragment;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final boolean getTrailingQuery() {
        return this.trailingQuery;
    }

    @NotNull
    public final List<String> getPathSegments() {
        return this.pathSegments;
    }

    @Deprecated(message="\n        `pathSegments` is deprecated.\n\n        This property will contain an empty path segment at the beginning for URLs with a hostname,\n        and an empty path segment at the end for the URLs with a trailing slash. If you need to keep this behaviour please\n        use [rawSegments]. If you only need to access the meaningful parts of the path, consider using [segments] instead.\n             \n        Please decide if you need [rawSegments] or [segments] explicitly.\n        ", replaceWith=@ReplaceWith(expression="rawSegments", imports={}))
    public static /* synthetic */ void getPathSegments$annotations() {
    }

    @NotNull
    public final List<String> getRawSegments() {
        return this.rawSegments;
    }

    @NotNull
    public final List<String> getSegments() {
        Lazy lazy = this.segments$delegate;
        return (List)lazy.getValue();
    }

    @Nullable
    public final URLProtocol getProtocolOrNull() {
        return this.protocolOrNull;
    }

    @NotNull
    public final URLProtocol getProtocol() {
        return this.protocol;
    }

    public final int getPort() {
        Integer n = this.specifiedPort;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        return n2 != null ? n2.intValue() : this.protocol.getDefaultPort();
    }

    @NotNull
    public final String getEncodedPath() {
        Lazy lazy = this.encodedPath$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getEncodedQuery() {
        Lazy lazy = this.encodedQuery$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getEncodedPathAndQuery() {
        Lazy lazy = this.encodedPathAndQuery$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getEncodedUser() {
        Lazy lazy = this.encodedUser$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getEncodedPassword() {
        Lazy lazy = this.encodedPassword$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getEncodedFragment() {
        Lazy lazy = this.encodedFragment$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return this.urlString;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Url cfr_ignored_0 = (Url)other;
        return Intrinsics.areEqual(this.urlString, ((Url)other).urlString);
    }

    public int hashCode() {
        return this.urlString.hashCode();
    }

    private final Object writeReplace() {
        return JvmSerializable_jvmKt.JvmSerializerReplacement(UrlJvmSerializer.INSTANCE, this);
    }

    private static final List segments_delegate$lambda$1(List $pathSegments) {
        if ($pathSegments.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int start2 = ((CharSequence)CollectionsKt.first($pathSegments)).length() == 0 && $pathSegments.size() > 1 ? 1 : 0;
        int end = ((CharSequence)CollectionsKt.last($pathSegments)).length() == 0 ? CollectionsKt.getLastIndex($pathSegments) : CollectionsKt.getLastIndex($pathSegments) + 1;
        return $pathSegments.subList(start2, end);
    }

    private static final String encodedPath_delegate$lambda$3(List $pathSegments, Url this$0) {
        if ($pathSegments.isEmpty()) {
            return "";
        }
        int pathStartIndex = StringsKt.indexOf$default((CharSequence)this$0.urlString, '/', this$0.protocol.getName().length() + 3, false, 4, null);
        if (pathStartIndex == -1) {
            return "";
        }
        char[] cArray = new char[]{'?', '#'};
        int pathEndIndex = StringsKt.indexOfAny$default((CharSequence)this$0.urlString, cArray, pathStartIndex, false, 4, null);
        if (pathEndIndex == -1) {
            String string2 = this$0.urlString.substring(pathStartIndex);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            return string2;
        }
        String string3 = this$0.urlString.substring(pathStartIndex, pathEndIndex);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        return string3;
    }

    private static final String encodedQuery_delegate$lambda$4(Url this$0) {
        int queryStart = StringsKt.indexOf$default((CharSequence)this$0.urlString, '?', 0, false, 6, null) + 1;
        if (queryStart == 0) {
            return "";
        }
        int queryEnd = StringsKt.indexOf$default((CharSequence)this$0.urlString, '#', queryStart, false, 4, null);
        if (queryEnd == -1) {
            String string2 = this$0.urlString.substring(queryStart);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            return string2;
        }
        String string3 = this$0.urlString.substring(queryStart, queryEnd);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        return string3;
    }

    private static final String encodedPathAndQuery_delegate$lambda$5(Url this$0) {
        int pathStart = StringsKt.indexOf$default((CharSequence)this$0.urlString, '/', this$0.protocol.getName().length() + 3, false, 4, null);
        if (pathStart == -1) {
            return "";
        }
        int queryEnd = StringsKt.indexOf$default((CharSequence)this$0.urlString, '#', pathStart, false, 4, null);
        if (queryEnd == -1) {
            String string2 = this$0.urlString.substring(pathStart);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            return string2;
        }
        String string3 = this$0.urlString.substring(pathStart, queryEnd);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        return string3;
    }

    private static final String encodedUser_delegate$lambda$6(Url this$0) {
        if (this$0.user == null) {
            return null;
        }
        if (((CharSequence)this$0.user).length() == 0) {
            return "";
        }
        int usernameStart = this$0.protocol.getName().length() + 3;
        char[] cArray = new char[]{':', '@'};
        int usernameEnd = StringsKt.indexOfAny$default((CharSequence)this$0.urlString, cArray, usernameStart, false, 4, null);
        String string2 = this$0.urlString.substring(usernameStart, usernameEnd);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return string2;
    }

    private static final String encodedPassword_delegate$lambda$7(Url this$0) {
        if (this$0.password == null) {
            return null;
        }
        if (((CharSequence)this$0.password).length() == 0) {
            return "";
        }
        int passwordStart = StringsKt.indexOf$default((CharSequence)this$0.urlString, ':', this$0.protocol.getName().length() + 3, false, 4, null) + 1;
        int passwordEnd = StringsKt.indexOf$default((CharSequence)this$0.urlString, '@', 0, false, 6, null);
        String string2 = this$0.urlString.substring(passwordStart, passwordEnd);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return string2;
    }

    private static final String encodedFragment_delegate$lambda$8(Url this$0) {
        int fragmentStart = StringsKt.indexOf$default((CharSequence)this$0.urlString, '#', 0, false, 6, null) + 1;
        if (fragmentStart == 0) {
            return "";
        }
        String string2 = this$0.urlString.substring(fragmentStart);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/ktor/http/Url$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lio/ktor/http/Url;", "serializer", "()Lkotlinx/serialization/KSerializer;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Url> serializer() {
            return UrlSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

