/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.pipeline;

import io.ktor.util.Attributes;
import io.ktor.util.AttributesJvmKt;
import io.ktor.util.pipeline.InvalidPhaseException;
import io.ktor.util.pipeline.PhaseContent;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelineContextKt;
import io.ktor.util.pipeline.PipelinePhase;
import io.ktor.util.pipeline.PipelinePhaseRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u000b\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u00020\u0001B\u001b\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bBb\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012O\u0010\u0011\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\n\u00a2\u0006\u0004\b\u0007\u0010\u0012J \u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00028\u0000H\u0086@\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001c\u0010\u001bJ`\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052I\u0010\u001d\u001aE\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b \u0010!J^\u0010\"\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\n2\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\"\u0010#J!\u0010%\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0004\b%\u0010&J#\u0010'\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\b'\u0010&J!\u0010(\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0004\b(\u0010&J!\u0010)\u001a\u00020\u000e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0004\b)\u0010&J\u000f\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b+\u0010,J`\u0010.\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\n2\u0006\u0010\t\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b-\u0010#JX\u00101\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\nH\u0000\u00a2\u0006\u0004\b/\u00100J3\u00104\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f2\u0006\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u00103\u001a\u000202H\u0002\u00a2\u0006\u0004\b4\u00105J%\u00107\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u0001062\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b7\u00108J\u0017\u0010:\u001a\u0002092\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010=\u001a\u00020<2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b=\u0010>JX\u0010?\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\nH\u0002\u00a2\u0006\u0004\b?\u00100J#\u0010@\u001a\u00020<2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\b@\u0010AJX\u0010B\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\nH\u0002\u00a2\u0006\u0004\bB\u00100J\u000f\u0010C\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\bC\u0010!J`\u0010E\u001a\u00020\u000e2O\u0010D\u001aK\u0012G\u0012E\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u00100\nH\u0002\u00a2\u0006\u0004\bE\u0010FJ#\u0010H\u001a\u00020\u000e2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000106H\u0002\u00a2\u0006\u0004\bH\u0010IJ#\u0010K\u001a\u00020\u000e2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\bK\u0010&Jb\u0010L\u001a\u00020<2\u0006\u0010\t\u001a\u00020\u00052I\u0010\u001d\u001aE\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u000f\u00a2\u0006\u0002\b\u0010H\u0002\u00a2\u0006\u0004\bL\u0010MJ\u001f\u0010P\u001a\u00020<2\u0006\u0010N\u001a\u00020\u00012\u0006\u0010O\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\bP\u0010QR\u0017\u0010S\u001a\u00020R8\u0006\u00a2\u0006\f\n\u0004\bS\u0010T\u001a\u0004\bU\u0010VR\u001a\u0010W\u001a\u00020<8\u0016X\u0096D\u00a2\u0006\f\n\u0004\bW\u0010X\u001a\u0004\bY\u0010ZR\u001a\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00010[8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\u0016\u0010^\u001a\u0002098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b^\u0010_R\u0017\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b`\u00100R\u0011\u0010b\u001a\u00020<8F\u00a2\u0006\u0006\u001a\u0004\bb\u0010ZR\u0016\u0010c\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bc\u0010XR\u0018\u0010d\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bd\u0010e\u00a8\u0006f"}, d2={"Lio/ktor/util/pipeline/Pipeline;", "", "TSubject", "TContext", "", "Lio/ktor/util/pipeline/PipelinePhase;", "phases", "<init>", "([Lio/ktor/util/pipeline/PipelinePhase;)V", "phase", "", "Lkotlin/Function3;", "Lio/ktor/util/pipeline/PipelineContext;", "Lkotlin/coroutines/Continuation;", "", "Lio/ktor/util/pipeline/PipelineInterceptor;", "Lkotlin/ExtensionFunctionType;", "interceptors", "(Lio/ktor/util/pipeline/PipelinePhase;Ljava/util/List;)V", "context", "subject", "execute", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)V", "reference", "insertPhaseAfter", "(Lio/ktor/util/pipeline/PipelinePhase;Lio/ktor/util/pipeline/PipelinePhase;)V", "insertPhaseBefore", "block", "intercept", "(Lio/ktor/util/pipeline/PipelinePhase;Lkotlin/jvm/functions/Function3;)V", "afterIntercepted", "()V", "interceptorsForPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Ljava/util/List;", "from", "mergePhases", "(Lio/ktor/util/pipeline/Pipeline;)V", "mergeInterceptors", "merge", "resetFrom", "", "toString", "()Ljava/lang/String;", "phaseInterceptors$ktor_utils", "phaseInterceptors", "interceptorsForTests$ktor_utils", "()Ljava/util/List;", "interceptorsForTests", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "createContext", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/CoroutineContext;)Lio/ktor/util/pipeline/PipelineContext;", "Lio/ktor/util/pipeline/PhaseContent;", "findPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Lio/ktor/util/pipeline/PhaseContent;", "", "findPhaseIndex", "(Lio/ktor/util/pipeline/PipelinePhase;)I", "", "hasPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Z", "cacheInterceptors", "fastPathMerge", "(Lio/ktor/util/pipeline/Pipeline;)Z", "sharedInterceptorsList", "resetInterceptorsList", "list", "notSharedInterceptorsList", "(Ljava/util/List;)V", "phaseContent", "setInterceptorsListFromPhase", "(Lio/ktor/util/pipeline/PhaseContent;)V", "pipeline", "setInterceptorsListFromAnotherPipeline", "tryAddToPhaseFastPath", "(Lio/ktor/util/pipeline/PipelinePhase;Lkotlin/jvm/functions/Function3;)Z", "fromPhaseOrContent", "fromPhase", "insertRelativePhase", "(Ljava/lang/Object;Lio/ktor/util/pipeline/PipelinePhase;)Z", "Lio/ktor/util/Attributes;", "attributes", "Lio/ktor/util/Attributes;", "getAttributes", "()Lio/ktor/util/Attributes;", "developmentMode", "Z", "getDevelopmentMode", "()Z", "", "phasesRaw", "Ljava/util/List;", "interceptorsQuantity", "I", "getItems", "items", "isEmpty", "interceptorsListShared", "interceptorsListSharedPhase", "Lio/ktor/util/pipeline/PipelinePhase;", "ktor-utils"})
@SourceDebugExtension(value={"SMAP\nPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pipeline.kt\nio/ktor/util/pipeline/Pipeline\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,539:1\n1563#2:540\n1634#2,3:541\n1869#2,2:544\n808#2,11:546\n295#2,2:557\n1869#2,2:559\n*S KotlinDebug\n*F\n+ 1 Pipeline.kt\nio/ktor/util/pipeline/Pipeline\n*L\n60#1:540\n60#1:541,3\n83#1:544,2\n195#1:546,11\n196#1:557,2\n236#1:559,2\n*E\n"})
public class Pipeline<TSubject, TContext> {
    @NotNull
    private final Attributes attributes;
    private final boolean developmentMode;
    @NotNull
    private final List<Object> phasesRaw;
    private int interceptorsQuantity;
    @NotNull
    private volatile /* synthetic */ Object interceptors$delegate;
    private boolean interceptorsListShared;
    @Nullable
    private PipelinePhase interceptorsListSharedPhase;

    public Pipeline(PipelinePhase ... phases) {
        Intrinsics.checkNotNullParameter(phases, "phases");
        this.attributes = AttributesJvmKt.Attributes(true);
        this.phasesRaw = CollectionsKt.mutableListOf(Arrays.copyOf(phases, phases.length));
        this.interceptors$delegate = null;
    }

    @NotNull
    public final Attributes getAttributes() {
        return this.attributes;
    }

    public boolean getDevelopmentMode() {
        return this.developmentMode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PipelinePhase> getItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.phasesRaw;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PipelinePhase pipelinePhase = it instanceof PipelinePhase ? (PipelinePhase)it : null;
            if (pipelinePhase == null) {
                PhaseContent phaseContent = it instanceof PhaseContent ? (PhaseContent)it : null;
                PipelinePhase pipelinePhase2 = phaseContent != null ? phaseContent.getPhase() : null;
                pipelinePhase = pipelinePhase2;
                Intrinsics.checkNotNull(pipelinePhase2);
            }
            collection.add(pipelinePhase);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isEmpty() {
        return this.interceptorsQuantity == 0;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> getInterceptors() {
        return (List)this.interceptors$delegate;
    }

    private final void setInterceptors(List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> list2) {
        this.interceptors$delegate = list2;
    }

    public Pipeline(@NotNull PipelinePhase phase, @NotNull List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> interceptors) {
        Intrinsics.checkNotNullParameter(phase, "phase");
        Intrinsics.checkNotNullParameter(interceptors, "interceptors");
        PipelinePhase[] pipelinePhaseArray = new PipelinePhase[]{phase};
        this(pipelinePhaseArray);
        Iterable $this$forEach$iv = interceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function3 it = (Function3)element$iv;
            boolean bl = false;
            this.intercept(phase, it);
        }
    }

    @Nullable
    public final Object execute(@NotNull TContext context2, @NotNull TSubject subject, @NotNull Continuation<? super TSubject> $completion) {
        return this.createContext(context2, subject, $completion.getContext()).execute$ktor_utils(subject, $completion);
    }

    public final void addPhase(@NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter(phase, "phase");
        if (this.hasPhase(phase)) {
            return;
        }
        this.phasesRaw.add(phase);
    }

    public final void insertPhaseAfter(@NotNull PipelinePhase reference, @NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(phase, "phase");
        if (this.hasPhase(phase)) {
            return;
        }
        int index2 = this.findPhaseIndex(reference);
        if (index2 == -1) {
            throw new InvalidPhaseException("Phase " + reference + " was not registered for this pipeline");
        }
        int lastRelatedPhaseIndex = index2;
        int i2 = index2 + 1;
        int n = CollectionsKt.getLastIndex(this.phasesRaw);
        if (i2 <= n) {
            Object object;
            Object object2;
            while ((object2 = (object = this.phasesRaw.get(i2)) instanceof PhaseContent ? (PhaseContent)object : null) != null && (object2 = ((PhaseContent)object2).getRelation()) != null) {
                Object relation = object2;
                Object object3 = relation instanceof PipelinePhaseRelation.After ? (PipelinePhaseRelation.After)relation : null;
                if (object3 != null && (object3 = ((PipelinePhaseRelation.After)object3).getRelativeTo()) != null) {
                    Object relatedTo = object3;
                    int n2 = lastRelatedPhaseIndex = Intrinsics.areEqual(relatedTo, reference) ? i2 : lastRelatedPhaseIndex;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        this.phasesRaw.add(lastRelatedPhaseIndex + 1, new PhaseContent(phase, new PipelinePhaseRelation.After(reference)));
    }

    public final void insertPhaseBefore(@NotNull PipelinePhase reference, @NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(phase, "phase");
        if (this.hasPhase(phase)) {
            return;
        }
        int index2 = this.findPhaseIndex(reference);
        if (index2 == -1) {
            throw new InvalidPhaseException("Phase " + reference + " was not registered for this pipeline");
        }
        this.phasesRaw.add(index2, new PhaseContent(phase, new PipelinePhaseRelation.Before(reference)));
    }

    public final void intercept(@NotNull PipelinePhase phase, @NotNull Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> block2) {
        Intrinsics.checkNotNullParameter(phase, "phase");
        Intrinsics.checkNotNullParameter(block2, "block");
        PhaseContent<? super TSubject, TContext> phaseContent = this.findPhase(phase);
        if (phaseContent == null) {
            throw new InvalidPhaseException("Phase " + phase + " was not registered for this pipeline");
        }
        PhaseContent<? super TSubject, TContext> phaseContent2 = phaseContent;
        if (this.tryAddToPhaseFastPath(phase, block2)) {
            int n = this.interceptorsQuantity;
            this.interceptorsQuantity = n + 1;
            return;
        }
        phaseContent2.addInterceptor(block2);
        int n = this.interceptorsQuantity;
        this.interceptorsQuantity = n + 1;
        this.resetInterceptorsList();
        this.afterIntercepted();
    }

    public void afterIntercepted() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptorsForPhase(@NotNull PipelinePhase phase) {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(phase, "phase");
            Iterable $this$filterIsInstance$iv = this.phasesRaw;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PhaseContent)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PhaseContent phaseOrContent = (PhaseContent)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(phaseOrContent.getPhase(), phase)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PhaseContent phaseContent = v0;
        List<Function3<PipelineContext<TSubject, TContext>, Object, Continuation<Unit>, Object>> list2 = phaseContent != null ? phaseContent.sharedInterceptors() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final void mergePhases(@NotNull Pipeline<TSubject, TContext> from2) {
        Intrinsics.checkNotNullParameter(from2, "from");
        List<Object> fromPhases = from2.phasesRaw;
        List toInsert = CollectionsKt.toMutableList((Collection)fromPhases);
        while (!((Collection)toInsert).isEmpty()) {
            Iterator iterator2 = toInsert.iterator();
            while (iterator2.hasNext()) {
                PipelinePhase fromPhase;
                Object fromPhaseOrContent = iterator2.next();
                PipelinePhase pipelinePhase = fromPhaseOrContent instanceof PipelinePhase ? (PipelinePhase)fromPhaseOrContent : null;
                if (pipelinePhase == null) {
                    Intrinsics.checkNotNull(fromPhaseOrContent, "null cannot be cast to non-null type io.ktor.util.pipeline.PhaseContent<*, *>");
                    pipelinePhase = ((PhaseContent)fromPhaseOrContent).getPhase();
                }
                if (this.hasPhase(fromPhase = pipelinePhase)) {
                    iterator2.remove();
                    continue;
                }
                boolean inserted = this.insertRelativePhase(fromPhaseOrContent, fromPhase);
                if (!inserted) continue;
                iterator2.remove();
            }
        }
    }

    private final void mergeInterceptors(Pipeline<TSubject, TContext> from2) {
        if (this.interceptorsQuantity == 0) {
            this.setInterceptorsListFromAnotherPipeline(from2);
        } else {
            this.resetInterceptorsList();
        }
        List<Object> fromPhases = from2.phasesRaw;
        Iterable $this$forEach$iv = fromPhases;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            PipelinePhase fromPhase;
            Object element$iv;
            Object fromPhaseOrContent = element$iv = iterator2.next();
            boolean bl = false;
            PipelinePhase pipelinePhase = fromPhaseOrContent instanceof PipelinePhase ? (PipelinePhase)fromPhaseOrContent : null;
            if (pipelinePhase == null) {
                Intrinsics.checkNotNull(fromPhaseOrContent, "null cannot be cast to non-null type io.ktor.util.pipeline.PhaseContent<*, *>");
                pipelinePhase = fromPhase = ((PhaseContent)fromPhaseOrContent).getPhase();
            }
            if (!(fromPhaseOrContent instanceof PhaseContent) || ((PhaseContent)fromPhaseOrContent).isEmpty()) continue;
            PhaseContent cfr_ignored_0 = (PhaseContent)fromPhaseOrContent;
            PhaseContent phaseContent = (PhaseContent)fromPhaseOrContent;
            PhaseContent<TSubject, TContext> phaseContent2 = this.findPhase(fromPhase);
            Intrinsics.checkNotNull(phaseContent2);
            phaseContent.addTo(phaseContent2);
            this.interceptorsQuantity += ((PhaseContent)fromPhaseOrContent).getSize();
        }
    }

    public final void merge(@NotNull Pipeline<TSubject, TContext> from2) {
        Intrinsics.checkNotNullParameter(from2, "from");
        if (this.fastPathMerge(from2)) {
            return;
        }
        this.mergePhases(from2);
        this.mergeInterceptors(from2);
    }

    public final void resetFrom(@NotNull Pipeline<TSubject, TContext> from2) {
        Intrinsics.checkNotNullParameter(from2, "from");
        this.phasesRaw.clear();
        if (!(this.interceptorsQuantity == 0)) {
            throw new IllegalStateException("Check failed.");
        }
        this.fastPathMerge(from2);
    }

    @NotNull
    public String toString() {
        return super.toString();
    }

    @NotNull
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> phaseInterceptors$ktor_utils(@NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter(phase, "phase");
        Object object = this.findPhase(phase);
        if (object == null || (object = ((PhaseContent)object).sharedInterceptors()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptorsForTests$ktor_utils() {
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> list2 = this.getInterceptors();
        if (list2 == null) {
            list2 = this.cacheInterceptors();
        }
        return list2;
    }

    private final PipelineContext<TSubject, TContext> createContext(TContext context2, TSubject subject, CoroutineContext coroutineContext) {
        return PipelineContextKt.pipelineContextFor(context2, this.sharedInterceptorsList(), subject, coroutineContext, this.getDevelopmentMode());
    }

    private final PhaseContent<TSubject, TContext> findPhase(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = phasesList.size();
        for (int index2 = 0; index2 < n; ++index2) {
            Object current = phasesList.get(index2);
            if (current == phase) {
                PhaseContent content2 = new PhaseContent(phase, PipelinePhaseRelation.Last.INSTANCE);
                phasesList.set(index2, content2);
                return content2;
            }
            if (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase) continue;
            return (PhaseContent)current;
        }
        return null;
    }

    private final int findPhaseIndex(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = phasesList.size();
        for (int index2 = 0; index2 < n; ++index2) {
            Object current = phasesList.get(index2);
            if (current != phase && (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase)) continue;
            return index2;
        }
        return -1;
    }

    private final boolean hasPhase(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = phasesList.size();
        for (int index2 = 0; index2 < n; ++index2) {
            Object current = phasesList.get(index2);
            if (current != phase && (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase)) continue;
            return true;
        }
        return false;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> cacheInterceptors() {
        int n;
        int phaseIndex;
        int interceptorsQuantity = this.interceptorsQuantity;
        if (interceptorsQuantity == 0) {
            this.notSharedInterceptorsList(CollectionsKt.emptyList());
            return CollectionsKt.emptyList();
        }
        List<Object> phases = this.phasesRaw;
        if (interceptorsQuantity == 1 && (phaseIndex = 0) <= (n = CollectionsKt.getLastIndex(phases))) {
            while (true) {
                PhaseContent phaseContent;
                Object object;
                PhaseContent phaseContent2 = (object = phases.get(phaseIndex)) instanceof PhaseContent ? (PhaseContent)object : null;
                if (phaseContent2 != null && !(phaseContent = phaseContent2).isEmpty()) {
                    List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptors = phaseContent.sharedInterceptors();
                    this.setInterceptorsListFromPhase(phaseContent);
                    return interceptors;
                }
                if (phaseIndex == n) break;
                ++phaseIndex;
            }
        }
        List destination = new ArrayList();
        int phaseIndex2 = 0;
        int n2 = CollectionsKt.getLastIndex(phases);
        if (phaseIndex2 <= n2) {
            while (true) {
                Object object;
                if (((object = phases.get(phaseIndex2)) instanceof PhaseContent ? (PhaseContent)object : null) != null) {
                    PhaseContent phase;
                    phase = phase;
                    phase.addTo(destination);
                }
                if (phaseIndex2 == n2) break;
                ++phaseIndex2;
            }
        }
        this.notSharedInterceptorsList(destination);
        return destination;
    }

    private final boolean fastPathMerge(Pipeline<TSubject, TContext> from2) {
        if (from2.phasesRaw.isEmpty()) {
            return true;
        }
        if (!((Collection)this.phasesRaw).isEmpty()) {
            return false;
        }
        int index2 = 0;
        List<Object> fromPhases = from2.phasesRaw;
        int n = CollectionsKt.getLastIndex(fromPhases);
        if (index2 <= n) {
            while (true) {
                Object fromPhaseOrContent;
                if ((fromPhaseOrContent = fromPhases.get(index2)) instanceof PipelinePhase) {
                    this.phasesRaw.add(fromPhaseOrContent);
                } else if (fromPhaseOrContent instanceof PhaseContent) {
                    PhaseContent cfr_ignored_0 = (PhaseContent)fromPhaseOrContent;
                    this.phasesRaw.add(new PhaseContent(((PhaseContent)fromPhaseOrContent).getPhase(), ((PhaseContent)fromPhaseOrContent).getRelation(), ((PhaseContent)fromPhaseOrContent).sharedInterceptors()));
                }
                if (index2 == n) break;
                ++index2;
            }
        }
        this.interceptorsQuantity += from2.interceptorsQuantity;
        this.setInterceptorsListFromAnotherPipeline(from2);
        return true;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> sharedInterceptorsList() {
        if (this.getInterceptors() == null) {
            this.cacheInterceptors();
        }
        this.interceptorsListShared = true;
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> list2 = this.getInterceptors();
        Intrinsics.checkNotNull(list2);
        return list2;
    }

    private final void resetInterceptorsList() {
        this.setInterceptors(null);
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = null;
    }

    private final void notSharedInterceptorsList(List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> list2) {
        this.setInterceptors(list2);
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = null;
    }

    private final void setInterceptorsListFromPhase(PhaseContent<TSubject, TContext> phaseContent) {
        this.setInterceptors(phaseContent.sharedInterceptors());
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = phaseContent.getPhase();
    }

    private final void setInterceptorsListFromAnotherPipeline(Pipeline<TSubject, TContext> pipeline) {
        this.setInterceptors(super.sharedInterceptorsList());
        this.interceptorsListShared = true;
        this.interceptorsListSharedPhase = null;
    }

    private final boolean tryAddToPhaseFastPath(PipelinePhase phase, Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> block2) {
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> currentInterceptors = this.getInterceptors();
        if (this.phasesRaw.isEmpty() || currentInterceptors == null) {
            return false;
        }
        if (this.interceptorsListShared || !TypeIntrinsics.isMutableList(currentInterceptors)) {
            return false;
        }
        if (Intrinsics.areEqual(this.interceptorsListSharedPhase, phase)) {
            currentInterceptors.add(block2);
            return true;
        }
        if (Intrinsics.areEqual(phase, CollectionsKt.last(this.phasesRaw)) || this.findPhaseIndex(phase) == CollectionsKt.getLastIndex(this.phasesRaw)) {
            PhaseContent<? super TSubject, TContext> phaseContent = this.findPhase(phase);
            Intrinsics.checkNotNull(phaseContent);
            phaseContent.addInterceptor(block2);
            currentInterceptors.add(block2);
            return true;
        }
        return false;
    }

    private final boolean insertRelativePhase(Object fromPhaseOrContent, PipelinePhase fromPhase) {
        PipelinePhaseRelation pipelinePhaseRelation;
        if (fromPhaseOrContent == fromPhase) {
            pipelinePhaseRelation = PipelinePhaseRelation.Last.INSTANCE;
        } else {
            Intrinsics.checkNotNull(fromPhaseOrContent, "null cannot be cast to non-null type io.ktor.util.pipeline.PhaseContent<*, *>");
            pipelinePhaseRelation = ((PhaseContent)fromPhaseOrContent).getRelation();
        }
        PipelinePhaseRelation fromPhaseRelation = pipelinePhaseRelation;
        if (fromPhaseRelation instanceof PipelinePhaseRelation.Last) {
            this.addPhase(fromPhase);
        } else if (fromPhaseRelation instanceof PipelinePhaseRelation.Before && this.hasPhase(((PipelinePhaseRelation.Before)fromPhaseRelation).getRelativeTo())) {
            this.insertPhaseBefore(((PipelinePhaseRelation.Before)fromPhaseRelation).getRelativeTo(), fromPhase);
        } else if (fromPhaseRelation instanceof PipelinePhaseRelation.After) {
            this.insertPhaseAfter(((PipelinePhaseRelation.After)fromPhaseRelation).getRelativeTo(), fromPhase);
        } else {
            return false;
        }
        return true;
    }
}

