/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.resources.MissingResourceException;
import org.jetbrains.compose.resources.ResourceReader;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u00a8\u0006\u0002"}, d2={"getPlatformResourceReader", "Lorg/jetbrains/compose/resources/ResourceReader;", "library"})
public final class ResourceReader_desktopKt {
    @NotNull
    public static final ResourceReader getPlatformResourceReader() {
        return new ResourceReader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object read(String path, Continuation<? super byte[]> $completion) {
                byte[] byArray;
                InputStream resource2 = this.getResourceAsStream(path);
                Closeable closeable = resource2;
                Throwable throwable = null;
                try {
                    InputStream input2 = (InputStream)closeable;
                    boolean bl = false;
                    byArray = ByteStreamsKt.readBytes(input2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                return byArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object readPart(String path, long offset, long size2, Continuation<? super byte[]> $completion) {
                InputStream resource2 = this.getResourceAsStream(path);
                byte[] result2 = new byte[(int)size2];
                Closeable closeable = resource2;
                Throwable throwable = null;
                try {
                    InputStream input2 = (InputStream)closeable;
                    boolean bl = false;
                    this.skipBytes(input2, offset);
                    int n = input2.readNBytes(result2, 0, (int)size2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                return result2;
            }

            private final void skipBytes(InputStream $this$skipBytes, long offset) {
                long count2;
                for (long skippedBytes = 0L; skippedBytes < offset && (count2 = $this$skipBytes.skip(offset - skippedBytes)) != 0L; skippedBytes += count2) {
                }
            }

            public String getUri(String path) {
                Intrinsics.checkNotNullParameter(path, "path");
                ClassLoader classLoader = this.getClassLoader();
                URL uRL = classLoader.getResource(path);
                if (uRL == null) {
                    throw new MissingResourceException(path);
                }
                URL resource2 = uRL;
                String string2 = resource2.toURI().toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                return string2;
            }

            private final InputStream getResourceAsStream(String path) {
                ClassLoader classLoader = this.getClassLoader();
                InputStream inputStream2 = classLoader.getResourceAsStream(path);
                if (inputStream2 == null) {
                    throw new MissingResourceException(path);
                }
                return inputStream2;
            }

            private final ClassLoader getClassLoader() {
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader == null) {
                    throw new IllegalStateException("Cannot find class loader".toString());
                }
                return classLoader;
            }
        };
    }
}

