/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.TagSet;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;
import org.jsoup.parser.TreeBuilder;
import org.jsoup.select.Elements;
import org.jspecify.annotations.Nullable;

public class XmlTreeBuilder
extends TreeBuilder {
    static final String XmlnsKey = "xmlns";
    static final String XmlnsPrefix = "xmlns:";
    private final ArrayDeque<HashMap<String, String>> namespacesStack = new ArrayDeque();
    private static final int maxQueueDepth = 256;

    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.preserveCase;
    }

    @Override
    protected void initialiseParse(Reader input2, String baseUri, Parser parser) {
        super.initialiseParse(input2, baseUri, parser);
        this.doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml).escapeMode(Entities.EscapeMode.xhtml).prettyPrint(false);
        this.namespacesStack.clear();
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("xml", "http://www.w3.org/XML/1998/namespace");
        ns.put("", "http://www.w3.org/XML/1998/namespace");
        this.namespacesStack.push(ns);
    }

    @Override
    void initialiseParseFragment(@Nullable Element context2) {
        super.initialiseParseFragment(context2);
        if (context2 == null) {
            return;
        }
        TokeniserState textState = context2.tag().textState();
        if (textState != null) {
            this.tokeniser.transition(textState);
        }
        Elements chain = context2.parents();
        chain.add(0, context2);
        for (int i2 = chain.size() - 1; i2 >= 0; --i2) {
            Element el = (Element)chain.get(i2);
            HashMap<String, String> namespaces = new HashMap<String, String>((Map)this.namespacesStack.peek());
            this.namespacesStack.push(namespaces);
            if (el.attributesSize() <= 0) continue;
            XmlTreeBuilder.processNamespaces(el.attributes(), namespaces);
        }
    }

    Document parse(Reader input2, String baseUri) {
        return this.parse(input2, baseUri, new Parser(this));
    }

    Document parse(String input2, String baseUri) {
        return this.parse(new StringReader(input2), baseUri, new Parser(this));
    }

    @Override
    List<Node> completeParseFragment() {
        return this.doc.childNodes();
    }

    @Override
    XmlTreeBuilder newInstance() {
        return new XmlTreeBuilder();
    }

    @Override
    public String defaultNamespace() {
        return "http://www.w3.org/XML/1998/namespace";
    }

    @Override
    TagSet defaultTagSet() {
        return new TagSet();
    }

    @Override
    protected boolean process(Token token) {
        this.currentToken = token;
        switch (token.type) {
            case StartTag: {
                this.insertElementFor(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insertCommentFor(token.asComment());
                break;
            }
            case Character: {
                this.insertCharacterFor(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insertDoctypeFor(token.asDoctype());
                break;
            }
            case XmlDecl: {
                this.insertXmlDeclarationFor(token.asXmlDecl());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    void insertElementFor(Token.StartTag startTag) {
        HashMap<String, String> namespaces = new HashMap<String, String>((Map)this.namespacesStack.peek());
        this.namespacesStack.push(namespaces);
        Attributes attributes = startTag.attributes;
        if (attributes != null) {
            attributes.deduplicate(this.settings);
            XmlTreeBuilder.processNamespaces(attributes, namespaces);
            XmlTreeBuilder.applyNamespacesToAttributes(attributes, namespaces);
        }
        String tagName = startTag.tagName.value();
        String ns = XmlTreeBuilder.resolveNamespace(tagName, namespaces);
        Tag tag = this.tagFor(tagName, startTag.normalName, ns, this.settings);
        Element el = new Element(tag, null, this.settings.normalizeAttributes(attributes));
        this.currentElement().appendChild(el);
        this.push(el);
        if (startTag.isSelfClosing()) {
            tag.setSeenSelfClose();
            this.pop();
        } else if (tag.isEmpty()) {
            this.pop();
        } else {
            TokeniserState textState = tag.textState();
            if (textState != null) {
                this.tokeniser.transition(textState);
            }
        }
    }

    private static void processNamespaces(Attributes attributes, HashMap<String, String> namespaces) {
        for (Attribute attr : attributes) {
            String key = attr.getKey();
            String value = attr.getValue();
            if (key.equals(XmlnsKey)) {
                namespaces.put("", value);
                continue;
            }
            if (!key.startsWith(XmlnsPrefix)) continue;
            String nsPrefix = key.substring(XmlnsPrefix.length());
            namespaces.put(nsPrefix, value);
        }
    }

    private static void applyNamespacesToAttributes(Attributes attributes, HashMap<String, String> namespaces) {
        HashMap<String, String> attrPrefix = new HashMap<String, String>();
        for (Attribute attribute : attributes) {
            String ns;
            String prefix = attribute.prefix();
            if (prefix.isEmpty() || prefix.equals(XmlnsKey) || (ns = namespaces.get(prefix)) == null) continue;
            attrPrefix.put("jsoup.xmlns-" + prefix, ns);
        }
        for (Map.Entry<String, String> entry : attrPrefix.entrySet()) {
            attributes.userData(entry.getKey(), entry.getValue());
        }
    }

    private static String resolveNamespace(String tagName, HashMap<String, String> namespaces) {
        String prefix;
        String ns = namespaces.get("");
        int pos = tagName.indexOf(58);
        if (pos > 0 && namespaces.containsKey(prefix = tagName.substring(0, pos))) {
            ns = namespaces.get(prefix);
        }
        return ns;
    }

    void insertLeafNode(LeafNode node2) {
        this.currentElement().appendChild(node2);
        this.onNodeInserted(node2);
    }

    void insertCommentFor(Token.Comment commentToken) {
        Comment comment = new Comment(commentToken.getData());
        this.insertLeafNode(comment);
    }

    void insertCharacterFor(Token.Character token) {
        String data2 = token.getData();
        LeafNode node2 = token.isCData() ? new CDataNode(data2) : (this.currentElement().tag().is(Tag.Data) ? new DataNode(data2) : new TextNode(data2));
        this.insertLeafNode(node2);
    }

    void insertDoctypeFor(Token.Doctype token) {
        DocumentType doctypeNode = new DocumentType(this.settings.normalizeTag(token.getName()), token.getPublicIdentifier(), token.getSystemIdentifier());
        doctypeNode.setPubSysKey(token.getPubSysKey());
        this.insertLeafNode(doctypeNode);
    }

    void insertXmlDeclarationFor(Token.XmlDecl token) {
        XmlDeclaration decl = new XmlDeclaration(token.name(), token.isDeclaration);
        if (token.attributes != null) {
            decl.attributes().addAll(token.attributes);
        }
        this.insertLeafNode(decl);
    }

    @Override
    Element pop() {
        this.namespacesStack.pop();
        return super.pop();
    }

    protected void popStackToClose(Token.EndTag endTag) {
        Element next2;
        int pos;
        String elName = this.settings.normalizeTag(endTag.name());
        Element firstFound = null;
        int bottom = this.stack.size() - 1;
        int upper = bottom >= 256 ? bottom - 256 : 0;
        for (pos = this.stack.size() - 1; pos >= upper; --pos) {
            next2 = (Element)this.stack.get(pos);
            if (!next2.nodeName().equals(elName)) continue;
            firstFound = next2;
            break;
        }
        if (firstFound == null) {
            return;
        }
        for (pos = this.stack.size() - 1; pos >= 0 && (next2 = this.pop()) != firstFound; --pos) {
        }
    }
}

