/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.Iterator;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeVisitor;

public class NodeTraversor {
    public static void traverse(NodeVisitor visitor2, Node root) {
        Validate.notNull(visitor2);
        Validate.notNull(root);
        Node node2 = root;
        int depth = 0;
        while (node2 != null) {
            Node parent = node2.parentNode();
            int origSize = parent != null ? parent.childNodeSize() : 0;
            Node next2 = node2.nextSibling();
            visitor2.head(node2, depth);
            if (parent != null && !node2.hasParent()) {
                if (origSize == parent.childNodeSize()) {
                    node2 = parent.childNode(node2.siblingIndex());
                } else {
                    node2 = next2;
                    if (node2 != null) continue;
                    node2 = parent;
                    --depth;
                    continue;
                }
            }
            if (node2.childNodeSize() > 0) {
                node2 = node2.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                assert (node2 != null);
                if (node2.nextSibling() != null || depth <= 0) break;
                visitor2.tail(node2, depth);
                node2 = node2.parentNode();
                --depth;
            }
            visitor2.tail(node2, depth);
            if (node2 == root) break;
            node2 = node2.nextSibling();
        }
    }

    public static void traverse(NodeVisitor visitor2, Elements elements) {
        Validate.notNull(visitor2);
        Validate.notNull(elements);
        for (Element el : elements) {
            NodeTraversor.traverse(visitor2, el);
        }
    }

    public static NodeFilter.FilterResult filter(NodeFilter filter2, Node root) {
        Node node2 = root;
        int depth = 0;
        while (node2 != null) {
            Node prev;
            NodeFilter.FilterResult result2 = filter2.head(node2, depth);
            if (result2 == NodeFilter.FilterResult.STOP) {
                return result2;
            }
            if (result2 == NodeFilter.FilterResult.CONTINUE && node2.childNodeSize() > 0) {
                node2 = node2.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                assert (node2 != null);
                if (node2.nextSibling() != null || depth <= 0) break;
                if ((result2 == NodeFilter.FilterResult.CONTINUE || result2 == NodeFilter.FilterResult.SKIP_CHILDREN) && (result2 = filter2.tail(node2, depth)) == NodeFilter.FilterResult.STOP) {
                    return result2;
                }
                prev = node2;
                node2 = node2.parentNode();
                --depth;
                if (result2 == NodeFilter.FilterResult.REMOVE) {
                    prev.remove();
                }
                result2 = NodeFilter.FilterResult.CONTINUE;
            }
            if ((result2 == NodeFilter.FilterResult.CONTINUE || result2 == NodeFilter.FilterResult.SKIP_CHILDREN) && (result2 = filter2.tail(node2, depth)) == NodeFilter.FilterResult.STOP) {
                return result2;
            }
            if (node2 == root) {
                return result2;
            }
            prev = node2;
            node2 = node2.nextSibling();
            if (result2 != NodeFilter.FilterResult.REMOVE) continue;
            prev.remove();
        }
        return NodeFilter.FilterResult.CONTINUE;
    }

    public static void filter(NodeFilter filter2, Elements elements) {
        Element el;
        Validate.notNull(filter2);
        Validate.notNull(elements);
        Iterator iterator2 = elements.iterator();
        while (iterator2.hasNext() && NodeTraversor.filter(filter2, el = (Element)iterator2.next()) != NodeFilter.FilterResult.STOP) {
        }
    }
}

