/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.account.setpassword;

import androidx.compose.runtime.internal.StabilityInferred;
import io.ktor.util.Base64Kt;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.datalayer.db.RespectSchoolDatabase;
import world.respect.datalayer.db.school.daos.PersonPasswordEntityDao;
import world.respect.datalayer.db.school.entities.PersonPasswordEntity;
import world.respect.libutil.ext.RandomStringKt;
import world.respect.libxxhash.XXStringHasher;
import world.respect.shared.domain.account.ForbiddenException;
import world.respect.shared.domain.account.setpassword.SetPasswordUseCase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096B\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lworld/respect/shared/domain/account/setpassword/SetPasswordUseDbImpl;", "Lworld/respect/shared/domain/account/setpassword/SetPasswordUseCase;", "schoolDb", "Lworld/respect/datalayer/db/RespectSchoolDatabase;", "xxHash", "Lworld/respect/libxxhash/XXStringHasher;", "<init>", "(Lworld/respect/datalayer/db/RespectSchoolDatabase;Lworld/respect/libxxhash/XXStringHasher;)V", "invoke", "", "request", "Lworld/respect/shared/domain/account/setpassword/SetPasswordUseCase$SetPasswordRequest;", "(Lworld/respect/shared/domain/account/setpassword/SetPasswordUseCase$SetPasswordRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "respect-lib-shared"})
@StabilityInferred(parameters=0)
public final class SetPasswordUseDbImpl
implements SetPasswordUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RespectSchoolDatabase schoolDb;
    @NotNull
    private final XXStringHasher xxHash;
    public static final int $stable = 8;
    public static final int DEFAULT_SALT_LEN = 16;
    public static final int DEFAULT_ITERATIONS = 10000;
    public static final int DEFAULT_KEY_LEN = 512;
    @NotNull
    public static final String KEY_ALGO = "PBKDF2WithHmacSHA1";

    public SetPasswordUseDbImpl(@NotNull RespectSchoolDatabase schoolDb, @NotNull XXStringHasher xxHash) {
        Intrinsics.checkNotNullParameter(schoolDb, "schoolDb");
        Intrinsics.checkNotNullParameter(xxHash, "xxHash");
        this.schoolDb = schoolDb;
        this.xxHash = xxHash;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull SetPasswordUseCase.SetPasswordRequest request2, @NotNull Continuation<? super Unit> $completion) {
        if (Intrinsics.areEqual(request2.getAuthenticatedUserId().getGuid(), "directory-admin") || Intrinsics.areEqual(request2.getUserGuid(), request2.getAuthenticatedUserId().getGuid())) {
            String salt = RandomStringKt.randomString$default(16, null, 2, null);
            char[] cArray = request2.getPassword().toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
            String string2 = salt;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            PBEKeySpec keySpec = new PBEKeySpec(cArray, byArray, 10000, 512);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_ALGO);
            PersonPasswordEntityDao personPasswordEntityDao = this.schoolDb.getPersonPasswordEntityDao();
            long l = this.xxHash.hash(request2.getUserGuid());
            byte[] byArray2 = keyFactory.generateSecret(keySpec).getEncoded();
            Intrinsics.checkNotNullExpressionValue(byArray2, "getEncoded(...)");
            Object object = personPasswordEntityDao.upsert(new PersonPasswordEntity(l, KEY_ALGO, Base64Kt.encodeBase64(byArray2), salt, 10000, 512), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        throw new ForbiddenException("Authenticated user not allowed to set password for this user", null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lworld/respect/shared/domain/account/setpassword/SetPasswordUseDbImpl$Companion;", "", "<init>", "()V", "DEFAULT_SALT_LEN", "", "DEFAULT_ITERATIONS", "DEFAULT_KEY_LEN", "KEY_ALGO", "", "respect-lib-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

