/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.driver.bundled;

import androidx.annotation.RestrictTo;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteDriver;
import androidx.sqlite.driver.bundled.BundledSQLiteConnection;
import androidx.sqlite.driver.bundled.BundledSQLiteDriverKt;
import androidx.sqlite.driver.bundled.NativeLibraryLoader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Landroidx/sqlite/driver/bundled/BundledSQLiteDriver;", "Landroidx/sqlite/SQLiteDriver;", "<init>", "()V", "threadingMode", "", "getThreadingMode", "()I", "open", "Landroidx/sqlite/SQLiteConnection;", "fileName", "", "flags", "NativeLibraryObject", "sqlite-bundled"})
public final class BundledSQLiteDriver
implements SQLiteDriver {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public final int getThreadingMode() {
        return BundledSQLiteDriverKt.access$nativeThreadSafeMode();
    }

    @NotNull
    public SQLiteConnection open(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.open(fileName, 6);
    }

    @NotNull
    public final SQLiteConnection open(@NotNull String fileName, int flags) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        long address = BundledSQLiteDriverKt.access$nativeOpen(fileName, flags);
        return new BundledSQLiteConnection(address);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Landroidx/sqlite/driver/bundled/BundledSQLiteDriver$NativeLibraryObject;", "", "<init>", "()V", "sqlite-bundled"})
    private static final class NativeLibraryObject {
        @NotNull
        public static final NativeLibraryObject INSTANCE = new NativeLibraryObject();

        private NativeLibraryObject() {
        }

        static {
            NativeLibraryLoader.INSTANCE.loadLibrary("sqliteJni");
        }
    }
}

